/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.rate.limiter.api.AcceptableRate$;
import org.apache.james.rate.limiter.api.RateExceeded$;
import org.apache.james.rate.limiter.api.RateLimiter;
import org.apache.james.rate.limiter.api.RateLimiterFactory;
import org.apache.james.rate.limiter.api.RateLimitingResult;
import org.apache.james.rate.limiter.api.Rules;
import org.apache.james.transport.mailets.ConfigurationOps$;
import org.apache.james.transport.mailets.Count$;
import org.apache.james.transport.mailets.EntityType;
import org.apache.james.transport.mailets.EntityType$;
import org.apache.james.transport.mailets.KeyPrefix;
import org.apache.james.transport.mailets.KeyPrefix$;
import org.apache.james.transport.mailets.PerSenderRateLimiter;
import org.apache.james.transport.mailets.Recipients$;
import org.apache.james.transport.mailets.Size$;
import org.apache.james.transport.mailets.TotalSize$;
import org.apache.mailet.Mail;
import org.apache.mailet.ProcessingState;
import org.apache.mailet.base.GenericMailet;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.jdk.DurationConverters;
import scala.jdk.DurationConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001\u0002\u0010 \u0001)B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006}\u0001!\ta\u0010\u0005\n\u0019\u0002\u0001\r\u00111A\u0005\n5C\u0011\"\u0015\u0001A\u0002\u0003\u0007I\u0011\u0002*\t\u0013m\u0003\u0001\u0019!A!B\u0013q\u0005\"\u0003/\u0001\u0001\u0004\u0005\r\u0011\"\u0003N\u0011%i\u0006\u00011AA\u0002\u0013%a\fC\u0005a\u0001\u0001\u0007\t\u0011)Q\u0005\u001d\"I\u0011\r\u0001a\u0001\u0002\u0004%I!\u0014\u0005\nE\u0002\u0001\r\u00111A\u0005\n\rD\u0011\"\u001a\u0001A\u0002\u0003\u0005\u000b\u0015\u0002(\t\u0013\u0019\u0004\u0001\u0019!a\u0001\n\u0013i\u0005\"C4\u0001\u0001\u0004\u0005\r\u0011\"\u0003i\u0011%Q\u0007\u00011A\u0001B\u0003&a\nC\u0005l\u0001\u0001\u0007\t\u0019!C\u0005Y\"I\u0001\u0010\u0001a\u0001\u0002\u0004%I!\u001f\u0005\nw\u0002\u0001\r\u0011!Q!\n5D\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011B?\t\u0017\u0005%\u0001\u00011AA\u0002\u0013%\u00111\u0002\u0005\u000b\u0003\u001f\u0001\u0001\u0019!A!B\u0013q\bbCA\t\u0001\u0001\u0007\t\u0019!C\u0005\u0003'A1\"a\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002*!Y\u0011Q\u0006\u0001A\u0002\u0003\u0005\u000b\u0015BA\u000b\u0011\u001d\ty\u0003\u0001C!\u0003cAq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002R\u0001!\t%a\u0015\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d!9\u0011q\u000f\u0001\u0005\n\u0005e\u0004bBAI\u0001\u0011\u0005\u00131\u0013\u0002\u0013!\u0016\u00148+\u001a8eKJ\u0014\u0016\r^3MS6LGO\u0003\u0002!C\u00059Q.Y5mKR\u001c(B\u0001\u0012$\u0003%!(/\u00198ta>\u0014HO\u0003\u0002%K\u0005)!.Y7fg*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0016\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013\u0001\u00022bg\u0016T!\u0001M\u0013\u0002\r5\f\u0017\u000e\\3u\u0013\t\u0011TFA\u0007HK:,'/[2NC&dW\r^\u0001\u0013e\u0006$X\rT5nSR,'OR1di>\u0014\u0018\u0010\u0005\u00026y5\taG\u0003\u00028q\u0005\u0019\u0011\r]5\u000b\u0005eR\u0014a\u00027j[&$XM\u001d\u0006\u0003w\r\nAA]1uK&\u0011QH\u000e\u0002\u0013%\u0006$X\rT5nSR,'OR1di>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0003\u0001\n\u0003\"!\u0011\u0001\u000e\u0003}AQa\r\u0002A\u0002QB#A\u0001#\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015AB5oU\u0016\u001cGOC\u0001J\u0003\u001dQ\u0017m[1si\u0006L!a\u0013$\u0003\r%s'.Z2u\u0003A\u0019w.\u001e8u%\u0006$X\rT5nSR,'/F\u0001O!\t\tu*\u0003\u0002Q?\t!\u0002+\u001a:TK:$WM\u001d*bi\u0016d\u0015.\\5uKJ\fAcY8v]R\u0014\u0016\r^3MS6LG/\u001a:`I\u0015\fHCA*Z!\t!v+D\u0001V\u0015\u00051\u0016!B:dC2\f\u0017B\u0001-V\u0005\u0011)f.\u001b;\t\u000fi#\u0011\u0011!a\u0001\u001d\u0006\u0019\u0001\u0010J\u0019\u0002#\r|WO\u001c;SCR,G*[7ji\u0016\u0014\b%A\u000bsK\u000eL\u0007/[3oiN\u0014\u0016\r^3MS6LG/\u001a:\u00023I,7-\u001b9jK:$8OU1uK2KW.\u001b;fe~#S-\u001d\u000b\u0003'~CqAW\u0004\u0002\u0002\u0003\u0007a*\u0001\fsK\u000eL\u0007/[3oiN\u0014\u0016\r^3MS6LG/\u001a:!\u0003=\u0019\u0018N_3SCR,G*[7ji\u0016\u0014\u0018aE:ju\u0016\u0014\u0016\r^3MS6LG/\u001a:`I\u0015\fHCA*e\u0011\u001dQ&\"!AA\u00029\u000b\u0001c]5{KJ\u000bG/\u001a'j[&$XM\u001d\u0011\u0002)Q|G/\u00197TSj,'+\u0019;f\u0019&l\u0017\u000e^3s\u0003a!x\u000e^1m'&TXMU1uK2KW.\u001b;fe~#S-\u001d\u000b\u0003'&DqAW\u0007\u0002\u0002\u0003\u0007a*A\u000bu_R\fGnU5{KJ\u000bG/\u001a'j[&$XM\u001d\u0011\u0002#\u0015D8-Z3eK\u0012\u0004&o\\2fgN|'/F\u0001n!\tqWO\u0004\u0002pgB\u0011\u0001/V\u0007\u0002c*\u0011!/K\u0001\u0007yI|w\u000e\u001e \n\u0005Q,\u0016A\u0002)sK\u0012,g-\u0003\u0002wo\n11\u000b\u001e:j]\u001eT!\u0001^+\u0002+\u0015D8-Z3eK\u0012\u0004&o\\2fgN|'o\u0018\u0013fcR\u00111K\u001f\u0005\b5B\t\t\u00111\u0001n\u0003I)\u0007pY3fI\u0016$\u0007K]8dKN\u001cxN\u001d\u0011\u0002\u0013-,\u0017\u0010\u0015:fM&DX#\u0001@\u0011\tQ{\u00181A\u0005\u0004\u0003\u0003)&AB(qi&|g\u000eE\u0002B\u0003\u000bI1!a\u0002 \u0005%YU-\u001f)sK\u001aL\u00070A\u0007lKf\u0004&/\u001a4jq~#S-\u001d\u000b\u0004'\u00065\u0001b\u0002.\u0014\u0003\u0003\u0005\rA`\u0001\u000bW\u0016L\bK]3gSb\u0004\u0013A\u0005:bi\u0016d\u0015.\\5uKJ$\u0016.\\3pkR,\"!!\u0006\u0011\tQ{\u0018q\u0003\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u0011!\u0018.\\3\u000b\u0005\u0005\u0005\u0012\u0001\u00026bm\u0006LA!!\n\u0002\u001c\tAA)\u001e:bi&|g.\u0001\fsCR,G*[7ji\u0016\u0014H+[7f_V$x\fJ3r)\r\u0019\u00161\u0006\u0005\t5Z\t\t\u00111\u0001\u0002\u0016\u0005\u0019\"/\u0019;f\u0019&l\u0017\u000e^3s)&lWm\\;uA\u0005!\u0011N\\5u)\u0005\u0019\u0016!\u00049beN,G)\u001e:bi&|g\u000e\u0006\u0002\u0002\u0018!\u001a\u0011$!\u000f\u0011\t\u0005m\u0012QJ\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011\t\u0019%!\u0012\u0002\r\r|W.\\8o\u0015\u0011\t9%!\u0013\u0002\r\u001d|wn\u001a7f\u0015\t\tY%A\u0002d_6LA!a\u0014\u0002>\t\tb+[:jE2,gi\u001c:UKN$\u0018N\\4\u0002\u000fM,'O^5dKR\u00191+!\u0016\t\u000f\u0005]#\u00041\u0001\u0002Z\u0005!Q.Y5m!\u0011\tY&!\u0018\u000e\u0003=J1!a\u00180\u0005\u0011i\u0015-\u001b7\u0002!\u0005\u0004\b\u000f\\=SCR,G*[7ji\u0016\u0014H#B*\u0002f\u0005\u001d\u0004bBA,7\u0001\u0007\u0011\u0011\f\u0005\b\u0003SZ\u0002\u0019AA6\u0003\u0019\u0019XM\u001c3feB!\u0011QNA:\u001b\t\tyGC\u0002\u0002r\r\nAaY8sK&!\u0011QOA8\u0005-i\u0015-\u001b7BI\u0012\u0014Xm]:\u0002#\r\u0014X-\u0019;f%\u0006$X\rT5nSR,'\u000fF\u0006O\u0003w\ni(a\"\u0002\n\u00065\u0005\"B\u001a\u001d\u0001\u0004!\u0004bBA@9\u0001\u0007\u0011\u0011Q\u0001\u000bK:$\u0018\u000e^=UsB,\u0007cA!\u0002\u0004&\u0019\u0011QQ\u0010\u0003\u0015\u0015sG/\u001b;z)f\u0004X\rC\u0003}9\u0001\u0007a\u0010C\u0004\u0002\fr\u0001\r!a\u0006\u0002\u0011\u0011,(/\u0019;j_:Dq!a$\u001d\u0001\u0004\t)\"A\u0005qe\u0016\u001c\u0017n]5p]\u00069\"/Z9vSJ,G\r\u0015:pG\u0016\u001c8/\u001b8h'R\fG/\u001a\u000b\u0003\u0003+\u0003b!a&\u0002\u001e\u0006\u0005VBAAM\u0015\u0011\tY*a\b\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003?\u000bIJ\u0001\u0006D_2dWm\u0019;j_:\u0004B!a\u0017\u0002$&\u0019\u0011QU\u0018\u0003\u001fA\u0013xnY3tg&twm\u0015;bi\u0016\u0004")
public class PerSenderRateLimit
extends GenericMailet {
    private final RateLimiterFactory rateLimiterFactory;
    private PerSenderRateLimiter countRateLimiter;
    private PerSenderRateLimiter recipientsRateLimiter;
    private PerSenderRateLimiter sizeRateLimiter;
    private PerSenderRateLimiter totalSizeRateLimiter;
    private String exceededProcessor;
    private Option<KeyPrefix> keyPrefix;
    private Option<java.time.Duration> rateLimiterTimeout;

    private PerSenderRateLimiter countRateLimiter() {
        return this.countRateLimiter;
    }

    private void countRateLimiter_$eq(PerSenderRateLimiter x$1) {
        this.countRateLimiter = x$1;
    }

    private PerSenderRateLimiter recipientsRateLimiter() {
        return this.recipientsRateLimiter;
    }

    private void recipientsRateLimiter_$eq(PerSenderRateLimiter x$1) {
        this.recipientsRateLimiter = x$1;
    }

    private PerSenderRateLimiter sizeRateLimiter() {
        return this.sizeRateLimiter;
    }

    private void sizeRateLimiter_$eq(PerSenderRateLimiter x$1) {
        this.sizeRateLimiter = x$1;
    }

    private PerSenderRateLimiter totalSizeRateLimiter() {
        return this.totalSizeRateLimiter;
    }

    private void totalSizeRateLimiter_$eq(PerSenderRateLimiter x$1) {
        this.totalSizeRateLimiter = x$1;
    }

    private String exceededProcessor() {
        return this.exceededProcessor;
    }

    private void exceededProcessor_$eq(String x$1) {
        this.exceededProcessor = x$1;
    }

    private Option<KeyPrefix> keyPrefix() {
        return this.keyPrefix;
    }

    private void keyPrefix_$eq(Option<KeyPrefix> x$1) {
        this.keyPrefix = x$1;
    }

    private Option<java.time.Duration> rateLimiterTimeout() {
        return this.rateLimiterTimeout;
    }

    private void rateLimiterTimeout_$eq(Option<java.time.Duration> x$1) {
        this.rateLimiterTimeout = x$1;
    }

    public void init() {
        java.time.Duration duration = this.parseDuration();
        Option<java.time.Duration> precision = ConfigurationOps$.MODULE$.DurationOps(this.getMailetConfig()).getDuration("precision");
        this.keyPrefix_$eq((Option<KeyPrefix>)Option$.MODULE$.apply((Object)this.getInitParameter("keyPrefix")).map((Function1)KeyPrefix$.MODULE$));
        this.exceededProcessor_$eq(this.getInitParameter("exceededProcessor", "error"));
        this.rateLimiterTimeout_$eq(ConfigurationOps$.MODULE$.DurationOps(this.getMailetConfig()).getDuration("rateLimiterTimeout"));
        Preconditions.checkArgument((this.rateLimiterTimeout().isEmpty() || ((java.time.Duration)this.rateLimiterTimeout().get()).isPositive() ? 1 : 0) != 0, (Object)"rateLimiterTimeout can not be negative");
        this.countRateLimiter_$eq(this.perSenderRateLimiter$1(Count$.MODULE$, duration, precision));
        this.recipientsRateLimiter_$eq(this.perSenderRateLimiter$1(Recipients$.MODULE$, duration, precision));
        this.sizeRateLimiter_$eq(this.perSenderRateLimiter$1(Size$.MODULE$, duration, precision));
        this.totalSizeRateLimiter_$eq(this.perSenderRateLimiter$1(TotalSize$.MODULE$, duration, precision));
    }

    @VisibleForTesting
    public java.time.Duration parseDuration() {
        return (java.time.Duration)ConfigurationOps$.MODULE$.DurationOps(this.getMailetConfig()).getDuration("duration").getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("'duration' is compulsory");
        });
    }

    public void service(Mail mail) {
        mail.getMaybeSender().asOptional().ifPresent(sender -> this.applyRateLimiter(mail, (MailAddress)sender));
    }

    private void applyRateLimiter(Mail mail, MailAddress sender) {
        AcceptableRate$ pivot = AcceptableRate$.MODULE$;
        SMono applyRateLimiterPublisher = SFlux$.MODULE$.merge((Seq)new .colon.colon(this.countRateLimiter().rateLimit(sender, mail), (List)new .colon.colon(this.recipientsRateLimiter().rateLimit(sender, mail), (List)new .colon.colon(this.sizeRateLimiter().rateLimit(sender, mail), (List)new .colon.colon(this.totalSizeRateLimiter().rateLimit(sender, mail), (List)Nil$.MODULE$)))), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).fold((Object)pivot, (Function2 & Serializable)(a, b) -> a.merge((RateLimitingResult)b));
        RateLimitingResult result = (RateLimitingResult)this.rateLimiterTimeout().map((Function1 & Serializable)timeout -> (RateLimitingResult)applyRateLimiterPublisher.block((Duration)DurationConverters.JavaDurationOps$.MODULE$.toScala$extension(DurationConverters$.MODULE$.JavaDurationOps(timeout)))).getOrElse((Function0 & Serializable)() -> (RateLimitingResult)applyRateLimiterPublisher.block(applyRateLimiterPublisher.block$default$1()));
        if (result.equals(RateExceeded$.MODULE$)) {
            mail.setState(this.exceededProcessor());
            return;
        }
    }

    private PerSenderRateLimiter createRateLimiter(RateLimiterFactory rateLimiterFactory, EntityType entityType, Option<KeyPrefix> keyPrefix, java.time.Duration duration, Option<java.time.Duration> precision) {
        return new PerSenderRateLimiter((Option<RateLimiter>)EntityType$.MODULE$.extractRules(entityType, duration, this.getMailetConfig()).map((Function1 & Serializable)x$8 -> rateLimiterFactory.withSpecification((Rules)x$8, precision)), keyPrefix, entityType);
    }

    public Collection<ProcessingState> requiredProcessingState() {
        return ImmutableList.of((Object)new ProcessingState(this.exceededProcessor()));
    }

    private final PerSenderRateLimiter perSenderRateLimiter$1(EntityType entityType, java.time.Duration duration$1, Option precision$1) {
        return this.createRateLimiter(this.rateLimiterFactory, entityType, this.keyPrefix(), duration$1, (Option<java.time.Duration>)precision$1);
    }

    @Inject
    public PerSenderRateLimit(RateLimiterFactory rateLimiterFactory) {
        this.rateLimiterFactory = rateLimiterFactory;
    }
}

