/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.rate.limiter.api.AcceptableRate$;
import org.apache.james.rate.limiter.api.RateExceeded$;
import org.apache.james.rate.limiter.api.RateLimiter;
import org.apache.james.rate.limiter.api.RateLimiterFactory;
import org.apache.james.rate.limiter.api.RateLimitingResult;
import org.apache.james.rate.limiter.api.Rules;
import org.apache.james.transport.mailets.ConfigurationOps$;
import org.apache.james.transport.mailets.Count$;
import org.apache.james.transport.mailets.EntityType;
import org.apache.james.transport.mailets.EntityType$;
import org.apache.james.transport.mailets.KeyPrefix;
import org.apache.james.transport.mailets.KeyPrefix$;
import org.apache.james.transport.mailets.PerRecipientRateLimiter;
import org.apache.james.transport.mailets.Size$;
import org.apache.mailet.Mail;
import org.apache.mailet.ProcessingState;
import org.apache.mailet.base.GenericMailet;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.jdk.DurationConverters;
import scala.jdk.DurationConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001\u0002\n\u0014\u0001yA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006e\u0001!\ta\r\u0005\n\u0001\u0002\u0001\r\u00111A\u0005\n\u0005C\u0011b\u0014\u0001A\u0002\u0003\u0007I\u0011\u0002)\t\u0013]\u0003\u0001\u0019!A!B\u0013\u0011\u0005\"\u0003-\u0001\u0001\u0004\u0005\r\u0011\"\u0003Z\u0011%1\u0007\u00011AA\u0002\u0013%q\rC\u0005j\u0001\u0001\u0007\t\u0011)Q\u00055\"I!\u000e\u0001a\u0001\u0002\u0004%Ia\u001b\u0005\no\u0002\u0001\r\u00111A\u0005\naD\u0011B\u001f\u0001A\u0002\u0003\u0005\u000b\u0015\u00027\t\u000bm\u0004A\u0011\t?\t\u000bu\u0004A\u0011\t@\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002bBA(\u0001\u0011%\u0011\u0011\u000b\u0005\b\u0003_\u0002A\u0011IA9\u0005U\u0001VM\u001d*fG&\u0004\u0018.\u001a8u%\u0006$X\rT5nSRT!\u0001F\u000b\u0002\u000f5\f\u0017\u000e\\3ug*\u0011acF\u0001\niJ\fgn\u001d9peRT!\u0001G\r\u0002\u000b)\fW.Z:\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0004\u0005\u0002!K5\t\u0011E\u0003\u0002#G\u0005!!-Y:f\u0015\t!\u0013$\u0001\u0004nC&dW\r^\u0005\u0003M\u0005\u0012QbR3oKJL7-T1jY\u0016$\u0018A\u0005:bi\u0016d\u0015.\\5uKJ4\u0015m\u0019;pef\u0004\"!\u000b\u0019\u000e\u0003)R!a\u000b\u0017\u0002\u0007\u0005\u0004\u0018N\u0003\u0002.]\u00059A.[7ji\u0016\u0014(BA\u0018\u0018\u0003\u0011\u0011\u0018\r^3\n\u0005ER#A\u0005*bi\u0016d\u0015.\\5uKJ4\u0015m\u0019;pef\fa\u0001P5oSRtDC\u0001\u001b7!\t)\u0004!D\u0001\u0014\u0011\u00159#\u00011\u0001)Q\t\u0011\u0001\b\u0005\u0002:}5\t!H\u0003\u0002<y\u00051\u0011N\u001c6fGRT\u0011!P\u0001\bU\u0006\\\u0017M\u001d;b\u0013\ty$H\u0001\u0004J]*,7\r^\u0001\u0012Kb\u001cW-\u001a3fIB\u0013xnY3tg>\u0014X#\u0001\"\u0011\u0005\rceB\u0001#K!\t)\u0005*D\u0001G\u0015\t9U$\u0001\u0004=e>|GO\u0010\u0006\u0002\u0013\u0006)1oY1mC&\u00111\nS\u0001\u0007!J,G-\u001a4\n\u00055s%AB*ue&twM\u0003\u0002L\u0011\u0006)R\r_2fK\u0012,G\r\u0015:pG\u0016\u001c8o\u001c:`I\u0015\fHCA)V!\t\u00116+D\u0001I\u0013\t!\u0006J\u0001\u0003V]&$\bb\u0002,\u0005\u0003\u0003\u0005\rAQ\u0001\u0004q\u0012\n\u0014AE3yG\u0016,G-\u001a3Qe>\u001cWm]:pe\u0002\nAB]1uK2KW.\u001b;feN,\u0012A\u0017\t\u00047\u0002\u001cgB\u0001/_\u001d\t)U,C\u0001J\u0013\ty\u0006*A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0014'aA*fc*\u0011q\f\u0013\t\u0003k\u0011L!!Z\n\u0003/A+'OU3dSBLWM\u001c;SCR,G*[7ji\u0016\u0014\u0018\u0001\u0005:bi\u0016d\u0015.\\5uKJ\u001cx\fJ3r)\t\t\u0006\u000eC\u0004W\u000f\u0005\u0005\t\u0019\u0001.\u0002\u001bI\fG/\u001a'j[&$XM]:!\u0003I\u0011\u0018\r^3MS6LG/\u001a:US6,w.\u001e;\u0016\u00031\u00042AU7p\u0013\tq\u0007J\u0001\u0004PaRLwN\u001c\t\u0003aVl\u0011!\u001d\u0006\u0003eN\fA\u0001^5nK*\tA/\u0001\u0003kCZ\f\u0017B\u0001<r\u0005!!UO]1uS>t\u0017A\u0006:bi\u0016d\u0015.\\5uKJ$\u0016.\\3pkR|F%Z9\u0015\u0005EK\bb\u0002,\u000b\u0003\u0003\u0005\r\u0001\\\u0001\u0014e\u0006$X\rT5nSR,'\u000fV5nK>,H\u000fI\u0001\u0005S:LG\u000fF\u0001R\u0003\u001d\u0019XM\u001d<jG\u0016$\"!U@\t\u000f\u0005\u0005Q\u00021\u0001\u0002\u0004\u0005!Q.Y5m!\u0011\t)!a\u0002\u000e\u0003\rJ1!!\u0003$\u0005\u0011i\u0015-\u001b7\u0002\u001bA\f'o]3EkJ\fG/[8o)\u0005y\u0007f\u0001\b\u0002\u0012A!\u00111CA\u0013\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011aC1o]>$\u0018\r^5p]NTA!a\u0007\u0002\u001e\u000511m\\7n_:TA!a\b\u0002\"\u00051qm\\8hY\u0016T!!a\t\u0002\u0007\r|W.\u0003\u0003\u0002(\u0005U!!\u0005,jg&\u0014G.\u001a$peR+7\u000f^5oO\u0006\t2M]3bi\u0016\u0014\u0016\r^3MS6LG/\u001a:\u0015\u0019\u00055\u0012qFA\u001d\u0003{\t\t%a\u0011\u0011\u0007Ik7\rC\u0004\u00022=\u0001\r!a\r\u0002\u0015\u0015tG/\u001b;z)f\u0004X\rE\u00026\u0003kI1!a\u000e\u0014\u0005))e\u000e^5usRK\b/\u001a\u0005\u0007\u0003wy\u0001\u0019A8\u0002\u0011\u0011,(/\u0019;j_:Da!a\u0010\u0010\u0001\u0004a\u0017!\u00039sK\u000eL7/[8o\u0011\u00159s\u00021\u0001)\u0011\u001d\t)e\u0004a\u0001\u0003\u000f\n\u0011b[3z!J,g-\u001b=\u0011\tIk\u0017\u0011\n\t\u0004k\u0005-\u0013bAA''\tI1*Z=Qe\u00164\u0017\u000e_\u0001\u0011CB\u0004H.\u001f*bi\u0016d\u0015.\\5uKJ$B!a\u0015\u0002nA!1\fYA+!\u001d\u0011\u0016qKA.\u0003OJ1!!\u0017I\u0005\u0019!V\u000f\u001d7feA!\u0011QLA2\u001b\t\tyFC\u0002\u0002b]\tAaY8sK&!\u0011QMA0\u0005-i\u0015-\u001b7BI\u0012\u0014Xm]:\u0011\u0007%\nI'C\u0002\u0002l)\u0012!CU1uK2KW.\u001b;j]\u001e\u0014Vm];mi\"9\u0011\u0011\u0001\tA\u0002\u0005\r\u0011a\u0006:fcVL'/\u001a3Qe>\u001cWm]:j]\u001e\u001cF/\u0019;f)\t\t\u0019\b\u0005\u0004\u0002v\u0005m\u0014qP\u0007\u0003\u0003oR1!!\u001ft\u0003\u0011)H/\u001b7\n\t\u0005u\u0014q\u000f\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0003BA\u0003\u0003\u0003K1!a!$\u0005=\u0001&o\\2fgNLgnZ*uCR,\u0007")
public class PerRecipientRateLimit
extends GenericMailet {
    private final RateLimiterFactory rateLimiterFactory;
    private String exceededProcessor;
    private scala.collection.immutable.Seq<PerRecipientRateLimiter> rateLimiters;
    private Option<java.time.Duration> rateLimiterTimeout;

    private String exceededProcessor() {
        return this.exceededProcessor;
    }

    private void exceededProcessor_$eq(String x$1) {
        this.exceededProcessor = x$1;
    }

    private scala.collection.immutable.Seq<PerRecipientRateLimiter> rateLimiters() {
        return this.rateLimiters;
    }

    private void rateLimiters_$eq(scala.collection.immutable.Seq<PerRecipientRateLimiter> x$1) {
        this.rateLimiters = x$1;
    }

    private Option<java.time.Duration> rateLimiterTimeout() {
        return this.rateLimiterTimeout;
    }

    private void rateLimiterTimeout_$eq(Option<java.time.Duration> x$1) {
        this.rateLimiterTimeout = x$1;
    }

    public void init() {
        java.time.Duration duration = this.parseDuration();
        Option<java.time.Duration> precision = ConfigurationOps$.MODULE$.DurationOps(this.getMailetConfig()).getDuration("precision");
        Option keyPrefix = ConfigurationOps$.MODULE$.OptionOps(this.getMailetConfig()).getOptionalString("keyPrefix").map((Function1)KeyPrefix$.MODULE$);
        this.exceededProcessor_$eq((String)ConfigurationOps$.MODULE$.OptionOps(this.getMailetConfig()).getOptionalString("exceededProcessor").getOrElse((Function0 & Serializable)() -> "error"));
        this.rateLimiterTimeout_$eq(ConfigurationOps$.MODULE$.DurationOps(this.getMailetConfig()).getDuration("rateLimiterTimeout"));
        Preconditions.checkArgument((this.rateLimiterTimeout().isEmpty() || ((java.time.Duration)this.rateLimiterTimeout().get()).isPositive() ? 1 : 0) != 0, (Object)"rateLimiterTimeout can not be negative");
        this.rateLimiters_$eq((scala.collection.immutable.Seq<PerRecipientRateLimiter>)((scala.collection.immutable.Seq)new .colon.colon((Object)Size$.MODULE$, (List)new .colon.colon((Object)Count$.MODULE$, (List)Nil$.MODULE$)).flatMap((Function1 & Serializable)entityType -> this.perRecipientRateLimiter$1((EntityType)entityType, duration, (Option)precision, keyPrefix))));
    }

    public void service(Mail mail) {
        if (!mail.getRecipients().isEmpty()) {
            scala.collection.immutable.Seq exceeded;
            scala.collection.immutable.Seq acceptable;
            scala.collection.immutable.Seq<Tuple2<MailAddress, RateLimitingResult>> rateLimitResults = this.applyRateLimiter(mail);
            scala.collection.immutable.Seq rateLimitedRecipients = (scala.collection.immutable.Seq)((IterableOps)rateLimitResults.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PerRecipientRateLimit.$anonfun$service$1(x$4)))).map((Function1 & Serializable)x$5 -> (MailAddress)x$5._1());
            scala.collection.immutable.Seq acceptableRecipients = (scala.collection.immutable.Seq)((IterableOps)rateLimitResults.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PerRecipientRateLimit.$anonfun$service$3(x$6)))).map((Function1 & Serializable)x$7 -> (MailAddress)x$7._1());
            Tuple2 tuple2 = new Tuple2((Object)acceptableRecipients, (Object)rateLimitedRecipients);
            if (tuple2 != null && (acceptable = (scala.collection.immutable.Seq)tuple2._1()).isEmpty()) {
                mail.setState(this.exceededProcessor());
                return;
            }
            if (tuple2 != null && (exceeded = (scala.collection.immutable.Seq)tuple2._2()).isEmpty()) {
                return;
            }
            mail.setRecipients((Collection)ImmutableList.copyOf((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)acceptableRecipients).asJava()));
            Using$.MODULE$.apply((Function0 & Serializable)() -> mail.duplicate(), (Function1 & Serializable)newMail -> {
                PerRecipientRateLimit.$anonfun$service$6(this, rateLimitedRecipients, newMail);
                return BoxedUnit.UNIT;
            }, x$8 -> LifecycleUtil.dispose((Object)x$8));
            return;
        }
    }

    @VisibleForTesting
    public java.time.Duration parseDuration() {
        return (java.time.Duration)ConfigurationOps$.MODULE$.DurationOps(this.getMailetConfig()).getDuration("duration").getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("'duration' is compulsory");
        });
    }

    private Option<PerRecipientRateLimiter> createRateLimiter(EntityType entityType, java.time.Duration duration, Option<java.time.Duration> precision, RateLimiterFactory rateLimiterFactory, Option<KeyPrefix> keyPrefix) {
        return EntityType$.MODULE$.extractRules(entityType, duration, this.getMailetConfig()).map((Function1 & Serializable)x$9 -> rateLimiterFactory.withSpecification((Rules)x$9, precision)).map((Function1 & Serializable)x$10 -> new PerRecipientRateLimiter((RateLimiter)x$10, keyPrefix, entityType));
    }

    private scala.collection.immutable.Seq<Tuple2<MailAddress, RateLimitingResult>> applyRateLimiter(Mail mail) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(CollectionConverters$.MODULE$.CollectionHasAsScala(mail.getRecipients()).asScala());
        Function1 & Serializable x$1 = (Function1 & Serializable)recipient -> SFlux$.MODULE$.merge((scala.collection.immutable.Seq)this.rateLimiters().map((Function1 & Serializable)rateLimiter -> rateLimiter.rateLimit((MailAddress)recipient, mail)), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).fold((Object)AcceptableRate$.MODULE$, (Function2 & Serializable)(a, b) -> a.merge((RateLimitingResult)b)).map((Function1 & Serializable)rateLimitingResult -> new Tuple2(recipient, rateLimitingResult));
        int x$2 = 16;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        SMono applyRateLimiterPublisher = qual$1.flatMap((Function1)x$1, 16, x$3, x$4).collectSeq();
        return (scala.collection.immutable.Seq)this.rateLimiterTimeout().map((Function1 & Serializable)timeout -> (scala.collection.immutable.Seq)applyRateLimiterPublisher.block((Duration)DurationConverters.JavaDurationOps$.MODULE$.toScala$extension(DurationConverters$.MODULE$.JavaDurationOps(timeout)))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)applyRateLimiterPublisher.block(applyRateLimiterPublisher.block$default$1()));
    }

    public Collection<ProcessingState> requiredProcessingState() {
        return ImmutableList.of((Object)new ProcessingState(this.exceededProcessor()));
    }

    private final Option perRecipientRateLimiter$1(EntityType entityType, java.time.Duration duration$1, Option precision$1, Option keyPrefix$1) {
        return this.createRateLimiter(entityType, duration$1, (Option<java.time.Duration>)precision$1, this.rateLimiterFactory, (Option<KeyPrefix>)keyPrefix$1);
    }

    public static final /* synthetic */ boolean $anonfun$service$1(Tuple2 x$4) {
        return x$4._2().equals(RateExceeded$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$service$3(Tuple2 x$6) {
        return x$6._2().equals(AcceptableRate$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$service$6(PerRecipientRateLimit $this, scala.collection.immutable.Seq rateLimitedRecipients$1, Mail newMail) {
        newMail.setRecipients((Collection)ImmutableList.copyOf((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)rateLimitedRecipients$1).asJava()));
        $this.getMailetContext().sendMail(newMail, $this.exceededProcessor());
    }

    @Inject
    public PerRecipientRateLimit(RateLimiterFactory rateLimiterFactory) {
        this.rateLimiterFactory = rateLimiterFactory;
    }
}

