/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rate.limiter.redis;

import es.moki.ratelimitj.core.limiter.request.AbstractRequestRateLimiterFactory;
import es.moki.ratelimitj.core.limiter.request.ReactiveRequestRateLimiter;
import es.moki.ratelimitj.core.limiter.request.RequestLimitRule;
import es.moki.ratelimitj.core.limiter.request.RequestRateLimiter;
import es.moki.ratelimitj.redis.request.RedisSlidingWindowRequestRateLimiter;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.reactive.RedisKeyReactiveCommands;
import io.lettuce.core.api.reactive.RedisScriptingReactiveCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.masterreplica.MasterReplica;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import java.util.List;
import java.util.Set;

public class RedisMasterReplicaRateLimiterFactory
extends AbstractRequestRateLimiterFactory<RedisSlidingWindowRequestRateLimiter> {
    private final RedisClient client;
    private final List<RedisURI> redisURIs;
    private final ReadFrom readFrom;
    private StatefulRedisMasterReplicaConnection<String, String> connection;

    public RedisMasterReplicaRateLimiterFactory(RedisClient client, List<RedisURI> redisURIs, ReadFrom readFrom) {
        this.client = client;
        this.redisURIs = redisURIs;
        this.readFrom = readFrom;
    }

    public RedisMasterReplicaRateLimiterFactory(RedisClient client, List<RedisURI> redisURIs) {
        this(client, redisURIs, ReadFrom.MASTER);
    }

    protected RedisSlidingWindowRequestRateLimiter create(Set<RequestLimitRule> rules) {
        return new RedisSlidingWindowRequestRateLimiter((RedisScriptingReactiveCommands)this.getConnection().reactive(), (RedisKeyReactiveCommands)this.getConnection().reactive(), rules);
    }

    public RequestRateLimiter getInstance(Set<RequestLimitRule> rules) {
        return (RequestRateLimiter)this.lookupInstance(rules);
    }

    public ReactiveRequestRateLimiter getInstanceReactive(Set<RequestLimitRule> rules) {
        return (ReactiveRequestRateLimiter)this.lookupInstance(rules);
    }

    public void close() {
        this.client.shutdown();
    }

    private StatefulRedisMasterReplicaConnection<String, String> getConnection() {
        if (this.connection == null) {
            this.connection = MasterReplica.connect((RedisClient)this.client, (RedisCodec)StringCodec.UTF8, this.redisURIs);
            this.connection.setReadFrom(this.readFrom);
        }
        return this.connection;
    }
}

