/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rate.limiter.redis;

import es.moki.ratelimitj.core.limiter.request.AbstractRequestRateLimiterFactory;
import es.moki.ratelimitj.core.limiter.request.ReactiveRequestRateLimiter;
import es.moki.ratelimitj.core.limiter.request.RequestLimitRule;
import es.moki.ratelimitj.core.limiter.request.RequestRateLimiter;
import es.moki.ratelimitj.redis.request.RedisSlidingWindowRequestRateLimiter;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.api.reactive.RedisKeyReactiveCommands;
import io.lettuce.core.api.reactive.RedisScriptingReactiveCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import java.util.Objects;
import java.util.Set;

public class RedisClusterRateLimiterFactory
extends AbstractRequestRateLimiterFactory<RedisSlidingWindowRequestRateLimiter> {
    private final RedisClusterClient client;
    private StatefulRedisClusterConnection<String, String> connection;
    private final ReadFrom readFrom;

    public RedisClusterRateLimiterFactory(RedisClusterClient client, ReadFrom readFrom) {
        this.client = Objects.requireNonNull(client);
        this.readFrom = readFrom;
    }

    public RequestRateLimiter getInstance(Set<RequestLimitRule> rules) {
        return (RequestRateLimiter)this.lookupInstance(rules);
    }

    public ReactiveRequestRateLimiter getInstanceReactive(Set<RequestLimitRule> rules) {
        return (ReactiveRequestRateLimiter)this.lookupInstance(rules);
    }

    protected RedisSlidingWindowRequestRateLimiter create(Set<RequestLimitRule> rules) {
        this.getConnection().reactive();
        return new RedisSlidingWindowRequestRateLimiter((RedisScriptingReactiveCommands)this.getConnection().reactive(), (RedisKeyReactiveCommands)this.getConnection().reactive(), rules);
    }

    public void close() {
        this.client.shutdown();
    }

    private StatefulRedisClusterConnection<String, String> getConnection() {
        if (this.connection == null) {
            this.connection = this.client.connect();
            this.connection.setReadFrom(this.readFrom);
        }
        return this.connection;
    }
}

