/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailets.configuration;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailets.configuration.SerializableAsXml;
import org.apache.james.protocols.smtp.SMTPConfiguration;

public class SmtpConfiguration
implements SerializableAsXml {
    public static final boolean AUTH_REQUIRED = true;
    public static final SmtpConfiguration DEFAULT = SmtpConfiguration.builder().build();
    private final Optional<String> authorizedAddresses;
    private final boolean authRequired;
    private final boolean startTls;
    private final boolean bracketEnforcement;
    private final SMTPConfiguration.SenderVerificationMode verifyIndentity;
    private final String maxMessageSize;
    private final ImmutableList<HookConfigurationEntry> additionalHooks;

    public static Builder builder() {
        return new Builder();
    }

    private SmtpConfiguration(Optional<String> authorizedAddresses, boolean authRequired, boolean startTls, boolean bracketEnforcement, SMTPConfiguration.SenderVerificationMode verifyIndentity, String maxMessageSize, ImmutableList<HookConfigurationEntry> additionalHooks) {
        this.authorizedAddresses = authorizedAddresses;
        this.authRequired = authRequired;
        this.bracketEnforcement = bracketEnforcement;
        this.verifyIndentity = verifyIndentity;
        this.maxMessageSize = maxMessageSize;
        this.startTls = startTls;
        this.additionalHooks = additionalHooks;
    }

    @Override
    public String serializeAsXml() throws IOException {
        HashMap<String, Object> scopes = new HashMap<String, Object>();
        scopes.put("hasAuthorizedAddresses", this.authorizedAddresses.isPresent());
        this.authorizedAddresses.ifPresent(value -> scopes.put("authorizedAddresses", value));
        scopes.put("authRequired", this.authRequired);
        scopes.put("verifyIdentity", this.verifyIndentity.toString());
        scopes.put("maxmessagesize", this.maxMessageSize);
        scopes.put("bracketEnforcement", this.bracketEnforcement);
        scopes.put("startTls", this.startTls);
        List additionalHooksWithConfig = (List)this.additionalHooks.stream().map(HookConfigurationEntry::asMustacheScopes).collect(ImmutableList.toImmutableList());
        scopes.put("hooks", additionalHooksWithConfig);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(byteArrayOutputStream);
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile((Reader)this.getPatternReader(), "example");
        mustache.execute((Writer)writer, scopes);
        ((Writer)writer).flush();
        return byteArrayOutputStream.toString(StandardCharsets.UTF_8);
    }

    private StringReader getPatternReader() throws IOException {
        InputStream patternStream = ClassLoader.getSystemResourceAsStream("smtpserver.xml");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)patternStream, (OutputStream)byteArrayOutputStream);
        String pattern = byteArrayOutputStream.toString(StandardCharsets.UTF_8);
        return new StringReader(pattern);
    }

    public static class Builder {
        private static final String DEFAULT_DISABLED = "0";
        private Optional<Boolean> authRequired;
        private Optional<Boolean> startTls;
        private Optional<String> maxMessageSize;
        private Optional<SMTPConfiguration.SenderVerificationMode> verifyIndentity;
        private Optional<Boolean> bracketEnforcement;
        private Optional<String> authorizedAddresses = Optional.empty();
        private final ImmutableList.Builder<HookConfigurationEntry> additionalHooks;

        public Builder() {
            this.authRequired = Optional.empty();
            this.startTls = Optional.empty();
            this.verifyIndentity = Optional.empty();
            this.maxMessageSize = Optional.empty();
            this.bracketEnforcement = Optional.empty();
            this.additionalHooks = ImmutableList.builder();
        }

        public Builder withAutorizedAddresses(String authorizedAddresses) {
            Preconditions.checkNotNull((Object)authorizedAddresses);
            this.authorizedAddresses = Optional.of(authorizedAddresses);
            return this;
        }

        public Builder withMaxMessageSize(String size) {
            this.maxMessageSize = Optional.of(size);
            return this;
        }

        public Builder requireAuthentication() {
            this.authRequired = Optional.of(true);
            return this;
        }

        public Builder requireStartTls() {
            this.startTls = Optional.of(true);
            return this;
        }

        public Builder requireBracketEnforcement() {
            this.bracketEnforcement = Optional.of(true);
            return this;
        }

        public Builder doNotRequireBracketEnforcement() {
            this.bracketEnforcement = Optional.of(false);
            return this;
        }

        public Builder verifyIdentity() {
            this.verifyIndentity = Optional.of(SMTPConfiguration.SenderVerificationMode.STRICT);
            return this;
        }

        public Builder doNotVerifyIdentity() {
            this.verifyIndentity = Optional.of(SMTPConfiguration.SenderVerificationMode.DISABLED);
            return this;
        }

        public Builder relaxedIdentityVerification() {
            this.verifyIndentity = Optional.of(SMTPConfiguration.SenderVerificationMode.RELAXED);
            return this;
        }

        public Builder addHook(String hookFQCN) {
            this.additionalHooks.add((Object)new HookConfigurationEntry(hookFQCN));
            return this;
        }

        public Builder addHook(String hookFQCN, Map<String, String> hookConfig) {
            this.additionalHooks.add((Object)new HookConfigurationEntry(hookFQCN, hookConfig));
            return this;
        }

        public SmtpConfiguration build() {
            return new SmtpConfiguration(this.authorizedAddresses, this.authRequired.orElse(false), this.startTls.orElse(false), this.bracketEnforcement.orElse(true), this.verifyIndentity.orElse(SMTPConfiguration.SenderVerificationMode.DISABLED), this.maxMessageSize.orElse(DEFAULT_DISABLED), (ImmutableList<HookConfigurationEntry>)this.additionalHooks.build());
        }
    }

    static class HookConfigurationEntry {
        String hookFqcn;
        Map<String, String> hookConfig;

        HookConfigurationEntry(String hookFqcn, Map<String, String> hookConfig) {
            this.hookFqcn = hookFqcn;
            this.hookConfig = hookConfig;
        }

        HookConfigurationEntry(String hookFqcn) {
            this.hookFqcn = hookFqcn;
            this.hookConfig = new HashMap<String, String>();
        }

        private static Map<String, Object> asMustacheScopes(HookConfigurationEntry hook) {
            HashMap<String, Object> hookScope = new HashMap<String, Object>();
            hookScope.put("hookFqcn", hook.hookFqcn);
            hookScope.put("hookConfigAsXML", hook.hookConfig.entrySet());
            return hookScope;
        }
    }
}

