/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dnsservice.api;

import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.mock.MockDNSService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class AbstractDNSServiceTest {
    private static final DNSService DNS_SERVER = new MockDNSService(){

        @Override
        public String getHostName(InetAddress inet) {
            return inet.getCanonicalHostName();
        }

        @Override
        public Collection<InetAddress> getAllByName(String name) throws UnknownHostException {
            return ImmutableList.copyOf((Object[])InetAddress.getAllByName(name));
        }

        @Override
        public InetAddress getLocalHost() throws UnknownHostException {
            return InetAddress.getLocalHost();
        }

        @Override
        public InetAddress getByName(String host) throws UnknownHostException {
            return InetAddress.getByName(host);
        }
    };

    AbstractDNSServiceTest() {
    }

    @Test
    void testLocalhost() throws UnknownHostException {
        Assertions.assertThat((String)DNS_SERVER.getByName("localhost").toString()).isEqualTo("localhost/127.0.0.1");
        String localHost = DNS_SERVER.getHostName(InetAddress.getByName("127.0.0.1"));
        Assertions.assertThat((localHost.length() > 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    @Disabled(value="It requires internet connection!")
    void testApache() throws UnknownHostException {
        Assertions.assertThat((boolean)DNS_SERVER.getByName("www.apache.org").toString().startsWith("www.apache.org")).isTrue();
    }
}

