/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.james.mime4j.codec.CodecUtil;
import org.apache.james.mime4j.codec.QuotedPrintableInputStream;

public class QuotedPrintableInputStreamBench {
    public static void main(String[] args) throws Exception {
        byte[] data = QuotedPrintableInputStreamBench.initData(0x200000);
        byte[] encoded = QuotedPrintableInputStreamBench.encode(data);
        QuotedPrintableInputStreamBench.testDecode(data, encoded);
        NullOutputStream nullOut = new NullOutputStream();
        for (int i = 0; i < 5; ++i) {
            ByteArrayInputStream ed = new ByteArrayInputStream(encoded);
            QuotedPrintableInputStream in = new QuotedPrintableInputStream((InputStream)ed);
            CodecUtil.copy((InputStream)in, (OutputStream)nullOut);
        }
        Thread.sleep(100L);
        long t0 = System.currentTimeMillis();
        int repetitions = 50;
        for (int i = 0; i < 50; ++i) {
            ByteArrayInputStream ed = new ByteArrayInputStream(encoded);
            QuotedPrintableInputStream in = new QuotedPrintableInputStream((InputStream)ed);
            CodecUtil.copy((InputStream)in, (OutputStream)nullOut);
        }
        long dt = System.currentTimeMillis() - t0;
        long totalBytes = (long)data.length * 50L;
        double mbPerSec = (double)totalBytes / 1024.0 / 1024.0 / ((double)dt / 1000.0);
        System.out.println(dt + " ms");
        System.out.println(totalBytes + " bytes");
        System.out.println(mbPerSec + " mb/sec");
    }

    private static byte[] initData(int size) {
        Random random = new Random(size);
        byte[] data = new byte[size];
        random.nextBytes(data);
        return data;
    }

    private static byte[] encode(byte[] data) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CodecUtil.encodeQuotedPrintableBinary((InputStream)in, (OutputStream)out);
        return out.toByteArray();
    }

    private static void testDecode(byte[] data, byte[] encoded) throws IOException {
        ByteArrayInputStream ed = new ByteArrayInputStream(encoded);
        QuotedPrintableInputStream in = new QuotedPrintableInputStream((InputStream)ed);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CodecUtil.copy((InputStream)in, (OutputStream)out);
        QuotedPrintableInputStreamBench.compare(data, out.toByteArray());
    }

    private static void compare(byte[] expected, byte[] actual) {
        if (expected.length != actual.length) {
            throw new AssertionError((Object)("length: " + expected.length + ", " + actual.length));
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] != actual[i]) {
                throw new AssertionError((Object)("value @ " + i));
            }
        }
    }
}

