/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base.test;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.mailet.MailetContext;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.test.FakeMailContext;

public class FakeMatcherConfig
implements MatcherConfig {
    private final String matcherName;
    private final MailetContext mailetContext;
    private final Optional<String> condition;

    public static Builder builder() {
        return new Builder();
    }

    private FakeMatcherConfig(String matcherName, MailetContext mailetContext, Optional<String> condition) {
        this.matcherName = matcherName;
        this.mailetContext = mailetContext;
        this.condition = condition;
    }

    public String getMatcherName() {
        return this.matcherName;
    }

    public MailetContext getMailetContext() {
        return this.mailetContext;
    }

    public String getCondition() {
        return this.condition.orElse(null);
    }

    public static class Builder {
        private String matcherName;
        private Optional<MailetContext> mailetContext;
        private Optional<String> condition = Optional.empty();

        private Builder() {
            this.mailetContext = Optional.empty();
        }

        public Builder matcherName(String matcherName) {
            this.matcherName = matcherName;
            return this;
        }

        public Builder mailetContext(MailetContext mailetContext) {
            Preconditions.checkNotNull((Object)mailetContext);
            this.mailetContext = Optional.of(mailetContext);
            return this;
        }

        public Builder condition(String condition) {
            this.condition = Optional.ofNullable(condition);
            return this;
        }

        public FakeMatcherConfig build() {
            Preconditions.checkNotNull((Object)this.matcherName, (Object)"'matcherName' is mandatory");
            return new FakeMatcherConfig(this.matcherName, this.mailetContext.orElse(FakeMailContext.defaultContext()), this.condition);
        }
    }
}

