/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rspamd.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.rspamd.RspamdScanner;
import org.apache.james.util.streams.Iterators;

public class RunningOptions {
    public static final Optional<Long> DEFAULT_PERIOD = Optional.empty();
    public static final int DEFAULT_MESSAGES_PER_SECOND = 10;
    public static final Duration DEFAULT_RSPAMD_TIMEOUT = Duration.ofSeconds(15L);
    public static final double DEFAULT_SAMPLING_PROBABILITY = 1.0;
    public static final Optional<Boolean> ALL_MESSAGES = Optional.empty();
    public static final RunningOptions DEFAULT = new RunningOptions(DEFAULT_PERIOD, 10, 1.0, ALL_MESSAGES, DEFAULT_RSPAMD_TIMEOUT);
    private final Optional<Long> periodInSecond;
    private final int messagesPerSecond;
    private final double samplingProbability;
    private final Optional<Boolean> classifiedAsSpam;
    private final Duration rspamdTimeout;

    public RunningOptions(Optional<Long> periodInSecond, int messagesPerSecond, double samplingProbability, Optional<Boolean> classifiedAsSpam) {
        this(periodInSecond, messagesPerSecond, samplingProbability, classifiedAsSpam, DEFAULT_RSPAMD_TIMEOUT);
    }

    public RunningOptions(@JsonProperty(value="periodInSecond") Optional<Long> periodInSecond, @JsonProperty(value="messagesPerSecond") int messagesPerSecond, @JsonProperty(value="samplingProbability") double samplingProbability, @JsonProperty(value="classifiedAsSpam") Optional<Boolean> classifiedAsSpam, @JsonProperty(value="rspamdTimeoutInSeconds") Duration rspamdTimeout) {
        this.periodInSecond = periodInSecond;
        this.messagesPerSecond = messagesPerSecond;
        this.samplingProbability = samplingProbability;
        this.classifiedAsSpam = classifiedAsSpam;
        this.rspamdTimeout = this.evaluateRspamdTimeout(rspamdTimeout);
    }

    public Optional<Boolean> getClassifiedAsSpam() {
        return this.classifiedAsSpam;
    }

    public Optional<Long> getPeriodInSecond() {
        return this.periodInSecond;
    }

    public int getMessagesPerSecond() {
        return this.messagesPerSecond;
    }

    public double getSamplingProbability() {
        return this.samplingProbability;
    }

    public long getRspamdTimeoutInSeconds() {
        return this.rspamdTimeout.toSeconds();
    }

    @JsonIgnore
    public Duration getRspamdTimeout() {
        return this.rspamdTimeout;
    }

    @JsonIgnore
    public ClassificationFilter correspondingClassificationFilter() {
        return this.classifiedAsSpam.map(result -> {
            if (result.booleanValue()) {
                return ClassificationFilter.CLASSIFIED_AS_SPAM;
            }
            return ClassificationFilter.CLASSIFIED_AS_HAM;
        }).orElse(ClassificationFilter.ALL);
    }

    private Duration evaluateRspamdTimeout(Duration rspamdTimeout) {
        return Optional.ofNullable(rspamdTimeout).orElse(DEFAULT_RSPAMD_TIMEOUT);
    }

    public final boolean equals(Object o) {
        if (o instanceof RunningOptions) {
            RunningOptions that = (RunningOptions)o;
            return Objects.equals(this.messagesPerSecond, that.messagesPerSecond) && Objects.equals(this.samplingProbability, that.samplingProbability) && Objects.equals(this.periodInSecond, that.periodInSecond) && Objects.equals(this.classifiedAsSpam, that.classifiedAsSpam) && Objects.equals(this.rspamdTimeout, that.rspamdTimeout);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.periodInSecond, this.messagesPerSecond, this.samplingProbability, this.classifiedAsSpam, this.rspamdTimeout);
    }

    static interface ClassificationFilter
    extends Predicate<MessageResult> {
        public static final ClassificationFilter ALL = any -> true;
        public static final ClassificationFilter CLASSIFIED_AS_HAM = new HeaderBasedPredicate("NO");
        public static final ClassificationFilter CLASSIFIED_AS_SPAM = new HeaderBasedPredicate("YES");

        public static class HeaderBasedPredicate
        implements ClassificationFilter {
            private final String value;

            public HeaderBasedPredicate(String value) {
                this.value = value;
            }

            @Override
            public boolean test(MessageResult messageResult) {
                try {
                    return Iterators.toStream((Iterator)messageResult.getHeaders().headers()).filter(header -> header.getName().equalsIgnoreCase(RspamdScanner.FLAG_MAIL.asString())).findFirst().map(header -> header.getValue().equalsIgnoreCase(this.value)).orElse(true);
                }
                catch (MailboxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

