/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rspamd.task;

import com.github.fge.lambdas.Throwing;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.rspamd.task.FeedHamToRspamdTask;
import org.apache.james.rspamd.task.FeedSpamToRspamdTask;
import org.apache.james.rspamd.task.RunningOptions;
import org.apache.james.task.Task;
import org.apache.james.user.api.UsersRepository;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GetMailboxMessagesService {
    private static final int UNLIMITED = -1;
    private static final String TRASH_MAILBOX_NAME = "Trash";
    private final MailboxManager mailboxManager;
    private final UsersRepository userRepository;
    private final MailboxSessionMapperFactory mapperFactory;
    private final MessageIdManager messageIdManager;

    public GetMailboxMessagesService(MailboxManager mailboxManager, UsersRepository userRepository, MailboxSessionMapperFactory mapperFactory, MessageIdManager messageIdManager) {
        this.mailboxManager = mailboxManager;
        this.userRepository = userRepository;
        this.mapperFactory = mapperFactory;
        this.messageIdManager = messageIdManager;
    }

    public Flux<Pair<Username, MessageResult>> getMailboxMessagesOfAllUser(String mailboxName, Optional<Date> afterDate, RunningOptions runningOptions, FeedSpamToRspamdTask.Context context) {
        return Flux.from((Publisher)this.userRepository.listReactive()).flatMap(username -> this.getMailboxMessagesOfAUser((Username)username, mailboxName, afterDate, runningOptions, context).map(result -> Pair.of((Object)username, (Object)result)), 2);
    }

    public Flux<Pair<Username, MessageResult>> getHamMessagesOfAllUser(Optional<Date> afterDate, RunningOptions runningOptions, FeedHamToRspamdTask.Context context) {
        return Flux.from((Publisher)this.userRepository.listReactive()).flatMap((Function)Throwing.function(username -> Flux.from((Publisher)this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)this.mailboxManager.createSystemSession(username)).build(), this.mailboxManager.createSystemSession(username))).filter(mbxMetadata -> this.hamMailboxesPredicate(mbxMetadata.getPath())).flatMap(mbxMetadata -> this.getMailboxMessagesOfAUser((Username)username, (MailboxMetaData)mbxMetadata, afterDate, runningOptions, context), 2).map(result -> Pair.of((Object)username, (Object)result))), 16);
    }

    private Flux<MessageResult> getMailboxMessagesOfAUser(Username username, String mailboxName, Optional<Date> afterDate, RunningOptions runningOptions, FeedSpamToRspamdTask.Context context) {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        return Mono.from((Publisher)this.mailboxManager.getMailboxReactive(MailboxPath.forUser((Username)username, (String)mailboxName), mailboxSession)).onErrorResume(MailboxNotFoundException.class, e -> {
            Task.LOGGER.info("Missing Spam mailbox {}", (Object)e.getMessage());
            return Mono.empty();
        }).map((Function)Throwing.function(MessageManager::getMailboxEntity)).flatMapMany((Function)Throwing.function(mailbox -> this.mapperFactory.getMessageMapper(mailboxSession).findInMailboxReactive(mailbox, MessageRange.all(), MessageMapper.FetchType.METADATA, -1))).filter(mailboxMessageMetaData -> afterDate.map(date -> mailboxMessageMetaData.getSaveDate().orElse(mailboxMessageMetaData.getInternalDate()).after((Date)date)).orElse(true)).doOnNext(mailboxMessageMetaData -> context.incrementSpamMessageCount()).filter(message -> GetMailboxMessagesService.randomBooleanWithProbability(runningOptions)).flatMap(message -> this.messageIdManager.getMessagesReactive(List.of(message.getMessageId()), FetchGroup.FULL_CONTENT, mailboxSession), 16).filter((Predicate)runningOptions.correspondingClassificationFilter()).doFinally(any -> this.mailboxManager.endProcessingRequest(mailboxSession));
    }

    private Flux<MessageResult> getMailboxMessagesOfAUser(Username username, MailboxMetaData mailboxMetaData, Optional<Date> afterDate, RunningOptions runningOptions, FeedHamToRspamdTask.Context context) {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        return Mono.from((Publisher)this.mailboxManager.getMailboxReactive(mailboxMetaData.getId(), mailboxSession)).map((Function)Throwing.function(MessageManager::getMailboxEntity)).flatMapMany((Function)Throwing.function(mailbox -> this.mapperFactory.getMessageMapper(mailboxSession).findInMailboxReactive(mailbox, MessageRange.all(), MessageMapper.FetchType.METADATA, -1))).filter(mailboxMessageMetaData -> afterDate.map(date -> mailboxMessageMetaData.getSaveDate().orElse(mailboxMessageMetaData.getInternalDate()).after((Date)date)).orElse(true)).doOnNext(mailboxMessageMetaData -> context.incrementHamMessageCount()).filter(message -> GetMailboxMessagesService.randomBooleanWithProbability(runningOptions)).flatMap(message -> this.messageIdManager.getMessagesReactive(List.of(message.getMessageId()), FetchGroup.FULL_CONTENT, mailboxSession), 16).filter((Predicate)runningOptions.correspondingClassificationFilter()).doFinally(any -> this.mailboxManager.endProcessingRequest(mailboxSession));
    }

    public static boolean randomBooleanWithProbability(RunningOptions runningOptions) {
        if (runningOptions.getSamplingProbability() == 1.0) {
            return true;
        }
        return Math.random() < runningOptions.getSamplingProbability();
    }

    private boolean hamMailboxesPredicate(MailboxPath mailboxPath) {
        return !mailboxPath.getName().equals("Spam") && !mailboxPath.getName().equals(TRASH_MAILBOX_NAME);
    }
}

