/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rspamd.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Optional;
import org.apache.james.rspamd.model.AnalysisResult;

public class AnalysisResultDeserializer
extends StdDeserializer<AnalysisResult> {
    public AnalysisResultDeserializer() {
        this(null);
    }

    protected AnalysisResultDeserializer(Class<?> vc) {
        super(vc);
    }

    public AnalysisResult deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        AnalysisResult.Action action = this.deserializeAction(node.get("action").asText());
        float score = node.get("score").floatValue();
        float requiredScore = node.get("required_score").floatValue();
        Optional<String> desiredRewriteSubject = this.deserializeRewriteSubject(node);
        Optional<String> virusNote = this.deserializeClamVirus(node);
        return new AnalysisResult(action, score, requiredScore, desiredRewriteSubject, virusNote);
    }

    private AnalysisResult.Action deserializeAction(String actionAsString) {
        for (AnalysisResult.Action action : AnalysisResult.Action.values()) {
            if (!action.getDescription().equals(actionAsString)) continue;
            return action;
        }
        throw new RuntimeException("There is no match deserialized action.");
    }

    private Optional<String> deserializeRewriteSubject(JsonNode node) {
        return Optional.ofNullable(node.get("subject")).map(JsonNode::asText);
    }

    private Optional<String> deserializeClamVirus(JsonNode node) {
        JsonNode clamVirusJsonNode = node.get("symbols").get("CLAM_VIRUS");
        return Optional.ofNullable(clamVirusJsonNode).map(JsonNode::toString);
    }
}

