/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rspamd.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.rspamd.model.AnalysisResultDeserializer;

@JsonDeserialize(using=AnalysisResultDeserializer.class)
public class AnalysisResult {
    private final Action action;
    private final float score;
    private final float requiredScore;
    private final Optional<String> desiredRewriteSubject;
    private final Optional<String> virusNote;

    public static Builder builder() {
        return new Builder();
    }

    public AnalysisResult(Action action, float score, float requiredScore, Optional<String> desiredRewriteSubject, Optional<String> virusNote) {
        this.action = action;
        this.score = score;
        this.requiredScore = requiredScore;
        this.desiredRewriteSubject = desiredRewriteSubject;
        this.virusNote = virusNote;
    }

    public Action getAction() {
        return this.action;
    }

    public float getScore() {
        return this.score;
    }

    public float getRequiredScore() {
        return this.requiredScore;
    }

    public Optional<String> getDesiredRewriteSubject() {
        return this.desiredRewriteSubject;
    }

    public Optional<String> getVirusNote() {
        return this.virusNote;
    }

    public final boolean equals(Object o) {
        if (o instanceof AnalysisResult) {
            AnalysisResult that = (AnalysisResult)o;
            return Objects.equals(Float.valueOf(this.score), Float.valueOf(that.score)) && Objects.equals(Float.valueOf(this.requiredScore), Float.valueOf(that.requiredScore)) && Objects.equals((Object)this.action, (Object)that.action) && Objects.equals(this.desiredRewriteSubject, that.desiredRewriteSubject) && Objects.equals(this.virusNote, that.virusNote);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.action, Float.valueOf(this.score), Float.valueOf(this.requiredScore), this.desiredRewriteSubject, this.virusNote});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("action", (Object)this.action).add("score", this.score).add("requiredScore", this.requiredScore).add("desiredRewriteSubject", this.desiredRewriteSubject).add("virusNote", this.virusNote).toString();
    }

    public static class Builder {
        private Action action;
        private float score;
        private float requiredScore;
        private Optional<String> desiredRewriteSubject = Optional.empty();
        private Optional<String> virusNote = Optional.empty();

        public Builder action(Action action) {
            this.action = action;
            return this;
        }

        public Builder score(float score) {
            this.score = score;
            return this;
        }

        public Builder requiredScore(float requiredScore) {
            this.requiredScore = requiredScore;
            return this;
        }

        public Builder desiredRewriteSubject(String desiredRewriteSubject) {
            this.desiredRewriteSubject = Optional.of(desiredRewriteSubject);
            return this;
        }

        @VisibleForTesting
        public Builder hasVirus(boolean hasVirus) {
            if (hasVirus) {
                this.virusNote = Optional.of("A notice describing the virus");
            }
            return this;
        }

        @VisibleForTesting
        public Builder virusNote(String value) {
            this.virusNote = Optional.of(value);
            return this;
        }

        public AnalysisResult build() {
            Preconditions.checkNotNull((Object)((Object)this.action));
            return new AnalysisResult(this.action, this.score, this.requiredScore, this.desiredRewriteSubject, this.virusNote);
        }
    }

    public static enum Action {
        NO_ACTION("no action"),
        GREY_LIST("greylist"),
        ADD_HEADER("add header"),
        REWRITE_SUBJECT("rewrite subject"),
        SOFT_REJECT("soft reject"),
        REJECT("reject");

        private final String description;

        private Action(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

