/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rspamd.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.github.fge.lambdas.Throwing;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaders;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rspamd.client.RspamdClientConfiguration;
import org.apache.james.rspamd.exception.RspamdUnexpectedException;
import org.apache.james.rspamd.exception.UnauthorizedException;
import org.apache.james.rspamd.model.AnalysisResult;
import org.apache.james.server.core.MimeMessageInputStream;
import org.apache.james.util.ReactorUtils;
import org.apache.mailet.AttributeName;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufMono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class RspamdHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RspamdHttpClient.class);
    public static final String CHECK_V2_ENDPOINT = "/checkV2";
    public static final String LEARN_SPAM_ENDPOINT = "/learnspam";
    public static final String LEARN_HAM_ENDPOINT = "/learnham";
    public static final String PING_ENDPOINT = "/ping";
    private static final int OK = 200;
    private static final int NO_CONTENT = 204;
    private static final int UNAUTHORIZED = 401;
    private static final int BUFFER_SIZE = 16384;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;

    @Inject
    public RspamdHttpClient(RspamdClientConfiguration configuration) {
        this.httpClient = this.buildReactorNettyHttpClient(configuration);
        this.objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module());
    }

    public Mono<HttpClientResponse> ping() {
        return ((HttpClient.ResponseReceiver)this.httpClient.get().uri(PING_ENDPOINT)).response();
    }

    public Mono<AnalysisResult> checkV2(Mail mail) throws MessagingException {
        return this.checkV2(mail, Options.NONE);
    }

    public Mono<AnalysisResult> checkV2(Mail mail, Options options) throws MessagingException {
        return ((HttpClient.RequestSender)options.decorate(this.httpClient).headers(headers -> this.transportInformationToHeaders(mail, (HttpHeaders)headers)).post().uri(CHECK_V2_ENDPOINT)).send((Publisher)ReactorUtils.toChunks((InputStream)new MimeMessageInputStream(mail.getMessage()), (int)16384).map(Unpooled::wrappedBuffer)).responseSingle(this::checkMailHttpResponseHandler).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    public Mono<Void> reportAsSpam(Publisher<ByteBuffer> content) {
        return this.reportMail(content, LEARN_SPAM_ENDPOINT, Options.NONE);
    }

    public Mono<Void> reportAsSpam(Publisher<ByteBuffer> content, Options options) {
        return this.reportMail(content, LEARN_SPAM_ENDPOINT, options);
    }

    public Mono<Void> reportAsHam(Publisher<ByteBuffer> content) {
        return this.reportMail(content, LEARN_HAM_ENDPOINT, Options.NONE);
    }

    public Mono<Void> reportAsHam(Publisher<ByteBuffer> content, Options options) {
        return this.reportMail(content, LEARN_HAM_ENDPOINT, options);
    }

    private void transportInformationToHeaders(Mail mail, HttpHeaders headers) {
        Optional.ofNullable(mail.getRemoteAddr()).ifPresent(ip -> headers.add("IP", ip));
        Optional.ofNullable(mail.getRemoteHost()).ifPresent(host -> headers.add("Hostname", host));
        mail.getAttribute(Mail.SMTP_HELO).map(attr -> attr.getValue().value()).filter(String.class::isInstance).map(String.class::cast).ifPresent(helo -> headers.add("HELO", helo));
        mail.getMaybeSender().asOptional().ifPresent(from -> headers.add("From", (Object)from.asString()));
        Optional.ofNullable(mail.getRecipients()).orElse((Collection)ImmutableList.of()).forEach(rcpt -> headers.add("Rcpt", (Object)rcpt.asString()));
        mail.getAttribute(Mail.SMTP_AUTH_USER).or(() -> mail.getAttribute(AttributeName.of((String)"org.apache.james.jmap.send.MailMetaData.username"))).map(attr -> attr.getValue().value()).filter(String.class::isInstance).map(String.class::cast).ifPresent(user -> headers.add("User", user));
        mail.getAttribute(Mail.SSL_PROTOCOL).map(attr -> attr.getValue().value()).filter(String.class::isInstance).map(String.class::cast).ifPresent(tlsVersion -> headers.add("TLS-Version", tlsVersion));
        mail.getAttribute(Mail.SSL_CIPHER).map(attr -> attr.getValue().value()).filter(String.class::isInstance).map(String.class::cast).ifPresent(cipher -> headers.add("TLS-Cipher", cipher));
    }

    private HttpClient buildReactorNettyHttpClient(RspamdClientConfiguration configuration) {
        return HttpClient.create().disableRetry(true).responseTimeout(Duration.ofSeconds(configuration.getTimeout().orElse(RspamdClientConfiguration.DEFAULT_TIMEOUT_IN_SECONDS).intValue())).baseUrl(configuration.getUrl().toString()).headers(headers -> headers.add("Password", (Object)configuration.getPassword()));
    }

    private Mono<Void> reportMail(Publisher<ByteBuffer> content, String endpoint, Options options) {
        return ((HttpClient.RequestSender)options.decorate(this.httpClient).post().uri(endpoint)).send((Publisher)Flux.from(content).map(Unpooled::wrappedBuffer)).responseSingle(this::reportMailHttpResponseHandler);
    }

    private Mono<AnalysisResult> checkMailHttpResponseHandler(HttpClientResponse httpClientResponse, ByteBufMono byteBufMono) {
        switch (httpClientResponse.status().code()) {
            case 200: {
                return byteBufMono.asString(StandardCharsets.UTF_8).map((Function)Throwing.function(this::convertToAnalysisResult));
            }
            case 401: {
                return byteBufMono.asString(StandardCharsets.UTF_8).flatMap(responseBody -> Mono.error(() -> new UnauthorizedException((String)responseBody)));
            }
        }
        return byteBufMono.asString(StandardCharsets.UTF_8).flatMap(responseBody -> Mono.error(() -> new RspamdUnexpectedException((String)responseBody)));
    }

    private Mono<Void> reportMailHttpResponseHandler(HttpClientResponse httpClientResponse, ByteBufMono byteBufMono) {
        switch (httpClientResponse.status().code()) {
            case 200: 
            case 204: {
                return Mono.empty();
            }
            case 401: {
                return byteBufMono.asString(StandardCharsets.UTF_8).flatMap(responseBody -> Mono.error(() -> new UnauthorizedException((String)responseBody)));
            }
        }
        return byteBufMono.asString(StandardCharsets.UTF_8).flatMap(responseBody -> {
            if (responseBody.contains(" has been already learned as ham, ignore it")) {
                LOGGER.debug(responseBody);
                return Mono.empty();
            }
            if (responseBody.contains(" has been already learned as spam, ignore it")) {
                LOGGER.debug(responseBody);
                return Mono.empty();
            }
            if (responseBody.contains("Empty body is not permitted")) {
                LOGGER.debug(responseBody);
                return Mono.empty();
            }
            return Mono.error(() -> new RspamdUnexpectedException((String)responseBody));
        });
    }

    private AnalysisResult convertToAnalysisResult(String json) throws JsonProcessingException {
        return (AnalysisResult)this.objectMapper.readValue(json, AnalysisResult.class);
    }

    public static class Options {
        public static final String DELIVER_TO_HEADER = "Deliver-To";
        public static final Options NONE = new Options(Optional.empty());
        private final Optional<Username> username;

        public static Options forUser(Username username) {
            return new Options(username);
        }

        public static Options forMailAddress(MailAddress username) {
            return new Options(Username.fromMailAddress((MailAddress)username));
        }

        public Options(Optional<Username> username) {
            this.username = username;
        }

        public Options(Username username) {
            this.username = Optional.of(username);
        }

        private HttpClient decorate(HttpClient httpClient) {
            return this.username.map(user -> httpClient.headers(h -> h.add(DELIVER_TO_HEADER, (Object)user.asString()))).orElse(httpClient);
        }

        public final boolean equals(Object o) {
            if (o instanceof Options) {
                Options options = (Options)o;
                return Objects.equal(this.username, options.username);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.username});
        }
    }
}

