/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rspamd.client;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;

public class RspamdClientConfiguration {
    public static final Integer DEFAULT_TIMEOUT_IN_SECONDS = 15;
    private final URL url;
    private final String password;
    private final Optional<Integer> timeout;
    private final boolean perUserBayes;

    public static RspamdClientConfiguration from(Configuration config) {
        URL rspamdUrl = (URL)Optional.ofNullable(config.getString("rspamdUrl", null)).filter(s -> !s.isEmpty()).map(Throwing.function(URL::new)).orElseThrow(() -> new IllegalArgumentException("Rspamd's url is invalid."));
        Optional<Integer> rspamdTimeoutConfigure = Optional.ofNullable(config.getInteger("rspamdTimeout", null)).map(i -> {
            Preconditions.checkArgument((i > 0 ? 1 : 0) != 0, (Object)"rspamdTimeout should be positive number");
            return i;
        });
        String rspamdPassword = config.getString("rspamdPassword", "");
        boolean perUserBayes = config.getBoolean("perUserBayes", false);
        return new RspamdClientConfiguration(rspamdUrl, rspamdPassword, rspamdTimeoutConfigure, perUserBayes);
    }

    @VisibleForTesting
    public RspamdClientConfiguration(URL url, String password, Optional<Integer> timeout) {
        this.url = url;
        this.password = password;
        this.timeout = timeout;
        this.perUserBayes = false;
    }

    public RspamdClientConfiguration(URL url, String password, Optional<Integer> timeout, boolean perUserBayes) {
        this.url = url;
        this.password = password;
        this.timeout = timeout;
        this.perUserBayes = perUserBayes;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getPassword() {
        return this.password;
    }

    public Optional<Integer> getTimeout() {
        return this.timeout;
    }

    public boolean usePerUserBayes() {
        return this.perUserBayes;
    }
}

