/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.helper;

import org.apache.james.mpt.helper.ScriptBuilder;

public class CreateScript {
    public static final String RE = "Re:";
    public static final String HEADER = "Delivered-To";
    public static final String ANOTHER_HEADER = "Received";
    public static final String COMMON_LETTER = "o";
    public static final String COMMON_WORD = "the";
    public static final String UNCOMMON_WORD = "thy";
    public static final String UNCOMMON_PHRASE = "\"nothing worthy prove\"";
    public static final String ANOTHER_NAME = "Robert";
    public static final String NAME = "tim";
    public static final String DOMAIN = "example.org";
    public static final String ANOTHER_DOMAIN = "apache.org";

    public static void main(String[] args) throws Exception {
        ScriptBuilder builder = ScriptBuilder.open("localhost", 143);
        CreateScript.expunge(builder);
    }

    public static void expunge(ScriptBuilder builder) throws Exception {
        try {
            CreateScript.setup(builder);
            builder.append();
            builder.setFile("wild-example.mail");
            builder.append();
            builder.setFile("multipart-alt.mail");
            builder.append();
            builder.setFile("multipart-mixed-complex.mail");
            builder.append();
            builder.setFile("rfc822-hello-world.mail");
            builder.append();
            builder.setFile("wild-mixed-alt.mail");
            builder.append();
            builder.setFile("wild-mixed.mail");
            builder.append();
            builder.setFile("rfc822-resent.mail");
            builder.append();
            builder.setFile("rfc822-trace.mail");
            builder.append();
            builder.setFile("wild-alt-reply4.mail");
            builder.append();
            builder.select();
            builder.flagDeleted(4);
            builder.flagDeleted(6);
            builder.flagDeleted(7);
            builder.expunge();
            builder.select();
        }
        finally {
            builder.quit();
        }
    }

    public static void rfcFetch(ScriptBuilder builder) throws Exception {
        try {
            CreateScript.setup(builder);
            builder.append();
            builder.setFile("wild-example.mail");
            builder.append();
            builder.setFile("multipart-alt.mail");
            builder.append();
            builder.setFile("multipart-mixed-complex.mail");
            builder.append();
            builder.setFile("rfc822-hello-world.mail");
            builder.append();
            builder.setFile("wild-mixed-alt.mail");
            builder.append();
            builder.setFile("wild-mixed.mail");
            builder.append();
            builder.setFile("rfc822-resent.mail");
            builder.append();
            builder.setFile("rfc822-trace.mail");
            builder.append();
            builder.setFile("wild-alt-reply4.mail");
            builder.append();
            builder.resetFetch().setRfc822Size(true);
            builder.fetchAllMessages();
            builder.resetFetch().setRfc(true);
            builder.fetchAllMessages();
            builder.resetFetch().setRfcHeaders(true);
            builder.fetchAllMessages();
            builder.resetFetch().setRfcText(true);
            builder.fetchAllMessages();
        }
        finally {
            builder.quit();
        }
    }

    public static void bodyStructureEmbedded(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.setFile("multipart-mixed-complex.mail");
        builder.append();
        builder.fetchSection("");
        builder.fetchSection("TEXT");
        builder.fetchSection("HEADER");
        builder.fetchSection("1");
        builder.fetchSection("2");
        builder.fetchSection("3");
        builder.fetchSection("3.HEADER");
        builder.fetchSection("3.TEXT");
        builder.fetchSection("3.1");
        builder.fetchSection("3.2");
        builder.fetchSection("4");
        builder.fetchSection("4.1");
        builder.fetchSection("4.1.MIME");
        builder.fetchSection("4.2");
        builder.fetchSection("4.2.HEADER");
        builder.fetchSection("4.2.TEXT");
        builder.fetchSection("4.2.1");
        builder.fetchSection("4.2.2");
        builder.fetchSection("4.2.2.1");
        builder.fetchSection("4.2.2.2");
        builder.resetFetch().setBodyFetch(true).setBodyStructureFetch(true);
        builder.fetchAllMessages();
        builder.quit();
    }

    public static void bodyStructureComplex(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.setFile("wild-alt-reply3.mail");
        builder.append();
        builder.setFile("wild-alt-reply4.mail");
        builder.append();
        builder.setFile("multipart-mixed.mail");
        builder.append();
        builder.setFile("wild-mixed-alt.mail");
        builder.append();
        builder.setFile("wild-mixed.mail");
        builder.append();
        builder.setFile("mime-plain-text.mail");
        builder.append();
        builder.fetchAllMessages();
        for (int i = 1; i < 7; ++i) {
            builder.setMessageNumber(i);
            builder.fetchSection("");
            builder.fetchSection("TEXT");
            builder.fetchSection("HEADER");
            builder.fetchSection("1");
            builder.fetchSection("2");
            builder.fetchSection("3");
            builder.fetchSection("3.HEADER");
            builder.fetchSection("3.TEXT");
            builder.fetchSection("3.1");
            builder.fetchSection("3.2");
            builder.fetchSection("4");
            builder.fetchSection("4.1");
            builder.fetchSection("4.1.MIME");
            builder.fetchSection("4.2");
            builder.fetchSection("4.2.HEADER");
            builder.fetchSection("4.2.TEXT");
            builder.fetchSection("4.2.1");
            builder.fetchSection("4.2.2");
            builder.fetchSection("4.2.2.1");
            builder.fetchSection("4.2.2.2");
        }
        builder.resetFetch().setBodyFetch(true).setBodyStructureFetch(true);
        builder.fetchAllMessages();
        builder.quit();
    }

    public static void bodyStructureSimple(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.setFile("rfc822-multiple-addresses.mail");
        builder.append();
        builder.setFile("wild-example.mail");
        builder.append();
        builder.setFile("mime-plain-text.mail");
        builder.append();
        builder.fetchAllMessages();
        builder.fetchSection("");
        builder.fetchSection("TEXT");
        builder.fetchSection("HEADER");
        builder.fetchSection("1");
        builder.fetchSection("2");
        builder.fetchSection("3");
        builder.fetchSection("3.HEADER");
        builder.fetchSection("3.TEXT");
        builder.fetchSection("3.1");
        builder.fetchSection("3.2");
        builder.fetchSection("4");
        builder.fetchSection("4.1");
        builder.fetchSection("4.1.MIME");
        builder.fetchSection("4.2");
        builder.fetchSection("4.2.HEADER");
        builder.fetchSection("4.2.TEXT");
        builder.fetchSection("4.2.1");
        builder.fetchSection("4.2.2");
        builder.fetchSection("4.2.2.1");
        builder.fetchSection("4.2.2.2");
        builder.resetFetch().setBodyFetch(true).setBodyStructureFetch(true);
        builder.fetchAllMessages();
        builder.quit();
    }

    public static void bodyStructureMultipart(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.setFile("multipart-binary.mail");
        builder.append();
        builder.setFile("multipart-alt-translation.mail");
        builder.append();
        builder.fetchAllMessages();
        builder.fetchSection("");
        builder.fetchSection("TEXT");
        builder.fetchSection("HEADER");
        builder.fetchSection("1");
        builder.fetchSection("2");
        builder.fetchSection("3");
        builder.fetchSection("3.HEADER");
        builder.fetchSection("3.TEXT");
        builder.fetchSection("3.1");
        builder.fetchSection("3.2");
        builder.fetchSection("4");
        builder.fetchSection("4.1");
        builder.fetchSection("4.1.MIME");
        builder.fetchSection("4.2");
        builder.fetchSection("4.2.HEADER");
        builder.fetchSection("4.2.TEXT");
        builder.fetchSection("4.2.1");
        builder.fetchSection("4.2.2");
        builder.fetchSection("4.2.2.1");
        builder.fetchSection("4.2.2.2");
        builder.resetFetch().setBodyFetch(true).setBodyStructureFetch(true);
        builder.fetchAllMessages();
        builder.quit();
    }

    public static void renameSelected(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.append();
        builder.setFile("rfc822-hello-world.mail");
        builder.append();
        builder.setFile("rfc822-sender.mail");
        builder.append();
        builder.setFile("rfc822.mail");
        builder.append();
        builder.setFile("rfc822-multiple-addresses.mail");
        builder.append();
        builder.select();
        builder.getFetch().setFlagsFetch(true).bodyPeekHeaders(ScriptBuilder.Fetch.SELECT_HEADERS).setUid(true);
        builder.fetchAllMessages();
        builder.list();
        builder.rename("anothermailbox");
        builder.list();
        builder.fetchAllMessages();
        builder.store(builder.flags().add().flagged().range(1L, 2L));
        builder.store(builder.flags().add().answered().range(1L, 3L));
        builder.fetchAllMessages();
        builder.select();
        builder.setMailbox("anothermailbox");
        builder.select();
        builder.fetchAllMessages();
        builder.quit();
    }

    public static void renameHierarchy(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.setMailbox("one").create();
        builder.setMailbox("one.two").create();
        builder.setMailbox("one.two.three").create();
        builder.setMailbox("one.two.three.four").create();
        builder.list();
        builder.rename("one.two", "alpha.beta");
        builder.list();
        builder.rename("alpha.beta.three.four", "alpha.beta.gamma.delta");
        builder.list();
        builder.rename("alpha.beta.three", "aleph");
        builder.list();
        builder.rename("aleph", "alpha.beta.gamma.delta.epsilon");
        builder.list();
        builder.rename("alpha.beta.gamma", "one");
        builder.list();
        builder.setMailbox("one").delete();
        builder.setMailbox("alpha").delete();
        builder.setMailbox("aleph");
        builder.list();
        builder.quit();
    }

    public static void rename(ScriptBuilder builder) throws Exception {
        CreateScript.setupSearch(builder, true);
        builder.select();
        String originalMailbox = builder.getMailbox();
        builder.getFetch().setFlagsFetch(true).bodyPeekHeaders(ScriptBuilder.Fetch.SELECT_HEADERS).setUid(true);
        builder.fetchAllMessages();
        builder.setMailbox("other").create().select().append();
        builder.setMailbox("base").create().select();
        builder.rename(originalMailbox, "moved").setMailbox("moved").select().fetchAllMessages();
        builder.setMailbox(originalMailbox).select();
        builder.rename("other", "base");
        builder.setMailbox(originalMailbox).select();
        builder.setMailbox("moved").select();
        builder.setMailbox("other").select();
        builder.setMailbox("base").select();
        builder.setMailbox("BOGUS").select();
        builder.setMailbox("WHATEVER").select();
        builder.rename("other", originalMailbox);
        builder.setMailbox(originalMailbox).select();
        builder.setMailbox("moved").select();
        builder.setMailbox("other").select();
        builder.setMailbox("base").select();
        builder.setMailbox("BOGUS").select();
        builder.setMailbox("WHATEVER").select();
        builder.rename("BOGUS", "WHATEVER");
        builder.rename(originalMailbox, "INBOX");
        builder.rename(originalMailbox, "inbox");
        builder.rename(originalMailbox, "Inbox");
        builder.setMailbox(originalMailbox).select();
        builder.setMailbox("moved").select();
        builder.setMailbox("other").select();
        builder.setMailbox("base").select();
        builder.setMailbox("BOGUS").select();
        builder.setMailbox("WHATEVER").select();
        builder.setMailbox("BOGUS").delete();
        builder.setMailbox("WHATEVER").delete();
        builder.setMailbox(originalMailbox).delete();
        builder.setMailbox("base").delete();
        builder.setMailbox("other").delete();
        builder.setMailbox("moved").delete();
        builder.quit();
    }

    public static void mimePartialFetch(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.setFile("multipart-mixed-complex.mail");
        builder.append();
        builder.select();
        builder.partial(0L, 0L).fetchSection("4.1.MIME");
        builder.partial(0L, 15L).fetchSection("4.1.MIME");
        builder.partial(0L, 31L).fetchSection("4.1.MIME");
        builder.partial(0L, 63L).fetchSection("4.1.MIME");
        builder.partial(0L, 127L).fetchSection("4.1.MIME");
        builder.partial(0L, 1023L).fetchSection("4.1.MIME");
        builder.partial(0L, 2047L).fetchSection("4.1.MIME");
        builder.partial(17L, 0L).fetchSection("4.1.MIME");
        builder.partial(17L, 16L).fetchSection("4.1.MIME");
        builder.partial(17L, 32L).fetchSection("4.1.MIME");
        builder.partial(17L, 64L).fetchSection("4.1.MIME");
        builder.partial(17L, 128L).fetchSection("4.1.MIME");
        builder.partial(17L, 1024L).fetchSection("4.1.MIME");
        builder.partial(17L, 2048L).fetchSection("4.1.MIME");
        builder.partial(10000L, 0L).fetchSection("4.1.MIME");
        builder.partial(10000L, 16L).fetchSection("4.1.MIME");
        builder.partial(10000L, 32L).fetchSection("4.1.MIME");
        builder.partial(10000L, 64L).fetchSection("4.1.MIME");
        builder.partial(10000L, 128L).fetchSection("4.1.MIME");
        builder.partial(10000L, 1024L).fetchSection("4.1.MIME");
        builder.partial(10000L, 2048L).fetchSection("4.1.MIME");
        builder.quit();
    }

    public static void headerPartialFetch(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.setFile("multipart-mixed-complex.mail");
        builder.append();
        builder.select();
        builder.partial(0L, 0L).fetchSection("HEADER");
        builder.partial(0L, 16L).fetchSection("HEADER");
        builder.partial(0L, 32L).fetchSection("HEADER");
        builder.partial(0L, 64L).fetchSection("HEADER");
        builder.partial(0L, 128L).fetchSection("HEADER");
        builder.partial(0L, 1024L).fetchSection("HEADER");
        builder.partial(0L, 2048L).fetchSection("HEADER");
        builder.partial(7L, 0L).fetchSection("HEADER");
        builder.partial(7L, 16L).fetchSection("HEADER");
        builder.partial(7L, 32L).fetchSection("HEADER");
        builder.partial(7L, 64L).fetchSection("HEADER");
        builder.partial(7L, 128L).fetchSection("HEADER");
        builder.partial(7L, 1024L).fetchSection("HEADER");
        builder.partial(7L, 2048L).fetchSection("HEADER");
        builder.partial(10000L, 0L).fetchSection("HEADER");
        builder.partial(10000L, 16L).fetchSection("HEADER");
        builder.partial(10000L, 32L).fetchSection("HEADER");
        builder.partial(10000L, 64L).fetchSection("HEADER");
        builder.partial(10000L, 128L).fetchSection("HEADER");
        builder.partial(10000L, 1024L).fetchSection("HEADER");
        builder.partial(10000L, 2048L).fetchSection("HEADER");
        builder.quit();
    }

    public static void textPartialFetch(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.setFile("multipart-mixed-complex.mail");
        builder.append();
        builder.select();
        builder.partial(0L, 0L).fetchSection("TEXT");
        builder.partial(0L, 16L).fetchSection("TEXT");
        builder.partial(0L, 32L).fetchSection("TEXT");
        builder.partial(0L, 64L).fetchSection("TEXT");
        builder.partial(0L, 128L).fetchSection("TEXT");
        builder.partial(0L, 1024L).fetchSection("TEXT");
        builder.partial(0L, 2048L).fetchSection("TEXT");
        builder.partial(7L, 0L).fetchSection("TEXT");
        builder.partial(7L, 16L).fetchSection("TEXT");
        builder.partial(7L, 32L).fetchSection("TEXT");
        builder.partial(7L, 64L).fetchSection("TEXT");
        builder.partial(7L, 128L).fetchSection("TEXT");
        builder.partial(7L, 1024L).fetchSection("TEXT");
        builder.partial(7L, 2048L).fetchSection("TEXT");
        builder.partial(10000L, 0L).fetchSection("TEXT");
        builder.partial(10000L, 16L).fetchSection("TEXT");
        builder.partial(10000L, 32L).fetchSection("TEXT");
        builder.partial(10000L, 64L).fetchSection("TEXT");
        builder.partial(10000L, 128L).fetchSection("TEXT");
        builder.partial(10000L, 1024L).fetchSection("TEXT");
        builder.partial(10000L, 2048L).fetchSection("TEXT");
        builder.quit();
    }

    public static void bodyPartialFetch(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.setFile("multipart-mixed.mail");
        builder.append();
        builder.select();
        builder.partial(0L, 10L).fetchSection("");
        builder.partial(0L, 100L).fetchSection("");
        builder.partial(0L, 1000L).fetchSection("");
        builder.partial(0L, 10000L).fetchSection("");
        builder.partial(0L, 100000L).fetchSection("");
        builder.partial(100L, 10L).fetchSection("");
        builder.partial(100L, 100L).fetchSection("");
        builder.partial(100L, 1000L).fetchSection("");
        builder.partial(100L, 10000L).fetchSection("");
        builder.partial(100L, 100000L).fetchSection("");
        builder.partial(10000L, 10L).fetchSection("");
        builder.partial(10000L, 100L).fetchSection("");
        builder.partial(10000L, 1000L).fetchSection("");
        builder.partial(10000L, 10000L).fetchSection("");
        builder.partial(10000L, 100000L).fetchSection("");
        builder.quit();
    }

    public static void searchCombinations(ScriptBuilder builder, boolean uids) throws Exception {
        CreateScript.setupSearch(builder, uids);
        builder.body(COMMON_LETTER).undraft().unflagged().answered().search();
        builder.to(COMMON_LETTER).draft().flagged().answered().search();
        builder.to(COMMON_LETTER).smaller(10000).all().draft().search();
        builder.bcc(COMMON_LETTER).larger(1000L).search();
        builder.from(COMMON_LETTER).larger(1000L).flagged().search();
        builder.from(COMMON_LETTER).to(COMMON_LETTER).answered().flagged().all().body(COMMON_LETTER).sentbefore(2009, 1, 1).search();
        builder.or().openParen().from(COMMON_LETTER).to(COMMON_LETTER).answered().flagged().all().body(COMMON_LETTER).sentbefore(2009, 1, 1).closeParen().openParen().header(HEADER, "\"\"").draft().closeParen().search();
        builder.or().openParen().cc(COMMON_LETTER).text(COMMON_LETTER).unseen().larger(1000L).all().body(COMMON_LETTER).senton(2008, 4, 8).closeParen().openParen().header(HEADER, "\"\"").draft().closeParen().search();
        builder.or().openParen().cc(COMMON_LETTER).to(COMMON_LETTER).draft().unseen().all().text(COMMON_LETTER).sentsince(2000, 1, 1).closeParen().openParen().header(HEADER, "\"\"").draft().closeParen().search();
        builder.or().openParen().or().openParen().or().openParen().not().text(COMMON_LETTER).cc(COMMON_LETTER).unseen().flagged().all().body(COMMON_LETTER).not().senton(2008, 3, 1).closeParen().openParen().header(HEADER, DOMAIN).flagged().closeParen().closeParen().openParen().from(COMMON_LETTER).to(COMMON_LETTER).answered().flagged().all().body(COMMON_LETTER).sentbefore(2009, 1, 1).closeParen().closeParen().openParen().answered().flagged().draft().closeParen().all().deleted().search();
        builder.or().openParen().or().openParen().or().openParen().from(COMMON_LETTER).to(COMMON_LETTER).answered().flagged().all().body(COMMON_LETTER).sentbefore(2009, 1, 1).closeParen().openParen().header(HEADER, "\"\"").draft().closeParen().closeParen().openParen().from(COMMON_LETTER).to(COMMON_LETTER).answered().flagged().all().body(COMMON_LETTER).sentbefore(2009, 1, 1).closeParen().closeParen().openParen().answered().flagged().draft().closeParen().all().unanswered().search();
        builder.quit();
    }

    public static void searchAtoms(ScriptBuilder builder, boolean uids) throws Exception {
        CreateScript.setupSearch(builder, uids);
        builder.all().search();
        builder.answered().search();
        builder.bcc(COMMON_LETTER).search();
        builder.bcc(NAME).search();
        builder.bcc(ANOTHER_NAME).search();
        builder.bcc(DOMAIN).search();
        builder.bcc(ANOTHER_DOMAIN).search();
        builder.body(COMMON_LETTER).search();
        builder.body(COMMON_WORD).search();
        builder.body(UNCOMMON_WORD).search();
        builder.body(UNCOMMON_PHRASE).search();
        builder.cc(COMMON_LETTER).search();
        builder.cc(NAME).search();
        builder.cc(ANOTHER_NAME).search();
        builder.cc(DOMAIN).search();
        builder.cc(ANOTHER_DOMAIN).search();
        builder.deleted().search();
        builder.draft().search();
        builder.flagged().search();
        builder.from(COMMON_LETTER).search();
        builder.from(NAME).search();
        builder.from(ANOTHER_NAME).search();
        builder.from(DOMAIN).search();
        builder.from(ANOTHER_DOMAIN).search();
        builder.header(HEADER, DOMAIN).search();
        builder.header(HEADER, COMMON_LETTER).search();
        builder.header(HEADER, ANOTHER_DOMAIN).search();
        builder.header(HEADER, "\"\"").search();
        builder.header(ANOTHER_HEADER, DOMAIN).search();
        builder.header(ANOTHER_HEADER, COMMON_LETTER).search();
        builder.header(ANOTHER_HEADER, ANOTHER_DOMAIN).search();
        builder.header(ANOTHER_HEADER, "\"\"").search();
        builder.larger(10L).search();
        builder.larger(100L).search();
        builder.larger(1000L).search();
        builder.larger(10000L).search();
        builder.larger(12500L).search();
        builder.larger(15000L).search();
        builder.larger(20000L).search();
        builder.newOperator().search();
        builder.not().flagged().search();
        builder.msn(3, 5).search();
        builder.msnAndDown(10).search();
        builder.msnAndUp(17).search();
        builder.old().search();
        builder.or().answered().flagged().search();
        builder.recent().search();
        builder.seen().search();
        builder.sentbefore(2007, 10, 10).search();
        builder.sentbefore(2008, 1, 1).search();
        builder.sentbefore(2008, 2, 1).search();
        builder.sentbefore(2008, 2, 10).search();
        builder.sentbefore(2008, 2, 20).search();
        builder.sentbefore(2008, 2, 25).search();
        builder.sentbefore(2008, 3, 1).search();
        builder.sentbefore(2008, 3, 5).search();
        builder.sentbefore(2008, 3, 10).search();
        builder.sentbefore(2008, 4, 1).search();
        builder.senton(2007, 10, 10).search();
        builder.senton(2008, 1, 1).search();
        builder.senton(2008, 2, 1).search();
        builder.senton(2008, 2, 10).search();
        builder.senton(2008, 2, 20).search();
        builder.senton(2008, 2, 25).search();
        builder.senton(2008, 3, 1).search();
        builder.senton(2008, 3, 5).search();
        builder.senton(2008, 3, 10).search();
        builder.senton(2008, 4, 1).search();
        builder.sentsince(2007, 10, 10).search();
        builder.sentsince(2008, 1, 1).search();
        builder.sentsince(2008, 2, 1).search();
        builder.sentsince(2008, 2, 10).search();
        builder.sentsince(2008, 2, 20).search();
        builder.sentsince(2008, 2, 25).search();
        builder.sentsince(2008, 3, 1).search();
        builder.sentsince(2008, 3, 5).search();
        builder.sentsince(2008, 3, 10).search();
        builder.sentsince(2008, 4, 1).search();
        builder.smaller(10).search();
        builder.smaller(100).search();
        builder.smaller(1000).search();
        builder.smaller(10000).search();
        builder.smaller(12500).search();
        builder.smaller(15000).search();
        builder.smaller(20000).search();
        builder.subject(COMMON_LETTER).search();
        builder.subject(COMMON_WORD).search();
        builder.subject(UNCOMMON_PHRASE).search();
        builder.subject(UNCOMMON_WORD).search();
        builder.subject(RE).search();
        builder.text(COMMON_LETTER).search();
        builder.text(COMMON_WORD).search();
        builder.text(UNCOMMON_PHRASE).search();
        builder.text(UNCOMMON_WORD).search();
        builder.text(RE).search();
        builder.text(DOMAIN).search();
        builder.text(ANOTHER_DOMAIN).search();
        builder.text(ANOTHER_NAME).search();
        builder.text(NAME).search();
        builder.to(COMMON_LETTER).search();
        builder.to(NAME).search();
        builder.to(ANOTHER_NAME).search();
        builder.to(DOMAIN).search();
        builder.to(ANOTHER_DOMAIN).search();
        builder.uid().msn(1, 4).search();
        builder.unanswered().search();
        builder.undeleted().search();
        builder.undraft().search();
        builder.unflagged().search();
        builder.unseen().search();
        builder.quit();
    }

    private static void setupSearch(ScriptBuilder builder, boolean uids) throws Exception {
        builder.setUidSearch(uids);
        CreateScript.setup(builder);
        CreateScript.padUids(builder);
        CreateScript.loadLotsOfMail(builder);
        builder.store(builder.flags().add().flagged().range(1L, 9L));
        builder.store(builder.flags().add().answered().range(1L, 4L));
        builder.store(builder.flags().add().answered().range(10L, 14L));
        builder.store(builder.flags().add().seen().range(1L, 2L));
        builder.store(builder.flags().add().seen().range(5L, 7L));
        builder.store(builder.flags().add().seen().range(10L, 12L));
        builder.store(builder.flags().add().seen().range(15L, 17L));
        builder.store(builder.flags().add().draft().msn(1L));
        builder.store(builder.flags().add().draft().msn(3L));
        builder.store(builder.flags().add().draft().msn(5L));
        builder.store(builder.flags().add().draft().msn(7L));
        builder.store(builder.flags().add().draft().msn(9L));
        builder.store(builder.flags().add().draft().msn(11L));
        builder.store(builder.flags().add().draft().msn(13L));
        builder.store(builder.flags().add().draft().msn(15L));
        builder.store(builder.flags().add().draft().msn(17L));
        builder.store(builder.flags().add().deleted().range(1L, 3L));
    }

    private static void setup(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
    }

    private static void padUids(ScriptBuilder builder) throws Exception {
        builder.setFile("rfc822.mail");
        for (int i = 0; i < 20; ++i) {
            builder.append();
            builder.flagDeleted().expunge();
        }
    }

    private static void loadLotsOfMail(ScriptBuilder builder) throws Exception {
        builder.append();
        builder.setFile("wild-example.mail");
        builder.append();
        builder.setFile("multipart-alt.mail");
        builder.append();
        builder.setFile("multipart-mixed.mail");
        builder.append();
        builder.setFile("multipart-mixed-complex.mail");
        builder.append();
        builder.setFile("rfc822-hello-world.mail");
        builder.append();
        builder.setFile("rfc822-sender.mail");
        builder.append();
        builder.setFile("rfc822.mail");
        builder.append();
        builder.setFile("rfc822-multiple-addresses.mail");
        builder.append();
        builder.setFile("wild-alt-reply.mail");
        builder.append();
        builder.setFile("wild-mixed-alt.mail");
        builder.append();
        builder.setFile("wild-mixed.mail");
        builder.append();
        builder.setFile("rfc822-reply.mail");
        builder.append();
        builder.setFile("rfc822-resent.mail");
        builder.append();
        builder.setFile("rfc822-trace.mail");
        builder.append();
        builder.setFile("rfc822-group-addresses.mail");
        builder.append();
        builder.setFile("wild-alt-another-reply.mail");
        builder.append();
        builder.setFile("wild-alt-reply3.mail");
        builder.append();
        builder.setFile("wild-alt-reply4.mail");
        builder.append();
    }

    public static void notHeaderFetches(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.append();
        builder.setFile("wild-example.mail");
        builder.append();
        builder.setFile("multipart-alt.mail");
        builder.append();
        builder.setFile("multipart-mixed.mail");
        builder.append();
        builder.setFile("multipart-mixed-complex.mail");
        builder.append();
        builder.setFile("rfc822-hello-world.mail");
        builder.append();
        builder.setFile("rfc822-sender.mail");
        builder.append();
        builder.setFile("rfc822.mail");
        builder.append();
        builder.setFile("rfc822-multiple-addresses.mail");
        builder.append();
        builder.select();
        builder.getFetch().bodyPeekCompleteMessage();
        builder.fetchAllMessages();
        builder.resetFetch();
        builder.getFetch().bodyPeekNotHeaders(ScriptBuilder.Fetch.SELECT_HEADERS);
        builder.fetchAllMessages();
        builder.select();
        builder.quit();
    }

    public static void simpleCombinedFetches(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.append();
        builder.setFile("wild-example.mail");
        builder.append();
        builder.setFile("multipart-alt.mail");
        builder.append();
        builder.setFile("multipart-mixed.mail");
        builder.append();
        builder.setFile("multipart-mixed-complex.mail");
        builder.append();
        builder.setFile("rfc822-hello-world.mail");
        builder.append();
        builder.setFile("rfc822-sender.mail");
        builder.append();
        builder.setFile("rfc822.mail");
        builder.append();
        builder.setFile("rfc822-multiple-addresses.mail");
        builder.append();
        builder.select();
        builder.getFetch().bodyPeekCompleteMessage();
        builder.fetchAllMessages();
        builder.resetFetch();
        builder.getFetch().bodyPeekHeaders(ScriptBuilder.Fetch.COMPREHENSIVE_HEADERS);
        builder.fetchAllMessages();
        builder.select();
        builder.quit();
    }

    public static void recent(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.append();
        builder.select();
        builder.fetchFlags();
        builder.fetchSection("");
        builder.fetchFlags();
        builder.quit();
    }

    public static void multipartMixedMessagesPeek(ScriptBuilder builder) throws Exception {
        builder.setPeek(true);
        CreateScript.multipartMixedMessages(builder);
    }

    public static void multipartMixedMessages(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.setFile("multipart-mixed-complex.mail");
        builder.append();
        builder.select();
        builder.fetchSection("");
        builder.fetchSection("TEXT");
        builder.fetchSection("HEADER");
        builder.fetchSection("1");
        builder.fetchSection("2");
        builder.fetchSection("3");
        builder.fetchSection("3.HEADER");
        builder.fetchSection("3.TEXT");
        builder.fetchSection("3.1");
        builder.fetchSection("3.2");
        builder.fetchSection("4");
        builder.fetchSection("4.1");
        builder.fetchSection("4.1.MIME");
        builder.fetchSection("4.2");
        builder.fetchSection("4.2.HEADER");
        builder.fetchSection("4.2.TEXT");
        builder.fetchSection("4.2.1");
        builder.fetchSection("4.2.2");
        builder.fetchSection("4.2.2.1");
        builder.fetchSection("4.2.2.2");
        builder.select();
        builder.quit();
    }

    public static void multipartAlternativePeek(ScriptBuilder builder) throws Exception {
        builder.setPeek(true);
        CreateScript.multipartAlternative(builder);
    }

    public static void multipartAlternative(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.setFile("multipart-alt.mail");
        builder.append();
        builder.select();
        builder.fetchSection("");
        builder.fetchSection("TEXT");
        builder.fetchSection("HEADER");
        builder.fetchSection("1");
        builder.fetchSection("2");
        builder.fetchSection("3");
        builder.select();
        builder.quit();
    }

    public static void multipartMixedPeek(ScriptBuilder builder) throws Exception {
        builder.setPeek(true);
        CreateScript.multipartMixed(builder);
    }

    public static void multipartMixed(ScriptBuilder builder) throws Exception {
        builder.login();
        builder.create();
        builder.select();
        builder.setFile("multipart-mixed.mail");
        builder.append();
        builder.select();
        builder.fetchSection("");
        builder.fetchSection("TEXT");
        builder.fetchSection("HEADER");
        builder.fetchSection("1");
        builder.fetchSection("2");
        builder.fetchSection("3");
        builder.fetchSection("4");
        builder.select();
        builder.quit();
    }
}

