/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.app;

import java.io.File;
import java.io.FileInputStream;
import org.apache.james.mpt.Runner;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.host.ExternalHostSystem;
import org.apache.james.mpt.monitor.SystemLoggingMonitor;
import org.apache.james.mpt.protocol.ProtocolSessionBuilder;
import org.apache.james.util.Port;

class RunScript {
    private static final ImapFeatures SUPPORTED_FEATURES = ImapFeatures.of(ImapFeatures.Feature.NAMESPACE_SUPPORT);
    private final File file;
    private final Port port;
    private final String host;
    private final String shabang;
    private final SystemLoggingMonitor monitor;

    public RunScript(File file, Port port, String host, String shabang, boolean verbose) {
        this.file = file;
        this.port = port;
        this.host = host;
        this.shabang = shabang;
        this.monitor = new SystemLoggingMonitor(verbose);
    }

    public void run() throws Exception {
        System.out.println("Running " + String.valueOf(this.file) + " against " + this.host + ":" + this.port.getValue() + "...");
        ExternalHostSystem host = new ExternalHostSystem(SUPPORTED_FEATURES, this.host, this.port, this.monitor, this.shabang, null);
        ProtocolSessionBuilder builder = new ProtocolSessionBuilder();
        Runner runner = new Runner();
        builder.addProtocolLines(this.file.getName(), new FileInputStream(this.file), runner.getTestElements());
        runner.runSessions(host);
    }
}

