/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.search;

import jakarta.inject.Inject;
import jakarta.mail.Flags;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxMessageDAO;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class NotDeletedWithRangeSearchOverride
implements ListeningMessageSearchIndex.SearchOverride {
    private final PostgresExecutor.Factory executorFactory;

    @Inject
    public NotDeletedWithRangeSearchOverride(PostgresExecutor.Factory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public boolean applicable(SearchQuery searchQuery, MailboxSession session) {
        return this.isDeletedUnset(searchQuery) || this.isDeletedNotSet(searchQuery);
    }

    private boolean isDeletedUnset(SearchQuery searchQuery) {
        return searchQuery.getCriteria().size() == 2 && searchQuery.getCriteria().contains(SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.DELETED)) && searchQuery.getCriteria().stream().anyMatch(criterion -> criterion instanceof SearchQuery.UidCriterion) && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    private boolean isDeletedNotSet(SearchQuery searchQuery) {
        return searchQuery.getCriteria().size() == 2 && searchQuery.getCriteria().contains(SearchQuery.not((SearchQuery.Criterion)SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DELETED))) && searchQuery.getCriteria().stream().anyMatch(criterion -> criterion instanceof SearchQuery.UidCriterion) && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    public Flux<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) {
        SearchQuery.UidCriterion uidArgument = searchQuery.getCriteria().stream().filter(criterion -> criterion instanceof SearchQuery.UidCriterion).map(SearchQuery.UidCriterion.class::cast).findAny().orElseThrow(() -> new RuntimeException("Missing Uid argument"));
        SearchQuery.UidRange[] uidRanges = uidArgument.getOperator().getRange();
        return Mono.fromCallable(() -> new PostgresMailboxMessageDAO(this.executorFactory.create(session.getUser().getDomainPart()))).flatMapMany(dao -> Flux.fromArray((Object[])uidRanges).concatMap(range -> dao.listNotDeletedUids((PostgresMailboxId)mailbox.getMailboxId(), MessageRange.range((MessageUid)range.getLowValue(), (MessageUid)range.getHighValue()))));
    }
}

