/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.mailbox.model.Attachment;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.Cid;

public class MessageAttachment {
    private final Attachment attachment;
    private final Optional<String> name;
    private final Optional<Cid> cid;
    private final boolean isInline;

    public static Builder builder() {
        return new Builder();
    }

    public MessageAttachment(Attachment attachment, Optional<String> name, Optional<Cid> cid, boolean isInline) {
        this.attachment = attachment;
        this.name = name;
        this.cid = cid;
        this.isInline = isInline;
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public AttachmentId getAttachmentId() {
        return this.attachment.getAttachmentId();
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<Cid> getCid() {
        return this.cid;
    }

    public boolean isInline() {
        return this.isInline;
    }

    public boolean isInlinedWithCid() {
        return this.isInline && this.cid.isPresent();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageAttachment) {
            MessageAttachment other = (MessageAttachment)obj;
            return Objects.equal((Object)this.attachment, (Object)other.attachment) && Objects.equal(this.name, other.name) && Objects.equal(this.cid, other.cid) && Objects.equal((Object)this.isInline, (Object)other.isInline);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attachment, this.name, this.cid, this.isInline});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attachment", (Object)this.attachment).add("name", this.name).add("cid", this.cid).add("isInline", this.isInline).toString();
    }

    public static class Builder {
        private Attachment attachment;
        private Optional<String> name;
        private Optional<Cid> cid;
        private Optional<Boolean> isInline = Optional.empty();

        private Builder() {
            this.name = Optional.empty();
            this.cid = Optional.empty();
        }

        public Builder attachment(Attachment attachment) {
            Preconditions.checkArgument((attachment != null ? 1 : 0) != 0);
            this.attachment = attachment;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder cid(Optional<Cid> cid) {
            Preconditions.checkNotNull(cid);
            this.cid = cid;
            return this;
        }

        public Builder cid(Cid cid) {
            this.cid = Optional.ofNullable(cid);
            return this;
        }

        public Builder isInline(Boolean isInline) {
            this.isInline = Optional.ofNullable(isInline);
            return this;
        }

        public MessageAttachment build() {
            Preconditions.checkState((this.attachment != null ? 1 : 0) != 0, (Object)"'attachment' is mandatory");
            return new MessageAttachment(this.attachment, this.name, this.cid, this.isInline.orElse(false));
        }
    }
}

