/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.HasEmptyMailboxNameInHierarchyException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.TooLongMailboxNameException;

public class MailboxPath {
    private static final String INVALID_CHARS = "%*&#";
    private static final CharMatcher INVALID_CHARS_MATCHER = CharMatcher.anyOf((CharSequence)"%*&#");
    public static final int MAX_MAILBOX_NAME_LENGTH = 200;
    private final String namespace;
    private final Username user;
    private final String name;

    public static MailboxPath inbox(MailboxSession session) {
        return MailboxPath.inbox(session.getUser());
    }

    public static MailboxPath inbox(Username username) {
        return MailboxPath.forUser(username, "INBOX");
    }

    public static MailboxPath forUser(Username username, String mailboxName) {
        return new MailboxPath("#private", username, mailboxName);
    }

    public MailboxPath(String namespace, Username user, String name) {
        this.namespace = Optional.ofNullable(namespace).filter(s -> !s.isEmpty()).orElse("#private");
        this.user = user;
        this.name = name;
    }

    public MailboxPath(MailboxPath mailboxPath) {
        this(mailboxPath.getNamespace(), mailboxPath.getUser(), mailboxPath.getName());
    }

    public MailboxPath(MailboxPath mailboxPath, String name) {
        this(mailboxPath.getNamespace(), mailboxPath.getUser(), name);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Username getUser() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    public boolean belongsTo(MailboxSession mailboxSession) {
        return this.user.equals((Object)mailboxSession.getUser());
    }

    public MailboxPath child(String childName, char delimiter) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)childName) ? 1 : 0) != 0, (Object)"'childName' should not be null or empty");
        Preconditions.checkArgument((!childName.contains(String.valueOf(delimiter)) ? 1 : 0) != 0, (Object)"'childName' should not contain delimiter");
        return new MailboxPath(this.namespace, this.user, this.name + delimiter + childName);
    }

    public List<MailboxPath> getHierarchyLevels(char delimiter) {
        if (this.name == null) {
            return ImmutableList.of((Object)this);
        }
        ArrayList<MailboxPath> levels = new ArrayList<MailboxPath>();
        int index = this.name.indexOf(delimiter);
        while (index >= 0) {
            String levelname = this.name.substring(0, index);
            levels.add(new MailboxPath(this.namespace, this.user, levelname));
            ++index;
            index = this.name.indexOf(delimiter, index);
        }
        levels.add(this);
        return levels;
    }

    public MailboxPath sanitize(char delimiter) {
        if (this.name == null) {
            return this;
        }
        if (this.name.endsWith(String.valueOf(delimiter))) {
            int length = this.name.length();
            String sanitizedName = this.name.substring(0, length - 1);
            return new MailboxPath(this.namespace, this.user, sanitizedName);
        }
        return this;
    }

    public void assertAcceptable(char pathDelimiter) throws MailboxNameException {
        if (this.hasEmptyNameInHierarchy(pathDelimiter)) {
            throw new HasEmptyMailboxNameInHierarchyException(this.asString());
        }
        if (this.nameContainsForbiddenCharacters()) {
            throw new MailboxNameException(this.asString() + " contains one of the forbidden characters " + INVALID_CHARS);
        }
        if (this.isMailboxNameTooLong()) {
            throw new TooLongMailboxNameException("Mailbox name exceeds maximum size of 200 characters");
        }
    }

    private boolean nameContainsForbiddenCharacters() {
        return INVALID_CHARS_MATCHER.matchesAnyOf((CharSequence)this.name);
    }

    private boolean isMailboxNameTooLong() {
        return this.name.length() > 200;
    }

    boolean hasEmptyNameInHierarchy(char pathDelimiter) {
        String delimiterString = String.valueOf(pathDelimiter);
        return this.name.isEmpty() || this.name.contains(delimiterString + delimiterString) || this.name.startsWith(delimiterString) || this.name.endsWith(delimiterString);
    }

    public String asString() {
        return this.namespace + ":" + this.user.asString() + ":" + this.name;
    }

    public boolean isInbox() {
        return "INBOX".equalsIgnoreCase(this.name);
    }

    public String toString() {
        return this.asString();
    }

    public final boolean equals(Object o) {
        if (o instanceof MailboxPath) {
            MailboxPath that = (MailboxPath)o;
            return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.user, that.user) && Objects.equals(this.name, that.name);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.namespace, this.user, this.name);
    }

    @Deprecated
    public String getFullName(char delimiter) {
        return this.namespace + delimiter + this.name;
    }
}

