/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.RequestAware;
import org.apache.james.mailbox.RightManager;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.reactivestreams.Publisher;

public interface MailboxManager
extends RequestAware,
RightManager,
MailboxAnnotationManager,
SessionProvider {
    public static final int MAX_MAILBOX_NAME_LENGTH = 200;

    public EnumSet<MailboxCapabilities> getSupportedMailboxCapabilities();

    public boolean hasCapability(MailboxCapabilities var1);

    public EnumSet<MessageCapabilities> getSupportedMessageCapabilities();

    public EnumSet<SearchCapabilities> getSupportedSearchCapabilities();

    public MessageManager getMailbox(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public MessageManager getMailbox(MailboxId var1, MailboxSession var2) throws MailboxException;

    public Optional<MailboxId> createMailbox(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public void deleteMailbox(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public Mailbox deleteMailbox(MailboxId var1, MailboxSession var2) throws MailboxException;

    public void renameMailbox(MailboxPath var1, MailboxPath var2, MailboxSession var3) throws MailboxException;

    public void renameMailbox(MailboxId var1, MailboxPath var2, MailboxSession var3) throws MailboxException;

    public List<MessageRange> copyMessages(MessageRange var1, MailboxPath var2, MailboxPath var3, MailboxSession var4) throws MailboxException;

    public List<MessageRange> copyMessages(MessageRange var1, MailboxId var2, MailboxId var3, MailboxSession var4) throws MailboxException;

    public List<MessageRange> moveMessages(MessageRange var1, MailboxPath var2, MailboxPath var3, MailboxSession var4) throws MailboxException;

    public List<MailboxMetaData> search(MailboxQuery var1, MailboxSession var2) throws MailboxException;

    public List<MessageId> search(MultimailboxesSearchQuery var1, MailboxSession var2, long var3) throws MailboxException;

    public Publisher<Boolean> mailboxExists(MailboxPath var1, MailboxSession var2) throws MailboxException;

    default public Publisher<Boolean> hasInbox(MailboxSession session) throws MailboxException {
        return this.mailboxExists(MailboxPath.inbox(session), session);
    }

    public List<MailboxPath> list(MailboxSession var1) throws MailboxException;

    public boolean hasChildren(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public static enum SearchCapabilities {
        MultimailboxSearch,
        PartialEmailMatch,
        Text,
        FullText,
        Attachment,
        AttachmentFileName;

    }

    public static enum MessageCapabilities {
        UniqueID;

    }

    public static enum MailboxCapabilities {
        Annotation,
        Move,
        Namespace,
        UserFlag,
        ACL,
        Quota;

    }
}

