/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.main;

import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.MailboxTyper;
import org.apache.james.imap.message.response.UnpooledStatusResponseFactory;
import org.apache.james.imap.processor.DefaultProcessorChain;
import org.apache.james.imap.processor.base.ImapResponseMessageProcessor;
import org.apache.james.imap.processor.base.UnknownRequestProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.SubscriptionManager;

public class DefaultImapProcessorFactory {
    private MailboxManager mailboxManager;
    private SubscriptionManager subscriptionManager;
    private MailboxTyper mailboxTyper;

    public static final ImapProcessor createDefaultProcessor(MailboxManager mailboxManager, SubscriptionManager subscriptionManager) {
        return DefaultImapProcessorFactory.createXListSupportingProcessor(mailboxManager, subscriptionManager, null, 100);
    }

    public static final ImapProcessor createDefaultProcessor(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, int batchSize) {
        return DefaultImapProcessorFactory.createXListSupportingProcessor(mailboxManager, subscriptionManager, null, batchSize);
    }

    public static final ImapProcessor createXListSupportingProcessor(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxTyper mailboxTyper) {
        return DefaultImapProcessorFactory.createXListSupportingProcessor(mailboxManager, subscriptionManager, mailboxTyper, 100);
    }

    public static final ImapProcessor createXListSupportingProcessor(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxTyper mailboxTyper, int batchSize) {
        UnpooledStatusResponseFactory statusResponseFactory = new UnpooledStatusResponseFactory();
        UnknownRequestProcessor unknownRequestImapProcessor = new UnknownRequestProcessor((StatusResponseFactory)statusResponseFactory);
        ImapProcessor imap4rev1Chain = DefaultProcessorChain.createDefaultChain(unknownRequestImapProcessor, mailboxManager, subscriptionManager, (StatusResponseFactory)statusResponseFactory, mailboxTyper, batchSize);
        ImapResponseMessageProcessor result = new ImapResponseMessageProcessor(imap4rev1Chain);
        return result;
    }

    public final MailboxManager getMailboxManager() {
        return this.mailboxManager;
    }

    public final void setMailboxManager(MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public final SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public final void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    public ImapProcessor buildImapProcessor() {
        return DefaultImapProcessorFactory.createDefaultProcessor(this.mailboxManager, this.subscriptionManager);
    }

    public MailboxTyper getMailboxTyper() {
        return this.mailboxTyper;
    }

    public void setMailboxTyper(MailboxTyper mailboxTyper) {
        this.mailboxTyper = mailboxTyper;
    }
}

