/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.mailbox.MessageResult;

public class MimeBodyElement
implements FetchResponse.BodyElement {
    private final String name;
    protected final List<MessageResult.Header> headers;
    protected long size;

    public MimeBodyElement(String name, List<MessageResult.Header> headers) {
        this.name = name;
        this.headers = headers;
        this.size = this.calculateSize(headers);
    }

    public String getName() {
        return this.name;
    }

    protected long calculateSize(List<MessageResult.Header> headers) {
        int result;
        if (headers.isEmpty()) {
            result = 0;
        } else {
            int count = 0;
            for (MessageResult.Header header : headers) {
                count = (int)((long)count + (header.size() + (long)"\r\n".length()));
            }
            result = count + "\r\n".length();
        }
        return result;
    }

    public long size() {
        return this.size;
    }

    public void writeTo(WritableByteChannel channel) throws IOException {
        ByteBuffer endLine = ByteBuffer.wrap("\r\n".getBytes());
        endLine.rewind();
        for (MessageResult.Header header : this.headers) {
            header.writeTo(channel);
            while (channel.write(endLine) > 0) {
            }
            endLine.rewind();
        }
        if (this.size > 0L) {
            while (channel.write(endLine) > 0) {
            }
        }
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeTo(Channels.newChannel(out));
        return new ByteArrayInputStream(out.toByteArray());
    }
}

