/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.processor.base.ImapStateAwareMailboxListener;
import org.apache.james.mailbox.MailboxListener;

public class UidToMsnConverter
extends ImapStateAwareMailboxListener {
    private SortedMap<Integer, Long> msnToUid = new TreeMap<Integer, Long>();
    private SortedMap<Long, Integer> uidToMsn = new TreeMap<Long, Integer>();
    private long highestUid = 0L;
    private int highestMsn = 0;
    private boolean closed = false;

    public UidToMsnConverter(ImapSession session, Iterator<Long> uids) {
        super(session);
        if (uids != null) {
            int msn = 1;
            while (uids.hasNext()) {
                Long uid = uids.next();
                this.highestUid = uid;
                this.highestMsn = msn;
                this.msnToUid.put(msn, uid);
                this.uidToMsn.put(uid, msn);
                ++msn;
            }
        }
    }

    public synchronized long getUid(int msn) {
        if (msn == -1) {
            return -1L;
        }
        Long uid = (Long)this.msnToUid.get(msn);
        if (uid != null) {
            return uid;
        }
        return -1L;
    }

    public synchronized int getMsn(long uid) {
        Integer msn = (Integer)this.uidToMsn.get(uid);
        if (msn != null) {
            return msn;
        }
        return -1;
    }

    private void add(int msn, long uid) {
        if (uid > this.highestUid) {
            this.highestUid = uid;
        }
        this.msnToUid.put(msn, uid);
        this.uidToMsn.put(uid, msn);
    }

    public synchronized void expunge(long uid) {
        int msn = this.getMsn(uid);
        this.remove(msn, uid);
        ArrayList<Integer> renumberMsns = new ArrayList<Integer>(this.msnToUid.tailMap(msn + 1).keySet());
        for (Integer msnInteger : renumberMsns) {
            int aMsn = msnInteger;
            long aUid = this.getUid(aMsn);
            this.remove(aMsn, aUid);
            this.add(aMsn - 1, aUid);
        }
        --this.highestMsn;
    }

    private void remove(int msn, long uid) {
        this.uidToMsn.remove(uid);
        this.msnToUid.remove(msn);
    }

    public synchronized void add(long uid) {
        if (!this.uidToMsn.containsKey(uid)) {
            ++this.highestMsn;
            this.add(this.highestMsn, uid);
        }
    }

    public synchronized void event(MailboxListener.Event event) {
        if (event instanceof MailboxListener.Added) {
            List uids = ((MailboxListener.Added)event).getUids();
            for (int i = 0; i < uids.size(); ++i) {
                this.add((Long)uids.get(i));
            }
        }
    }

    public synchronized long getFirstUid() {
        if (this.uidToMsn.isEmpty()) {
            return -1L;
        }
        return this.uidToMsn.firstKey();
    }

    public synchronized long getLastUid() {
        if (this.uidToMsn.isEmpty()) {
            return -1L;
        }
        return this.uidToMsn.lastKey();
    }

    public synchronized void close() {
        this.uidToMsn.clear();
        this.msnToUid.clear();
        this.closed = true;
    }

    public synchronized long getCount() {
        return this.uidToMsn.size();
    }

    @Override
    protected synchronized boolean isListenerClosed() {
        return this.closed;
    }
}

