/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.main;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.ImapRequestStreamLineReader;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.base.ImapResponseComposerImpl;
import org.apache.james.imap.main.AbstractImapRequestHandler;
import org.apache.james.imap.main.OutputStreamImapResponseWriter;
import org.apache.james.imap.message.request.SystemMessage;
import org.slf4j.Logger;

public final class ImapRequestStreamHandler
extends AbstractImapRequestHandler {
    public ImapRequestStreamHandler(ImapDecoder decoder, ImapProcessor processor, ImapEncoder encoder) {
        super(decoder, processor, encoder);
    }

    public boolean handleRequest(InputStream input, OutputStream output, ImapSession session) {
        boolean result;
        if (this.isSelectedMailboxDeleted(session)) {
            this.writeSignoff(output, session);
            result = false;
        } else {
            ImapRequestStreamLineReader request = new ImapRequestStreamLineReader(input, output);
            Logger logger = session.getLog();
            try {
                ((ImapRequestLineReader)request).nextChar();
            }
            catch (DecodingException e) {
                logger.debug("Unexpected end of line. Cannot handle request: ", (Throwable)e);
                this.abandon(output, session);
                return false;
            }
            ImapResponseComposerImpl response = new ImapResponseComposerImpl(new OutputStreamImapResponseWriter(output));
            if (this.doProcessRequest(request, response, session)) {
                try {
                    request.consumeLine();
                }
                catch (DecodingException e) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Fault during clean up: " + e.getMessage());
                    }
                    logger.debug("Abandoning after fault in clean up", (Throwable)e);
                    this.abandon(output, session);
                    return false;
                }
                result = ImapSessionState.LOGOUT != session.getState();
            } else {
                logger.debug("Connection was abandoned after request processing failed.");
                result = false;
                this.abandon(output, session);
            }
        }
        return result;
    }

    private void writeSignoff(OutputStream output, ImapSession session) {
        try {
            output.write(MAILBOX_DELETED_SIGNOFF);
        }
        catch (IOException e) {
            session.getLog().warn("Failed to write signoff");
            session.getLog().debug("Failed to write signoff:", (Throwable)e);
        }
    }

    private void abandon(OutputStream out, ImapSession session) {
        if (session != null) {
            try {
                session.logout();
            }
            catch (Throwable t) {
                session.getLog().warn("Session logout failed. Resources may not be correctly recycled.");
            }
        }
        try {
            out.write(ABANDON_SIGNOFF);
        }
        catch (Throwable t) {
            session.getLog().debug("Failed to write ABANDON_SIGNOFF", t);
        }
        this.processor.process((ImapMessage)SystemMessage.FORCE_LOGOUT, (ImapProcessor.Responder)new AbstractImapRequestHandler.SilentResponder(), session);
    }
}

