/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.VanishedResponse;

public class VanishedResponseEncoder
extends AbstractChainedImapEncoder {
    public VanishedResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    protected boolean isAcceptable(ImapMessage message) {
        return message instanceof VanishedResponse;
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        VanishedResponse vr = (VanishedResponse)acceptableMessage;
        composer.untagged();
        composer.message("VANISHED");
        if (vr.isEarlier()) {
            composer.openParen();
            composer.message("EARLIER");
            composer.closeParen();
        }
        composer.sequenceSet(vr.getUids());
        composer.end();
    }
}

