/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.Set;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.EnableResponse;

public class EnableResponseEncoder
extends AbstractChainedImapEncoder {
    public EnableResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        EnableResponse response = (EnableResponse)acceptableMessage;
        Set<String> capabilities = response.getCapabilities();
        composer.untagged();
        composer.message("ENABLED");
        for (String capability : capabilities) {
            composer.message(capability);
        }
        composer.end();
    }

    @Override
    protected boolean isAcceptable(ImapMessage message) {
        return message instanceof EnableResponse;
    }
}

