/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.parser.AbstractUidCommandParser;
import org.apache.james.imap.message.request.ListRequest;

public class ListCommandParser
extends AbstractUidCommandParser {
    public ListCommandParser() {
        super(ImapCommand.authenticatedStateCommand((String)"LIST"));
    }

    protected ListCommandParser(ImapCommand command) {
        super(command);
    }

    public String listMailbox(ImapRequestLineReader request) throws DecodingException {
        char next = request.nextWordChar();
        switch (next) {
            case '\"': {
                return request.consumeQuoted();
            }
            case '{': {
                return request.consumeLiteral(null);
            }
        }
        return request.consumeWord(new ListCharValidator());
    }

    @Override
    protected ImapMessage decode(ImapCommand command, ImapRequestLineReader request, String tag, boolean useUids, ImapSession session) throws DecodingException {
        String referenceName = request.mailbox();
        String mailboxPattern = this.listMailbox(request);
        request.eol();
        ImapMessage result = this.createMessage(command, referenceName, mailboxPattern, tag);
        return result;
    }

    protected ImapMessage createMessage(ImapCommand command, String referenceName, String mailboxPattern, String tag) {
        ListRequest result = new ListRequest(command, referenceName, mailboxPattern, tag);
        return result;
    }

    private class ListCharValidator
    extends ImapRequestLineReader.ATOM_CHARValidator {
        private ListCharValidator() {
        }

        @Override
        public boolean isValid(char chr) {
            if (ImapRequestLineReader.isListWildcard(chr)) {
                return true;
            }
            return super.isValid(chr);
        }
    }
}

