/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.es.v7;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.FileNotFoundException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.metrics.es.v7.ESReporterConfiguration;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESMetricReporterModule
extends AbstractModule {
    private static final String ELASTICSEARCH_CONFIGURATION_NAME = "elasticsearch";
    private static final String ELASTICSEARCH_MASTER_HOST = "elasticsearch.masterHost";
    private static final Logger LOGGER = LoggerFactory.getLogger(ESMetricReporterModule.class);
    public static final boolean DEFAULT_DISABLE = false;
    public static final int DEFAULT_ES_HTTP_PORT = 9200;

    @Provides
    @Singleton
    public ESReporterConfiguration provideConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration propertiesReader = propertiesProvider.getConfiguration(ELASTICSEARCH_CONFIGURATION_NAME);
            if (this.isMetricEnable(propertiesReader)) {
                return ESReporterConfiguration.builder().enabled().onHost(this.locateHost(propertiesReader), propertiesReader.getInt("elasticsearch.http.port", 9200)).onIndex(propertiesReader.getString("elasticsearch.metrics.reports.index", null)).periodInSecond(propertiesReader.getLong("elasticsearch.metrics.reports.period", null)).build();
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.info("Can not locate elasticsearch configuration");
        }
        return ESReporterConfiguration.builder().disabled().build();
    }

    private String locateHost(Configuration propertiesReader) {
        return propertiesReader.getString("elasticsearch.http.host", propertiesReader.getString(ELASTICSEARCH_MASTER_HOST));
    }

    private boolean isMetricEnable(Configuration propertiesReader) {
        return propertiesReader.getBoolean("elasticsearch.metrics.reports.enabled", false);
    }
}

