/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.crowdsec.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.util.Objects;
import org.apache.james.crowdsec.model.CrowdsecDecisionDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(using=CrowdsecDecisionDeserializer.class)
public class CrowdsecDecision {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrowdsecDecision.class);
    public static final String BAN = "ban";
    private final Duration duration;
    private final long id;
    private final String origin;
    private final String scenario;
    private final String scope;
    private final String type;
    private final String value;

    public static Builder builder() {
        return new Builder();
    }

    private CrowdsecDecision(Duration duration, long id, String origin, String scenario, String scope, String type, String value) {
        this.id = id;
        this.origin = origin;
        this.scenario = scenario;
        this.scope = scope;
        this.type = type;
        this.value = value;
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public long getId() {
        return this.id;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getScenario() {
        return this.scenario;
    }

    public String getScope() {
        return this.scope;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof CrowdsecDecision)) {
            return false;
        }
        CrowdsecDecision that = (CrowdsecDecision)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.duration, that.duration) && Objects.equals(this.origin, that.origin) && Objects.equals(this.scenario, that.scenario) && Objects.equals(this.scope, that.scope) && Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
    }

    public final int hashCode() {
        return Objects.hash(this.duration, this.id, this.origin, this.scenario, this.scope, this.type, this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("duration", (Object)this.duration).add("id", this.id).add("origin", (Object)this.origin).add("scenario", (Object)this.scenario).add("scope", (Object)this.scope).add("type", (Object)this.type).add("value", (Object)this.value).toString();
    }

    public static class Builder {
        private Duration duration;
        private long id;
        private String origin;
        private String scenario;
        private String scope;
        private String type;
        private String value;

        public Builder duration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        public Builder scenario(String scenario) {
            this.scenario = scenario;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public CrowdsecDecision build() {
            return new CrowdsecDecision(this.duration, this.id, this.origin, this.scenario, this.scope, this.type, this.value);
        }
    }
}

