/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.crowdsec;

import org.apache.commons.net.util.SubnetUtils;
import org.apache.james.crowdsec.model.CrowdsecDecision;

public class CrowdsecUtils {
    public static boolean isBanned(CrowdsecDecision decision, String ip) {
        if (decision.getScope().equals("Ip") && ip.contains(decision.getValue())) {
            return true;
        }
        return decision.getScope().equals("Range") && CrowdsecUtils.belongToNetwork(decision.getValue(), ip);
    }

    private static boolean belongToNetwork(String value, String ip) {
        SubnetUtils subnetUtils = new SubnetUtils(value);
        subnetUtils.setInclusiveHostCount(true);
        return subnetUtils.getInfo().isInRange(ip);
    }
}

