/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.redis;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.reactive.RedisReactiveCommands;
import io.lettuce.core.api.reactive.RedisStringReactiveCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.masterreplica.MasterReplica;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.backends.redis.ClusterRedisConfiguration;
import org.apache.james.backends.redis.MasterReplicaRedisConfiguration;
import org.apache.james.backends.redis.RedisClientFactory;
import org.apache.james.backends.redis.RedisConfiguration;
import org.apache.james.backends.redis.RedisHealthCheck$;
import org.apache.james.backends.redis.SentinelRedisConfiguration;
import org.apache.james.backends.redis.StandaloneRedisConfiguration;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.MatchError;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005]q!B\n\u0015\u0011\u0003yb!B\u0011\u0015\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003bB\u0016\u0002\u0005\u0004%\t\u0001\f\u0005\u0007k\u0005\u0001\u000b\u0011B\u0017\t\u000fY\n!\u0019!C\u0001o!11)\u0001Q\u0001\naBq\u0001R\u0001C\u0002\u0013\u0005q\u0007\u0003\u0004F\u0003\u0001\u0006I\u0001\u000f\u0004\u0005CQ\u0001a\t\u0003\u0005S\u0013\t\u0005\t\u0015!\u0003T\u0011!1\u0016B!A!\u0002\u00139\u0006\"B\u0015\n\t\u0003Q\u0006bB4\n\u0005\u0004%I\u0001\u001b\u0005\u0007e&\u0001\u000b\u0011B5\t\u000fML!\u0019!C\u0005i\"1Q0\u0003Q\u0001\nUDQA`\u0005\u0005B}Dq!!\u0001\n\t\u0003\n\u0019!\u0001\tSK\u0012L7\u000fS3bYRD7\t[3dW*\u0011QCF\u0001\u0006e\u0016$\u0017n\u001d\u0006\u0003/a\t\u0001BY1dW\u0016tGm\u001d\u0006\u00033i\tQA[1nKNT!a\u0007\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0012aA8sO\u000e\u0001\u0001C\u0001\u0011\u0002\u001b\u0005!\"\u0001\u0005*fI&\u001c\b*Z1mi\"\u001c\u0005.Z2l'\t\t1\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\taB]3eSN\u001cu.\u001c9p]\u0016tG/F\u0001.!\tq3'D\u00010\u0015\t\u0001\u0014'A\u0006iK\u0006dG\u000f[2iK\u000e\\'B\u0001\u001a\u0019\u0003\u0011\u0019wN]3\n\u0005Qz#!D\"p[B|g.\u001a8u\u001d\u0006lW-A\bsK\u0012L7oQ8na>tWM\u001c;!\u00039AW-\u00197uQ\u000eCWmY6LKf,\u0012\u0001\u000f\t\u0003s\u0001s!A\u000f \u0011\u0005m*S\"\u0001\u001f\u000b\u0005ur\u0012A\u0002\u001fs_>$h(\u0003\u0002@K\u00051\u0001K]3eK\u001aL!!\u0011\"\u0003\rM#(/\u001b8h\u0015\tyT%A\biK\u0006dG\u000f[\"iK\u000e\\7*Z=!\u0003AAW-\u00197uQ\u000eCWmY6WC2,X-A\tiK\u0006dG\u000f[\"iK\u000e\\g+\u00197vK\u0002\u001a2!C$P!\tAU*D\u0001J\u0015\tQ5*\u0001\u0003mC:<'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d&\u0013aa\u00142kK\u000e$\bC\u0001\u0018Q\u0013\t\tvFA\u0006IK\u0006dG\u000f[\"iK\u000e\\\u0017A\u0005:fI&\u001c8\t\\5f]R4\u0015m\u0019;pef\u0004\"\u0001\t+\n\u0005U#\"A\u0005*fI&\u001c8\t\\5f]R4\u0015m\u0019;pef\f!C]3eSN\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0011\u0001\u0005W\u0005\u00033R\u0011!CU3eSN\u001cuN\u001c4jOV\u0014\u0018\r^5p]R\u00191\fX/\u0011\u0005\u0001J\u0001\"\u0002*\r\u0001\u0004\u0019\u0006\"\u0002,\r\u0001\u00049\u0006F\u0001\u0007`!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0004j]*,7\r\u001e\u0006\u0002I\u00069!.Y6beR\f\u0017B\u00014b\u0005\u0019IeN[3di\u0006q!/Y<SK\u0012L7o\u00117jK:$X#A5\u0011\u0005)\u0004X\"A6\u000b\u0005Ib'BA7o\u0003\u001daW\r\u001e;vG\u0016T\u0011a\\\u0001\u0003S>L!!]6\u0003'\u0005\u00137\u000f\u001e:bGR\u0014V\rZ5t\u00072LWM\u001c;\u0002\u001fI\fwOU3eSN\u001cE.[3oi\u0002\nAB]3eSN\u001cu.\\7b]\u0012,\u0012!\u001e\t\u0005mnD\u0004(D\u0001x\u0015\tA\u00180\u0001\u0005sK\u0006\u001cG/\u001b<f\u0015\tQ8.A\u0002ba&L!\u0001`<\u00037I+G-[:TiJLgn\u001a*fC\u000e$\u0018N^3D_6l\u0017M\u001c3t\u00035\u0011X\rZ5t\u0007>lW.\u00198eA\u0005i1m\\7q_:,g\u000e\u001e(b[\u0016$\u0012!L\u0001\u0006G\",7m\u001b\u000b\u0003\u0003\u000b\u0001b!a\u0002\u0002\u000e\u0005EQBAA\u0005\u0015\r\tY\u0001H\u0001\u0010e\u0016\f7\r^5wKN$(/Z1ng&!\u0011qBA\u0005\u0005%\u0001VO\u00197jg\",'\u000fE\u0002/\u0003'I1!!\u00060\u0005\u0019\u0011Vm];mi\u0002")
public class RedisHealthCheck
implements HealthCheck {
    private final AbstractRedisClient rawRedisClient;
    private final RedisStringReactiveCommands<String, String> redisCommand;

    public static String healthCheckValue() {
        return RedisHealthCheck$.MODULE$.healthCheckValue();
    }

    public static String healthCheckKey() {
        return RedisHealthCheck$.MODULE$.healthCheckKey();
    }

    public static ComponentName redisComponent() {
        return RedisHealthCheck$.MODULE$.redisComponent();
    }

    private AbstractRedisClient rawRedisClient() {
        return this.rawRedisClient;
    }

    private RedisStringReactiveCommands<String, String> redisCommand() {
        return this.redisCommand;
    }

    public ComponentName componentName() {
        return RedisHealthCheck$.MODULE$.redisComponent();
    }

    public Publisher<Result> check() {
        return SMono$.MODULE$.apply((Publisher)this.redisCommand().set((Object)RedisHealthCheck$.MODULE$.healthCheckKey(), (Object)RedisHealthCheck$.MODULE$.healthCheckValue()).then(this.redisCommand().getdel((Object)RedisHealthCheck$.MODULE$.healthCheckKey()))).map((Function1 & Serializable)x$1 -> Result.healthy((ComponentName)RedisHealthCheck$.MODULE$.redisComponent())).switchIfEmpty(SMono$.MODULE$.just((Object)Result.degraded((ComponentName)RedisHealthCheck$.MODULE$.redisComponent(), (String)"Can not write to Redis."))).onErrorResume((Function1 & Serializable)x$2 -> SMono$.MODULE$.just((Object)Result.degraded((ComponentName)RedisHealthCheck$.MODULE$.redisComponent(), (String)"Can not connect to Redis.")));
    }

    @Inject
    public RedisHealthCheck(RedisClientFactory redisClientFactory, RedisConfiguration redisConfiguration) {
        RedisReactiveCommands redisReactiveCommands;
        this.rawRedisClient = redisClientFactory.rawRedisClient();
        RedisConfiguration redisConfiguration2 = redisConfiguration;
        if (redisConfiguration2 instanceof StandaloneRedisConfiguration) {
            redisReactiveCommands = ((RedisClient)this.rawRedisClient()).connect().reactive();
        } else if (redisConfiguration2 instanceof ClusterRedisConfiguration) {
            redisReactiveCommands = ((RedisClusterClient)this.rawRedisClient()).connect().reactive();
        } else if (redisConfiguration2 instanceof MasterReplicaRedisConfiguration) {
            MasterReplicaRedisConfiguration masterReplicaRedisConfiguration = (MasterReplicaRedisConfiguration)redisConfiguration2;
            redisReactiveCommands = MasterReplica.connect((RedisClient)((RedisClient)this.rawRedisClient()), (RedisCodec)StringCodec.UTF8, (Iterable)CollectionConverters$.MODULE$.SeqHasAsJava(masterReplicaRedisConfiguration.redisURI()).asJava()).reactive();
        } else if (redisConfiguration2 instanceof SentinelRedisConfiguration) {
            SentinelRedisConfiguration sentinelRedisConfiguration = (SentinelRedisConfiguration)redisConfiguration2;
            redisReactiveCommands = MasterReplica.connect((RedisClient)((RedisClient)this.rawRedisClient()), (RedisCodec)StringCodec.UTF8, (RedisURI)sentinelRedisConfiguration.redisURI()).reactive();
        } else {
            throw new MatchError((Object)redisConfiguration2);
        }
        this.redisCommand = redisReactiveCommands;
    }
}

