/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.Validator;
import org.apache.jackrabbit.vault.validation.spi.ValidatorFactory;
import org.apache.jackrabbit.vault.validation.spi.ValidatorSettings;
import org.apache.jackrabbit.vault.validation.spi.impl.OverlappingFilterValidator;
import org.jetbrains.annotations.NotNull;

public final class OverlappingFilterValidatorFactory
implements ValidatorFactory {
    public static final String ID = "jackrabbit-overlappingfilter";
    public static final String OPTION_SEVERITY_FOR_OVERLAPPING_SINGLE_NODE_PATTERNS = "severityForOverlappingSingleNodePatterns";

    @Override
    public Validator createValidator(@NotNull ValidationContext context, @NotNull ValidatorSettings settings) {
        if (context.getContainerValidationContext() == null) {
            ValidationMessageSeverity severityForOverlappingSingleNodePatterns;
            if (settings.getOptions().containsKey(OPTION_SEVERITY_FOR_OVERLAPPING_SINGLE_NODE_PATTERNS)) {
                String optionValue = settings.getOptions().get(OPTION_SEVERITY_FOR_OVERLAPPING_SINGLE_NODE_PATTERNS);
                severityForOverlappingSingleNodePatterns = ValidationMessageSeverity.valueOf(optionValue.toUpperCase());
            } else {
                severityForOverlappingSingleNodePatterns = ValidationMessageSeverity.WARN;
            }
            OverlappingFilterValidator validator = new OverlappingFilterValidator(settings.getDefaultSeverity(), severityForOverlappingSingleNodePatterns);
            context.setAttribute("overlappingValidator", validator);
            validator.addFilter(context.getFilter(), OverlappingFilterValidatorFactory.getRelativePath(context.getPackageRootPath()));
            return validator;
        }
        OverlappingFilterValidator validator = (OverlappingFilterValidator)OverlappingFilterValidatorFactory.getRootContainerContext(context).getAttribute("overlappingValidator");
        validator.addFilter(context.getFilter(), OverlappingFilterValidatorFactory.getRelativePath(context.getPackageRootPath()));
        return null;
    }

    private static String getRelativePath(Path path) {
        Path workingDirectory = Paths.get("", new String[0]).toAbsolutePath();
        return workingDirectory.relativize(path).toString();
    }

    private static ValidationContext getRootContainerContext(ValidationContext context) {
        ValidationContext rootContext = context;
        while (rootContext.getContainerValidationContext() != null) {
            rootContext = rootContext.getContainerValidationContext();
        }
        return rootContext;
    }

    @Override
    public boolean shouldValidateSubpackages() {
        return true;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    public int getServiceRanking() {
        return 0;
    }
}

