/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBVersionGCSupport
extends VersionGCSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RDBVersionGCSupport.class);
    private RDBDocumentStore store;

    public RDBVersionGCSupport(RDBDocumentStore store) {
        super(store);
        this.store = store;
    }

    @Override
    public Iterable<NodeDocument> getPossiblyDeletedDocs(long fromModified, long toModified) {
        ArrayList<RDBDocumentStore.QueryCondition> conditions = new ArrayList<RDBDocumentStore.QueryCondition>();
        conditions.add(new RDBDocumentStore.QueryCondition("_deletedOnce", "=", 1L));
        conditions.add(new RDBDocumentStore.QueryCondition("_modified", "<", NodeDocument.getModifiedInSecs(toModified)));
        conditions.add(new RDBDocumentStore.QueryCondition("_modified", ">=", NodeDocument.getModifiedInSecs(fromModified)));
        return this.store.queryAsIterable(Collection.NODES, null, null, RDBDocumentStore.EMPTY_KEY_PATTERN, conditions, Integer.MAX_VALUE, null);
    }

    @Override
    protected Iterable<NodeDocument> identifyGarbage(final Set<NodeDocument.SplitDocType> gcTypes, final RevisionVector sweepRevs, final long oldestRevTimeStamp) {
        String name2;
        Iterable<Object> it2;
        Iterable<NodeDocument> it1;
        String name1;
        List<String> excludeKeyPatterns = Arrays.asList("_:/%", "__:/%", "___:/%");
        try {
            ArrayList gcTypeCodes = Lists.newArrayList();
            for (NodeDocument.SplitDocType type : gcTypes) {
                gcTypeCodes.add(type.typeCode());
            }
            ArrayList<RDBDocumentStore.QueryCondition> conditions1 = new ArrayList<RDBDocumentStore.QueryCondition>();
            conditions1.add(new RDBDocumentStore.QueryCondition("_sdType", "in", gcTypeCodes));
            conditions1.add(new RDBDocumentStore.QueryCondition("_sdMaxRevTime", "<=", NodeDocument.getModifiedInSecs(oldestRevTimeStamp)));
            conditions1.add(new RDBDocumentStore.QueryCondition(RDBDocumentStore.VERSIONPROP, ">=", 2L));
            name1 = "version 2 query";
            it1 = this.store.queryAsIterable(Collection.NODES, null, null, Collections.emptyList(), conditions1, Integer.MAX_VALUE, null);
            ArrayList<RDBDocumentStore.QueryCondition> conditions2 = new ArrayList<RDBDocumentStore.QueryCondition>();
            conditions2.add(new RDBDocumentStore.QueryCondition(RDBDocumentStore.VERSIONPROP, "null or <", 2L));
            it2 = this.store.queryAsIterable(Collection.NODES, null, null, excludeKeyPatterns, conditions2, Integer.MAX_VALUE, null);
            name2 = "version <2 fallback on " + excludeKeyPatterns;
        }
        catch (RDBDocumentStore.UnsupportedIndexedPropertyException ex) {
            it1 = this.store.queryAsIterable(Collection.NODES, null, null, excludeKeyPatterns, Collections.emptyList(), Integer.MAX_VALUE, null);
            it2 = Collections.emptySet();
            name1 = "version <2 fallback on " + excludeKeyPatterns;
            name2 = "";
        }
        final Iterable<NodeDocument> fit1 = it1;
        final Set fit2 = it2;
        Predicate<NodeDocument> pred = new Predicate<NodeDocument>(){

            public boolean apply(NodeDocument doc) {
                return gcTypes.contains((Object)doc.getSplitDocType()) && doc.hasAllRevisionLessThan(oldestRevTimeStamp) && !RDBVersionGCSupport.isDefaultNoBranchSplitNewerThan(doc, sweepRevs);
            }
        };
        final CountingPredicate<NodeDocument> cp1 = new CountingPredicate<NodeDocument>(name1, pred);
        final CountingPredicate<NodeDocument> cp2 = new CountingPredicate<NodeDocument>(name2, pred);
        return CloseableIterable.wrap(Iterables.concat((Iterable)Iterables.filter(fit1, cp1), (Iterable)Iterables.filter(fit2, cp2)), new Closeable(){

            @Override
            public void close() throws IOException {
                Utils.closeIfCloseable(fit1);
                Utils.closeIfCloseable(fit2);
                if (LOG.isDebugEnabled()) {
                    String stats1 = cp1.getStats();
                    String stats2 = cp2.getStats();
                    String message = "";
                    if (!stats1.isEmpty()) {
                        message = stats1;
                    }
                    if (!stats2.isEmpty()) {
                        if (!message.isEmpty()) {
                            message = message + ", ";
                        }
                        message = message + stats2;
                    }
                    if (!message.isEmpty()) {
                        LOG.debug(message);
                    }
                }
            }
        });
    }

    @Override
    public long getOldestDeletedOnceTimestamp(Clock clock, long precisionMs) {
        long modifiedMs = Long.MIN_VALUE;
        LOG.debug("getOldestDeletedOnceTimestamp() <- start");
        try {
            modifiedMs = this.store.getMinValue(Collection.NODES, "_modified", null, null, RDBDocumentStore.EMPTY_KEY_PATTERN, Collections.singletonList(new RDBDocumentStore.QueryCondition("_deletedOnce", "=", 1L)));
        }
        catch (DocumentStoreException ex) {
            LOG.debug("getMinValue(MODIFIED)", (Throwable)ex);
        }
        if (modifiedMs > 0L) {
            LOG.debug("getOldestDeletedOnceTimestamp() -> {}", (Object)Utils.timestampToString(modifiedMs));
            return modifiedMs;
        }
        LOG.debug("getOldestDeletedOnceTimestamp() -> none found, return current time");
        return clock.getTime();
    }

    @Override
    public long getDeletedOnceCount() {
        return this.store.queryCount(Collection.NODES, null, null, RDBDocumentStore.EMPTY_KEY_PATTERN, Collections.singletonList(new RDBDocumentStore.QueryCondition("_deletedOnce", "=", 1L)));
    }

    private static class CountingPredicate<T>
    implements Predicate<T> {
        private final String name;
        private final Predicate<T> predicate;
        private int count;
        private int matches;

        public CountingPredicate(String name, Predicate<T> predicate) {
            this.name = name;
            this.predicate = predicate;
        }

        public String getStats() {
            return this.count == 0 ? "" : "Predicate statistics for '" + this.name + "': " + this.matches + "/" + this.count;
        }

        public boolean apply(T doc) {
            ++this.count;
            boolean match = this.predicate.apply(doc);
            this.matches += match ? 1 : 0;
            return match;
        }
    }
}

