/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache.async;

import com.google.common.collect.Iterables;
import java.util.Map;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheAction;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheWriteQueue;

class InvalidateCacheAction<K extends CacheValue, V extends CacheValue>
implements CacheAction {
    private final PersistentCache cache;
    private final Map<K, V> map;
    private final Iterable<K> keys;
    private int memory = 0;

    InvalidateCacheAction(Iterable<K> keys, CacheWriteQueue<K, V> queue) {
        this.keys = keys;
        this.cache = queue.getCache();
        this.map = queue.getMap();
    }

    @Override
    public void execute() {
        if (this.map != null) {
            for (CacheValue key : this.keys) {
                this.cache.switchGenerationIfNeeded();
                this.map.remove(key);
            }
        }
    }

    @Override
    public int getMemory() {
        long m = this.memory;
        if (m == 0L) {
            for (CacheValue key : this.keys) {
                m += (long)key.getMemory();
            }
            m = Math.min(Integer.MAX_VALUE, m);
            this.memory = (int)m;
        }
        return (int)m;
    }

    public String toString() {
        return "InvalidateCacheAction" + Iterables.toString(this.keys);
    }
}

