/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public class CountingDiff
implements NodeStateDiff {
    private int changes = 0;

    public static int countChanges(NodeState before, NodeState after) {
        CountingDiff counter = new CountingDiff();
        after.compareAgainstBaseState(before, (NodeStateDiff)counter);
        return counter.getNumChanges();
    }

    public boolean propertyAdded(PropertyState after) {
        this.inc();
        return true;
    }

    public boolean propertyChanged(PropertyState before, PropertyState after) {
        this.inc();
        return true;
    }

    public boolean propertyDeleted(PropertyState before) {
        this.inc();
        return true;
    }

    public boolean childNodeAdded(String name, NodeState after) {
        this.inc();
        return after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, (NodeStateDiff)this);
    }

    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        this.inc();
        return after.compareAgainstBaseState(before, (NodeStateDiff)this);
    }

    public boolean childNodeDeleted(String name, NodeState before) {
        this.inc();
        return EmptyNodeState.MISSING_NODE.compareAgainstBaseState(before, (NodeStateDiff)this);
    }

    public int getNumChanges() {
        return this.changes;
    }

    private void inc() {
        ++this.changes;
    }
}

