/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache.async;

import java.util.Map;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheAction;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheWriteQueue;

class PutToCacheAction<K, V>
implements CacheAction<K, V> {
    private final PersistentCache cache;
    private final Map<K, V> map;
    private final K key;
    private final V value;

    PutToCacheAction(K key, V value, CacheWriteQueue<K, V> queue) {
        this.key = key;
        this.value = value;
        this.cache = queue.getCache();
        this.map = queue.getMap();
    }

    @Override
    public void execute() {
        if (this.map != null) {
            this.cache.switchGenerationIfNeeded();
            this.map.put(this.key, this.value);
        }
    }

    public String toString() {
        return "PutToCacheAction[" + this.key + ']';
    }
}

