/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache.async;

import com.google.common.collect.Iterables;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheAction;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheWriteQueue;

class InvalidateCacheAction<K, V>
implements CacheAction<K, V> {
    private final PersistentCache cache;
    private final Map<K, V> map;
    private final Iterable<K> keys;

    InvalidateCacheAction(Iterable<K> keys, CacheWriteQueue<K, V> queue) {
        this.keys = keys;
        this.cache = queue.getCache();
        this.map = queue.getMap();
    }

    @Override
    public void execute() {
        if (this.map != null) {
            for (K key : this.keys) {
                this.cache.switchGenerationIfNeeded();
                this.map.remove(key);
            }
        }
    }

    public String toString() {
        return "InvalidateCacheAction" + Iterables.toString(this.keys);
    }
}

