/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheMap;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.MultiGenerationMap;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.spi.blob.BlobOptions;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.StreamStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobCache
implements GarbageCollectableBlobStore,
PersistentCache.GenerationCache,
Closeable {
    static final Logger LOG = LoggerFactory.getLogger(BlobCache.class);
    private final GarbageCollectableBlobStore base;
    private final PersistentCache cache;
    private final MultiGenerationMap<String, byte[]> meta;
    private MultiGenerationMap<Long, byte[]> data;
    private StreamStore streamStore;
    private long maxEntrySize;

    public BlobCache(PersistentCache cache, GarbageCollectableBlobStore base) {
        this.cache = cache;
        this.base = base;
        this.data = new MultiGenerationMap();
        this.meta = new MultiGenerationMap();
        this.maxEntrySize = cache.getMaxBinaryEntrySize();
    }

    @Override
    public CacheType getType() {
        return CacheType.BLOB;
    }

    @Override
    public void addGeneration(int generation, boolean readOnly) {
        CacheMap d = this.cache.openMap(generation, "data", new MVMap.Builder());
        this.data.addReadMap(generation, d);
        CacheMap m = this.cache.openMap(generation, "meta", new MVMap.Builder());
        this.meta.addReadMap(generation, m);
        if (!readOnly) {
            this.meta.setWriteMap(m);
            this.data.setWriteMap(d);
        }
        if (this.streamStore == null) {
            this.streamStore = new StreamStore(this.data);
        }
    }

    @Override
    public void removeGeneration(int generation) {
        this.data.removeReadMap(generation);
        this.meta.removeReadMap(generation);
    }

    public InputStream getInputStream(String blobId) throws IOException {
        if (this.streamStore == null) {
            return this.base.getInputStream(blobId);
        }
        this.cache.switchGenerationIfNeeded();
        byte[] id = this.meta.get(blobId);
        if (id == null) {
            long length = this.base.getBlobLength(blobId);
            InputStream in = this.base.getInputStream(blobId);
            if (length < this.base.getBlockSizeMin()) {
                return in;
            }
            if (length > this.maxEntrySize) {
                return in;
            }
            id = this.streamStore.put(in);
            in.close();
            this.meta.put(blobId, id);
        }
        return this.streamStore.get(id);
    }

    public String writeBlob(InputStream in) throws IOException {
        return this.base.writeBlob(in);
    }

    public String writeBlob(InputStream in, BlobOptions options) throws IOException {
        return this.writeBlob(in);
    }

    public int readBlob(String blobId, long pos, byte[] buff, int off, int length) throws IOException {
        InputStream in = this.getInputStream(blobId);
        for (long remainingSkip = pos; remainingSkip > 0L; remainingSkip -= in.skip(remainingSkip)) {
        }
        return in.read(buff, off, length);
    }

    public long getBlobLength(String blobId) throws IOException {
        return this.base.getBlobLength(blobId);
    }

    @CheckForNull
    public String getBlobId(@Nonnull String reference) {
        return this.base.getBlobId(reference);
    }

    @CheckForNull
    public String getReference(@Nonnull String blobId) {
        return this.base.getReference(blobId);
    }

    public void clearCache() {
        this.base.clearCache();
    }

    public void clearInUse() {
        this.base.clearInUse();
    }

    @Deprecated
    public boolean deleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        return this.base.deleteChunks(chunkIds, maxLastModifiedTime);
    }

    public long countDeleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        return this.base.countDeleteChunks(chunkIds, maxLastModifiedTime);
    }

    public Iterator<String> getAllChunkIds(long maxLastModifiedTime) throws Exception {
        return this.base.getAllChunkIds(maxLastModifiedTime);
    }

    public long getBlockSizeMin() {
        return this.base.getBlockSizeMin();
    }

    public Iterator<String> resolveChunks(String blobId) throws IOException {
        return this.base.resolveChunks(blobId);
    }

    public void setBlockSize(int x) {
        this.base.setBlockSize(x);
    }

    public void startMark() throws IOException {
        this.base.startMark();
    }

    public int sweep() throws IOException {
        return this.base.sweep();
    }

    public String writeBlob(String tempFileName) throws IOException {
        return this.base.writeBlob(tempFileName);
    }

    @Override
    public void receive(ByteBuffer buff) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this.base instanceof Closeable) {
            ((Closeable)this.base).close();
        }
    }
}

