/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.Atomics;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.commons.TimeDurationFormatter;
import org.apache.jackrabbit.oak.commons.sort.StringSort;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.NodeDocumentIdComparator;
import org.apache.jackrabbit.oak.plugins.document.Range;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionGCStats;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.VersionGCOptions;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.util.TimeInterval;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.gc.DelegatingGCMonitor;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class VersionGarbageCollector {
    private static final int DELETE_BATCH_SIZE = 450;
    private static final int UPDATE_BATCH_SIZE = 450;
    private static final int PROGRESS_BATCH_SIZE = 10000;
    private static final String STATUS_IDLE = "IDLE";
    private static final String STATUS_INITIALIZING = "INITIALIZING";
    private static final Logger log = LoggerFactory.getLogger(VersionGarbageCollector.class);
    private static final Set<NodeDocument.SplitDocType> GC_TYPES = EnumSet.of(NodeDocument.SplitDocType.DEFAULT_LEAF, NodeDocument.SplitDocType.COMMIT_ROOT_ONLY, NodeDocument.SplitDocType.DEFAULT_NO_BRANCH);
    private static final String SETTINGS_COLLECTION_ID = "versionGC";
    private static final String SETTINGS_COLLECTION_OLDEST_TIMESTAMP_PROP = "lastOldestTimeStamp";
    private static final String SETTINGS_COLLECTION_REC_INTERVAL_PROP = "recommendedIntervalMs";
    private final DocumentNodeStore nodeStore;
    private final DocumentStore ds;
    private final VersionGCSupport versionStore;
    private final AtomicReference<GCJob> collector = Atomics.newReference();
    private VersionGCOptions options;
    private GCMonitor gcMonitor = GCMonitor.EMPTY;
    private RevisionGCStats gcStats = new RevisionGCStats(StatisticsProvider.NOOP);
    private static final Predicate<Range> FIRST_LEVEL = new Predicate<Range>(){

        public boolean apply(@Nullable Range input) {
            return input != null && input.height == 0;
        }
    };

    VersionGarbageCollector(DocumentNodeStore nodeStore, VersionGCSupport gcSupport) {
        this.nodeStore = nodeStore;
        this.versionStore = gcSupport;
        this.ds = gcSupport.getDocumentStore();
        this.options = new VersionGCOptions();
    }

    void setStatisticsProvider(StatisticsProvider provider) {
        this.gcStats = new RevisionGCStats(provider);
    }

    @Nonnull
    RevisionGCStats getRevisionGCStats() {
        return this.gcStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionGCStats gc(long maxRevisionAge, TimeUnit unit) throws IOException {
        GCJob job;
        long maxRevisionAgeInMillis = unit.toMillis(maxRevisionAge);
        TimeInterval maxRunTime = new TimeInterval(this.nodeStore.getClock().getTime(), Long.MAX_VALUE);
        if (this.options.maxDurationMs > 0L) {
            maxRunTime = maxRunTime.startAndDuration(this.options.maxDurationMs);
        }
        if (this.collector.compareAndSet(null, job = new GCJob(maxRevisionAgeInMillis, this.options, this.gcMonitor))) {
            VersionGCStats versionGCStats;
            VersionGCStats overall = new VersionGCStats();
            overall.active.start();
            try {
                long averageDurationMs = 0L;
                while (maxRunTime.contains(this.nodeStore.getClock().getTime() + averageDurationMs)) {
                    this.gcMonitor.info("Start {}. run (avg duration {} sec)", new Object[]{overall.iterationCount + 1, (double)averageDurationMs / 1000.0});
                    VersionGCStats stats = job.run();
                    overall.addRun(stats);
                    if (this.options.maxIterations > 0 && overall.iterationCount >= this.options.maxIterations || !overall.needRepeat) break;
                    averageDurationMs = (averageDurationMs * (long)(overall.iterationCount - 1) + stats.active.elapsed(TimeUnit.MILLISECONDS)) / (long)overall.iterationCount;
                }
                this.gcStats.finished(overall);
                versionGCStats = overall;
            }
            catch (Throwable throwable) {
                overall.active.stop();
                this.collector.set(null);
                if (overall.iterationCount > 1) {
                    this.gcMonitor.info("Revision garbage collection finished after {} iterations - aggregate statistics: {}", new Object[]{overall.iterationCount, overall});
                }
                throw throwable;
            }
            overall.active.stop();
            this.collector.set(null);
            if (overall.iterationCount > 1) {
                this.gcMonitor.info("Revision garbage collection finished after {} iterations - aggregate statistics: {}", new Object[]{overall.iterationCount, overall});
            }
            return versionGCStats;
        }
        throw new IOException("Revision garbage collection is already running");
    }

    public void cancel() {
        GCJob job = this.collector.get();
        if (job != null) {
            job.cancel();
        }
    }

    public String getStatus() {
        GCJob job = this.collector.get();
        if (job == null) {
            return STATUS_IDLE;
        }
        return job.getStatus();
    }

    public void setGCMonitor(@Nonnull GCMonitor gcMonitor) {
        this.gcMonitor = (GCMonitor)Preconditions.checkNotNull((Object)gcMonitor);
    }

    public VersionGCOptions getOptions() {
        return this.options;
    }

    public void setOptions(VersionGCOptions options) {
        this.options = options;
    }

    public void reset() {
        this.ds.remove(Collection.SETTINGS, SETTINGS_COLLECTION_ID);
    }

    public VersionGCInfo getInfo(long maxRevisionAge, TimeUnit unit) throws IOException {
        long maxRevisionAgeInMillis = unit.toMillis(maxRevisionAge);
        long now = this.nodeStore.getClock().getTime();
        Recommendations rec = new Recommendations(maxRevisionAgeInMillis, this.options);
        int estimatedIterations = -1;
        if (rec.suggestedIntervalMs > 0L) {
            estimatedIterations = (int)Math.ceil((now - rec.scope.toMs) / rec.suggestedIntervalMs);
        }
        return new VersionGCInfo(rec.lastOldestTimestamp, rec.scope.fromMs, rec.deleteCandidateCount, rec.maxCollect, rec.suggestedIntervalMs, rec.scope.toMs, estimatedIterations);
    }

    @Nonnull
    private StringSort newStringSort(VersionGCOptions options) {
        return new StringSort(options.overflowToDiskThreshold, NodeDocumentIdComparator.INSTANCE);
    }

    private static final class LimitExceededException
    extends Exception {
        private static final long serialVersionUID = 6578586397629516408L;

        private LimitExceededException() {
        }
    }

    private static class GCMessageTracker
    extends GCMonitor.Empty
    implements Supplier<String> {
        private volatile String lastMessage = "INITIALIZING";

        private GCMessageTracker() {
        }

        public void info(String message, Object ... arguments) {
            this.lastMessage = MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage();
        }

        public void warn(String message, Object ... arguments) {
            this.lastMessage = MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage();
        }

        public void error(String message, Exception e) {
            this.lastMessage = message + " (" + e.getMessage() + ")";
        }

        public String get() {
            return this.lastMessage;
        }
    }

    private class Recommendations {
        final boolean ignoreDueToCheckPoint;
        final TimeInterval scope;
        final long maxCollect;
        final long deleteCandidateCount;
        final long lastOldestTimestamp;
        private final long precisionMs;
        private final long suggestedIntervalMs;
        private final boolean scopeIsComplete;

        Recommendations(long maxRevisionAgeMs, VersionGCOptions options) {
            Revision checkpoint;
            long oldestPossible;
            TimeInterval keep = new TimeInterval(VersionGarbageCollector.this.nodeStore.getClock().getTime() - maxRevisionAgeMs, Long.MAX_VALUE);
            boolean ignoreDueToCheckPoint = false;
            long deletedOnceCount = 0L;
            long collectLimit = options.collectLimit;
            Map<String, Long> settings = this.getLongSettings();
            this.lastOldestTimestamp = settings.get(VersionGarbageCollector.SETTINGS_COLLECTION_OLDEST_TIMESTAMP_PROP);
            if (this.lastOldestTimestamp == 0L) {
                log.debug("No lastOldestTimestamp found, querying for the oldest deletedOnce candidate");
                oldestPossible = VersionGarbageCollector.this.versionStore.getOldestDeletedOnceTimestamp(VersionGarbageCollector.this.nodeStore.getClock(), options.precisionMs) - 1L;
                log.debug("lastOldestTimestamp found: {}", (Object)Utils.timestampToString(oldestPossible));
            } else {
                oldestPossible = this.lastOldestTimestamp - 1L;
            }
            TimeInterval scope = new TimeInterval(oldestPossible, Long.MAX_VALUE);
            scope = scope.notLaterThan(keep.fromMs);
            long suggestedIntervalMs = settings.get(VersionGarbageCollector.SETTINGS_COLLECTION_REC_INTERVAL_PROP);
            if (suggestedIntervalMs > 0L) {
                if ((suggestedIntervalMs = Math.max(suggestedIntervalMs, options.precisionMs)) < scope.getDurationMs()) {
                    scope = scope.startAndDuration(suggestedIntervalMs);
                    log.debug("previous runs recommend a {} sec duration, scope now {}", (Object)TimeUnit.MILLISECONDS.toSeconds(suggestedIntervalMs), (Object)scope);
                }
            } else {
                try {
                    long preferredLimit = Math.min(collectLimit, (long)Math.ceil((double)options.overflowToDiskThreshold * 0.95));
                    deletedOnceCount = VersionGarbageCollector.this.versionStore.getDeletedOnceCount();
                    if (deletedOnceCount > preferredLimit) {
                        double chunks = (double)deletedOnceCount / (double)preferredLimit;
                        suggestedIntervalMs = (long)Math.floor((double)(scope.getDurationMs() + maxRevisionAgeMs) / chunks);
                        if (suggestedIntervalMs < scope.getDurationMs()) {
                            scope = scope.startAndDuration(suggestedIntervalMs);
                            log.debug("deletedOnce candidates: {} found, {} preferred, scope now {}", new Object[]{deletedOnceCount, preferredLimit, scope});
                        }
                    }
                }
                catch (UnsupportedOperationException ex) {
                    log.debug("check on upper bounds of delete candidates not supported, skipped");
                }
            }
            if ((checkpoint = VersionGarbageCollector.this.nodeStore.getCheckpoints().getOldestRevisionToKeep()) != null && scope.endsAfter(checkpoint.getTimestamp())) {
                TimeInterval minimalScope = scope.startAndDuration(options.precisionMs);
                if (minimalScope.endsAfter(checkpoint.getTimestamp())) {
                    log.warn("Ignoring RGC run because a valid checkpoint [{}] exists inside minimal scope {}.", (Object)checkpoint.toReadableString(), (Object)minimalScope);
                    ignoreDueToCheckPoint = true;
                } else {
                    scope = scope.notLaterThan(checkpoint.getTimestamp() - 1L);
                    log.debug("checkpoint at [{}] found, scope now {}", (Object)Utils.timestampToString(checkpoint.getTimestamp()), (Object)scope);
                }
            }
            if (scope.getDurationMs() <= options.precisionMs) {
                collectLimit = 0L;
                log.debug("time interval <= precision ({} ms), disabling collection limits", (Object)options.precisionMs);
            }
            this.precisionMs = options.precisionMs;
            this.ignoreDueToCheckPoint = ignoreDueToCheckPoint;
            this.scope = scope;
            this.scopeIsComplete = scope.toMs >= keep.fromMs;
            this.maxCollect = collectLimit;
            this.suggestedIntervalMs = suggestedIntervalMs;
            this.deleteCandidateCount = deletedOnceCount;
        }

        public void evaluate(VersionGCStats stats) {
            if (stats.limitExceeded) {
                long nextDuration = Math.max(this.precisionMs, this.scope.getDurationMs() / 2L);
                VersionGarbageCollector.this.gcMonitor.info("Limit {} documents exceeded, reducing next collection interval to {} seconds", new Object[]{this.maxCollect, TimeUnit.MILLISECONDS.toSeconds(nextDuration)});
                this.setLongSetting(VersionGarbageCollector.SETTINGS_COLLECTION_REC_INTERVAL_PROP, nextDuration);
                stats.needRepeat = true;
            } else if (!stats.canceled && !stats.ignoredGCDueToCheckPoint) {
                this.setLongSetting(VersionGarbageCollector.SETTINGS_COLLECTION_OLDEST_TIMESTAMP_PROP, this.scope.toMs);
                if (this.maxCollect <= 0L) {
                    log.debug("successful run without effective limit, keeping recommendations");
                } else if (this.scope.getDurationMs() == this.suggestedIntervalMs) {
                    int count = stats.deletedDocGCCount - stats.deletedLeafDocGCCount;
                    double used = (double)count / (double)this.maxCollect;
                    if (used < 0.66) {
                        long nextDuration = (long)Math.ceil((double)this.suggestedIntervalMs * 1.5);
                        log.debug("successful run using {}% of limit, raising recommended interval to {} seconds", (Object)((double)Math.round(used * 1000.0) / 10.0), (Object)TimeUnit.MILLISECONDS.toSeconds(nextDuration));
                        this.setLongSetting(VersionGarbageCollector.SETTINGS_COLLECTION_REC_INTERVAL_PROP, nextDuration);
                    }
                } else {
                    log.debug("successful run not following recommendations, keeping them");
                }
                stats.needRepeat = !this.scopeIsComplete;
            }
        }

        private Map<String, Long> getLongSettings() {
            Document versionGCDoc = VersionGarbageCollector.this.ds.find(Collection.SETTINGS, VersionGarbageCollector.SETTINGS_COLLECTION_ID, 0);
            HashMap settings = Maps.newHashMap();
            settings.put(VersionGarbageCollector.SETTINGS_COLLECTION_OLDEST_TIMESTAMP_PROP, 0L);
            settings.put(VersionGarbageCollector.SETTINGS_COLLECTION_REC_INTERVAL_PROP, 0L);
            if (versionGCDoc != null) {
                for (String k : versionGCDoc.keySet()) {
                    Object value = versionGCDoc.get(k);
                    if (!(value instanceof Number)) continue;
                    settings.put(k, ((Number)value).longValue());
                }
            }
            return settings;
        }

        private void setLongSetting(String propName, long val) {
            UpdateOp updateOp = new UpdateOp(VersionGarbageCollector.SETTINGS_COLLECTION_ID, true);
            updateOp.set(propName, val);
            VersionGarbageCollector.this.ds.createOrUpdate(Collection.SETTINGS, updateOp);
        }
    }

    private class DeletedDocsGC
    implements Closeable {
        private final RevisionVector headRevision;
        private final AtomicBoolean cancel;
        private final List<String> leafDocIdsToDelete = Lists.newArrayList();
        private final List<String> resurrectedIds = Lists.newArrayList();
        private final StringSort docIdsToDelete;
        private final StringSort prevDocIdsToDelete;
        private final Set<String> exclude = Sets.newHashSet();
        private boolean sorted = false;
        private final Stopwatch timer;
        private final VersionGCOptions options;
        private final GCMonitor monitor;

        public DeletedDocsGC(@Nonnull RevisionVector headRevision, @Nonnull AtomicBoolean cancel, @Nonnull VersionGCOptions options, GCMonitor monitor) {
            this.headRevision = (RevisionVector)Preconditions.checkNotNull((Object)headRevision);
            this.cancel = (AtomicBoolean)Preconditions.checkNotNull((Object)cancel);
            this.timer = Stopwatch.createUnstarted();
            this.options = options;
            this.monitor = monitor;
            this.docIdsToDelete = VersionGarbageCollector.this.newStringSort(options);
            this.prevDocIdsToDelete = VersionGarbageCollector.this.newStringSort(options);
        }

        long getNumDocuments() {
            return this.docIdsToDelete.getSize() + (long)this.leafDocIdsToDelete.size();
        }

        boolean possiblyDeleted(NodeDocument doc) throws IOException {
            VersionGarbageCollector.this.gcStats.documentRead();
            String id = doc.getId() + "/" + doc.getModified();
            try {
                Utils.getDepthFromId(id);
            }
            catch (IllegalArgumentException e) {
                this.monitor.warn("Invalid GC id {} for document {}", new Object[]{id, doc});
                return false;
            }
            if (doc.getNodeAtRevision(VersionGarbageCollector.this.nodeStore, this.headRevision, null) == null) {
                Iterator<String> previousDocs = this.previousDocIdsFor(doc);
                if (!doc.hasChildren() && !previousDocs.hasNext()) {
                    this.addLeafDocument(id);
                } else {
                    this.addDocument(id);
                    this.addPreviousDocuments(previousDocs);
                }
                return true;
            }
            this.addNonDeletedDocument(id);
            return false;
        }

        void removeDocuments(VersionGCStats stats) throws IOException {
            this.removeLeafDocuments(stats);
            stats.deletedDocGCCount += this.removeDeletedDocuments(this.getDocIdsToDelete(), this.getDocIdsToDeleteSize(), false, "(other)");
            stats.splitDocGCCount += this.removeDeletedPreviousDocuments();
        }

        boolean hasLeafBatch() {
            return this.leafDocIdsToDelete.size() >= 450;
        }

        boolean hasRescurrectUpdateBatch() {
            return this.resurrectedIds.size() >= 450;
        }

        void removeLeafDocuments(VersionGCStats stats) throws IOException {
            int removeCount = this.removeDeletedDocuments(this.getLeafDocIdsToDelete(), this.getLeafDocIdsToDeleteSize(), true, "(leaf)");
            this.leafDocIdsToDelete.clear();
            stats.deletedLeafDocGCCount += removeCount;
            stats.deletedDocGCCount += removeCount;
        }

        void updateResurrectedDocuments(VersionGCStats stats) throws IOException {
            if (this.resurrectedIds.isEmpty()) {
                return;
            }
            int updateCount = this.resetDeletedOnce(this.resurrectedIds);
            this.resurrectedIds.clear();
            stats.updateResurrectedGCCount += updateCount;
        }

        @Override
        public void close() {
            try {
                this.docIdsToDelete.close();
            }
            catch (IOException e) {
                this.monitor.warn("Failed to close docIdsToDelete: {}", new Object[]{e});
            }
            try {
                this.prevDocIdsToDelete.close();
            }
            catch (IOException e) {
                this.monitor.warn("Failed to close prevDocIdsToDelete: {}", new Object[]{e});
            }
        }

        private void delayOnModifications(long durationMs) {
            long delayMs = Math.round((double)durationMs * this.options.delayFactor);
            if (!this.cancel.get() && delayMs > 0L) {
                try {
                    Clock clock = VersionGarbageCollector.this.nodeStore.getClock();
                    clock.waitUntil(clock.getTime() + delayMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private Iterator<String> previousDocIdsFor(NodeDocument doc) {
            NavigableMap<Revision, Range> prevRanges = doc.getPreviousRanges(true);
            if (prevRanges.isEmpty()) {
                return Collections.emptyIterator();
            }
            if (Iterables.all(prevRanges.values(), (Predicate)FIRST_LEVEL)) {
                final String path = doc.getPath();
                return Iterators.transform(prevRanges.entrySet().iterator(), (Function)new Function<Map.Entry<Revision, Range>, String>(){

                    public String apply(Map.Entry<Revision, Range> input) {
                        int h = input.getValue().getHeight();
                        return Utils.getPreviousIdFor(path, input.getKey(), h);
                    }
                });
            }
            return Iterators.transform(doc.getAllPreviousDocs(), (Function)new Function<NodeDocument, String>(){

                public String apply(NodeDocument input) {
                    return input.getId();
                }
            });
        }

        private void addDocument(String id) throws IOException {
            this.docIdsToDelete.add(id);
        }

        private void addLeafDocument(String id) throws IOException {
            this.leafDocIdsToDelete.add(id);
        }

        private void addNonDeletedDocument(String id) throws IOException {
            this.resurrectedIds.add(id);
        }

        private long getNumPreviousDocuments() {
            return this.prevDocIdsToDelete.getSize() - (long)this.exclude.size();
        }

        private void addPreviousDocuments(Iterator<String> ids) throws IOException {
            while (ids.hasNext()) {
                this.prevDocIdsToDelete.add(ids.next());
            }
        }

        private Iterator<String> getDocIdsToDelete() throws IOException {
            this.ensureSorted();
            return this.docIdsToDelete.getIds();
        }

        private long getDocIdsToDeleteSize() {
            return this.docIdsToDelete.getSize();
        }

        private Iterator<String> getLeafDocIdsToDelete() throws IOException {
            return this.leafDocIdsToDelete.iterator();
        }

        private long getLeafDocIdsToDeleteSize() {
            return this.leafDocIdsToDelete.size();
        }

        private void concurrentModification(NodeDocument doc) {
            Iterator<NodeDocument> it = doc.getAllPreviousDocs();
            while (it.hasNext()) {
                this.exclude.add(it.next().getId());
            }
        }

        private Iterator<String> getPrevDocIdsToDelete() throws IOException {
            this.ensureSorted();
            return Iterators.filter((Iterator)this.prevDocIdsToDelete.getIds(), (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return !DeletedDocsGC.this.exclude.contains(input);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int removeDeletedDocuments(Iterator<String> docIdsToDelete, long numDocuments, boolean leaves, String label) throws IOException {
            if (numDocuments == 0L) {
                return 0;
            }
            this.monitor.info("Proceeding to delete [{}] documents [{}]", new Object[]{numDocuments, label});
            UnmodifiableIterator idListItr = Iterators.partition(docIdsToDelete, (int)450);
            int deletedCount = 0;
            int lastLoggedCount = 0;
            int recreatedCount = 0;
            while (idListItr.hasNext() && !this.cancel.get()) {
                LinkedHashMap deletionBatch = Maps.newLinkedHashMap();
                for (String s : (List)idListItr.next()) {
                    Map.Entry<String, Long> parsed;
                    try {
                        parsed = this.parseEntry(s);
                    }
                    catch (IllegalArgumentException e) {
                        this.monitor.warn("Invalid _modified suffix for {}", new Object[]{s});
                        continue;
                    }
                    deletionBatch.put(parsed.getKey(), parsed.getValue());
                }
                if (log.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder("Performing batch deletion of documents with following ids. \n");
                    Joiner.on((String)StandardSystemProperty.LINE_SEPARATOR.value()).appendTo(sb, deletionBatch.keySet());
                    log.trace(sb.toString());
                }
                this.timer.reset().start();
                try {
                    int nRemoved = VersionGarbageCollector.this.ds.remove(Collection.NODES, deletionBatch);
                    if (nRemoved < deletionBatch.size()) {
                        for (String id : deletionBatch.keySet()) {
                            NodeDocument d = VersionGarbageCollector.this.ds.find(Collection.NODES, id);
                            if (d == null) continue;
                            this.concurrentModification(d);
                        }
                        recreatedCount += deletionBatch.size() - nRemoved;
                    }
                    log.debug("Deleted [{}] documents so far", (Object)(deletedCount += nRemoved));
                    if (leaves) {
                        VersionGarbageCollector.this.gcStats.leafDocumentsDeleted(deletedCount);
                    } else {
                        VersionGarbageCollector.this.gcStats.documentsDeleted(deletedCount);
                    }
                    if (deletedCount + recreatedCount - lastLoggedCount < 10000) continue;
                    lastLoggedCount = deletedCount + recreatedCount;
                    double progress = (double)lastLoggedCount * 1.0 / (double)this.getNumDocuments() * 100.0;
                    String msg = String.format("Deleted %d (%1.2f%%) documents so far", deletedCount, progress);
                    this.monitor.info(msg, new Object[0]);
                }
                finally {
                    this.delayOnModifications(this.timer.stop().elapsed(TimeUnit.MILLISECONDS));
                }
            }
            return deletedCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int resetDeletedOnce(List<String> resurrectedDocuments) throws IOException {
            this.monitor.info("Proceeding to reset [{}] _deletedOnce flags", new Object[]{resurrectedDocuments.size()});
            int updateCount = 0;
            this.timer.reset().start();
            try {
                for (String s : resurrectedDocuments) {
                    if (this.cancel.get()) continue;
                    try {
                        Map.Entry<String, Long> parsed = this.parseEntry(s);
                        UpdateOp up = new UpdateOp(parsed.getKey(), false);
                        up.equals("_modified", parsed.getValue());
                        up.remove("_deletedOnce");
                        NodeDocument r = VersionGarbageCollector.this.ds.findAndUpdate(Collection.NODES, up);
                        if (r == null) continue;
                        ++updateCount;
                        VersionGarbageCollector.this.gcStats.deletedOnceFlagReset();
                    }
                    catch (IllegalArgumentException ex) {
                        this.monitor.warn("Invalid _modified suffix for {}", new Object[]{s});
                    }
                    catch (DocumentStoreException ex) {
                        this.monitor.warn("updating {}: {}", new Object[]{s, ex.getMessage()});
                    }
                }
            }
            finally {
                this.delayOnModifications(this.timer.stop().elapsed(TimeUnit.MILLISECONDS));
            }
            return updateCount;
        }

        private int removeDeletedPreviousDocuments() throws IOException {
            long num = this.getNumPreviousDocuments();
            if (num == 0L) {
                return 0;
            }
            this.monitor.info("Proceeding to delete [{}] previous documents", new Object[]{num});
            int deletedCount = 0;
            int lastLoggedCount = 0;
            UnmodifiableIterator idListItr = Iterators.partition(this.getPrevDocIdsToDelete(), (int)450);
            while (idListItr.hasNext() && !this.cancel.get()) {
                List deletionBatch = (List)idListItr.next();
                deletedCount += deletionBatch.size();
                if (log.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder("Performing batch deletion of previous documents with following ids. \n");
                    Joiner.on((String)StandardSystemProperty.LINE_SEPARATOR.value()).appendTo(sb, (Iterable)deletionBatch);
                    log.debug(sb.toString());
                }
                VersionGarbageCollector.this.ds.remove(Collection.NODES, deletionBatch);
                log.debug("Deleted [{}] previous documents so far", (Object)deletedCount);
                VersionGarbageCollector.this.gcStats.splitDocumentsDeleted(deletedCount);
                if (deletedCount - lastLoggedCount < 10000) continue;
                lastLoggedCount = deletedCount;
                double progress = (double)deletedCount * 1.0 / (double)(this.prevDocIdsToDelete.getSize() - (long)this.exclude.size()) * 100.0;
                String msg = String.format("Deleted %d (%1.2f%%) previous documents so far", deletedCount, progress);
                this.monitor.info(msg, new Object[0]);
            }
            return deletedCount;
        }

        private void ensureSorted() throws IOException {
            if (!this.sorted) {
                this.docIdsToDelete.sort();
                this.prevDocIdsToDelete.sort();
                this.sorted = true;
            }
        }

        private Map.Entry<String, Long> parseEntry(String entry) throws IllegalArgumentException {
            long modified;
            int idx = entry.lastIndexOf(47);
            if (idx == -1) {
                throw new IllegalArgumentException(entry);
            }
            String id = entry.substring(0, idx);
            try {
                modified = Long.parseLong(entry.substring(idx + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(entry);
            }
            return Maps.immutableEntry((Object)id, (Object)modified);
        }
    }

    private class GCJob {
        private final long maxRevisionAgeMillis;
        private final VersionGCOptions options;
        private final AtomicBoolean cancel = new AtomicBoolean();
        private final GCMonitor monitor;
        private final Supplier<String> status;

        GCJob(long maxRevisionAgeMillis, VersionGCOptions options, GCMonitor gcMonitor) {
            GCMessageTracker vgcm;
            this.maxRevisionAgeMillis = maxRevisionAgeMillis;
            this.options = options;
            this.status = vgcm = new GCMessageTracker();
            this.monitor = new DelegatingGCMonitor((java.util.Collection)Lists.newArrayList((Object[])new GCMonitor[]{vgcm, gcMonitor}));
            this.monitor.updateStatus(VersionGarbageCollector.STATUS_INITIALIZING);
        }

        VersionGCStats run() throws IOException {
            try {
                VersionGCStats versionGCStats = this.gc(this.maxRevisionAgeMillis);
                return versionGCStats;
            }
            finally {
                this.monitor.updateStatus(VersionGarbageCollector.STATUS_IDLE);
            }
        }

        void cancel() {
            this.monitor.info("Canceling revision garbage collection.", new Object[0]);
            this.cancel.set(true);
        }

        String getStatus() {
            return (String)this.status.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VersionGCStats gc(long maxRevisionAgeInMillis) throws IOException {
            VersionGCStats stats = new VersionGCStats();
            stats.active.start();
            Recommendations rec = new Recommendations(maxRevisionAgeInMillis, this.options);
            GCPhases phases = new GCPhases(this.cancel, stats, VersionGarbageCollector.this.gcMonitor);
            try {
                if (rec.ignoreDueToCheckPoint) {
                    phases.stats.ignoredGCDueToCheckPoint = true;
                    this.monitor.skipped("Checkpoint prevented revision garbage collection", new Object[0]);
                    this.cancel.set(true);
                } else {
                    RevisionVector headRevision = VersionGarbageCollector.this.nodeStore.getHeadRevision();
                    RevisionVector sweepRevisions = VersionGarbageCollector.this.nodeStore.getSweepRevisions();
                    this.monitor.info("Looking at revisions in {}", new Object[]{rec.scope});
                    this.collectDeletedDocuments(phases, headRevision, rec);
                    this.collectSplitDocuments(phases, sweepRevisions, rec);
                }
            }
            catch (LimitExceededException ex) {
                stats.limitExceeded = true;
            }
            finally {
                phases.close();
                stats.canceled = this.cancel.get();
            }
            rec.evaluate(stats);
            this.monitor.info("Revision garbage collection finished in {}. {}", new Object[]{TimeDurationFormatter.forLogging().format(phases.elapsed.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), stats});
            stats.active.stop();
            return stats;
        }

        private void collectSplitDocuments(GCPhases phases, RevisionVector sweepRevisions, Recommendations rec) {
            if (phases.start(GCPhase.SPLITS_CLEANUP)) {
                int splitDocGCCount = phases.stats.splitDocGCCount;
                int intermediateSplitDocGCCount = phases.stats.intermediateSplitDocGCCount;
                VersionGarbageCollector.this.versionStore.deleteSplitDocuments(GC_TYPES, sweepRevisions, rec.scope.toMs, phases.stats);
                VersionGarbageCollector.this.gcStats.splitDocumentsDeleted(phases.stats.splitDocGCCount - splitDocGCCount);
                VersionGarbageCollector.this.gcStats.intermediateSplitDocumentsDeleted(phases.stats.intermediateSplitDocGCCount - intermediateSplitDocGCCount);
                phases.stop(GCPhase.SPLITS_CLEANUP);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collectDeletedDocuments(GCPhases phases, RevisionVector headRevision, Recommendations rec) throws IOException, LimitExceededException {
            int docsTraversed = 0;
            try (DeletedDocsGC gc = new DeletedDocsGC(headRevision, this.cancel, this.options, this.monitor);){
                if (phases.start(GCPhase.COLLECTING)) {
                    Iterable<NodeDocument> itr = VersionGarbageCollector.this.versionStore.getPossiblyDeletedDocs(rec.scope.fromMs, rec.scope.toMs);
                    try {
                        for (NodeDocument doc : itr) {
                            if (this.cancel.get()) {
                                break;
                            }
                            if (++docsTraversed % 10000 == 0) {
                                this.monitor.info("Iterated through {} documents so far. {} found to be deleted", new Object[]{docsTraversed, gc.getNumDocuments()});
                            }
                            if (phases.start(GCPhase.CHECKING)) {
                                gc.possiblyDeleted(doc);
                                phases.stop(GCPhase.CHECKING);
                            }
                            if (rec.maxCollect > 0L && gc.docIdsToDelete.getSize() > rec.maxCollect) {
                                throw new LimitExceededException();
                            }
                            if (gc.hasLeafBatch() && phases.start(GCPhase.DELETING)) {
                                gc.removeLeafDocuments(phases.stats);
                                phases.stop(GCPhase.DELETING);
                            }
                            if (!gc.hasRescurrectUpdateBatch() || !phases.start(GCPhase.UPDATING)) continue;
                            gc.updateResurrectedDocuments(phases.stats);
                            phases.stop(GCPhase.UPDATING);
                        }
                    }
                    finally {
                        Utils.closeIfCloseable(itr);
                    }
                    phases.stop(GCPhase.COLLECTING);
                }
                if (gc.getNumDocuments() != 0L) {
                    if (phases.start(GCPhase.DELETING)) {
                        gc.removeLeafDocuments(phases.stats);
                        phases.stop(GCPhase.DELETING);
                    }
                    if (phases.start(GCPhase.SORTING)) {
                        gc.ensureSorted();
                        phases.stop(GCPhase.SORTING);
                    }
                    if (phases.start(GCPhase.DELETING)) {
                        gc.removeDocuments(phases.stats);
                        phases.stop(GCPhase.DELETING);
                    }
                }
                if (phases.start(GCPhase.UPDATING)) {
                    gc.updateResurrectedDocuments(phases.stats);
                    phases.stop(GCPhase.UPDATING);
                }
            }
        }
    }

    private static class GCPhases {
        final VersionGCStats stats;
        final Stopwatch elapsed;
        private final GCMonitor monitor;
        private final List<GCPhase> phases = Lists.newArrayList();
        private final Map<GCPhase, Stopwatch> watches = Maps.newHashMap();
        private final AtomicBoolean canceled;

        GCPhases(AtomicBoolean canceled, VersionGCStats stats, GCMonitor monitor) {
            this.stats = stats;
            this.monitor = monitor;
            this.elapsed = Stopwatch.createStarted();
            this.watches.put(GCPhase.NONE, Stopwatch.createStarted());
            this.watches.put(GCPhase.COLLECTING, stats.collectDeletedDocs);
            this.watches.put(GCPhase.CHECKING, stats.checkDeletedDocs);
            this.watches.put(GCPhase.DELETING, stats.deleteDeletedDocs);
            this.watches.put(GCPhase.SORTING, stats.sortDocIds);
            this.watches.put(GCPhase.SPLITS_CLEANUP, stats.collectAndDeleteSplitDocs);
            this.watches.put(GCPhase.UPDATING, stats.updateResurrectedDocuments);
            this.canceled = canceled;
        }

        public boolean start(GCPhase started) {
            if (this.canceled.get()) {
                return false;
            }
            this.suspend(this.currentWatch());
            this.phases.add(started);
            this.updateStatus();
            this.resume(this.currentWatch());
            return true;
        }

        public void stop(GCPhase phase) {
            if (!this.phases.isEmpty() && phase == this.phases.get(this.phases.size() - 1)) {
                this.suspend(this.currentWatch());
                this.phases.remove(this.phases.size() - 1);
                this.updateStatus();
                this.resume(this.currentWatch());
            }
        }

        public void close() {
            while (!this.phases.isEmpty()) {
                this.suspend(this.currentWatch());
                this.phases.remove(this.phases.size() - 1);
                this.updateStatus();
            }
            this.elapsed.stop();
        }

        private GCPhase current() {
            return this.phases.isEmpty() ? GCPhase.NONE : this.phases.get(this.phases.size() - 1);
        }

        private Stopwatch currentWatch() {
            return this.watches.get((Object)this.current());
        }

        private void resume(Stopwatch w) {
            if (!w.isRunning()) {
                w.start();
            }
        }

        private void suspend(Stopwatch w) {
            if (w.isRunning()) {
                w.stop();
            }
        }

        private void updateStatus() {
            GCPhase p = this.current();
            if (p != GCPhase.NONE) {
                this.monitor.updateStatus(p.name());
            }
        }
    }

    private static enum GCPhase {
        NONE,
        COLLECTING,
        CHECKING,
        DELETING,
        SORTING,
        SPLITS_CLEANUP,
        UPDATING;

    }

    public static class VersionGCStats {
        boolean ignoredGCDueToCheckPoint;
        boolean canceled;
        boolean limitExceeded;
        boolean needRepeat;
        int iterationCount;
        int deletedDocGCCount;
        int deletedLeafDocGCCount;
        int splitDocGCCount;
        int intermediateSplitDocGCCount;
        int updateResurrectedGCCount;
        final TimeDurationFormatter df = TimeDurationFormatter.forLogging();
        final Stopwatch active = Stopwatch.createUnstarted();
        final Stopwatch collectDeletedDocs = Stopwatch.createUnstarted();
        final Stopwatch checkDeletedDocs = Stopwatch.createUnstarted();
        final Stopwatch deleteDeletedDocs = Stopwatch.createUnstarted();
        final Stopwatch collectAndDeleteSplitDocs = Stopwatch.createUnstarted();
        final Stopwatch deleteSplitDocs = Stopwatch.createUnstarted();
        final Stopwatch sortDocIds = Stopwatch.createUnstarted();
        final Stopwatch updateResurrectedDocuments = Stopwatch.createUnstarted();
        long activeElapsed;
        long collectDeletedDocsElapsed;
        long checkDeletedDocsElapsed;
        long deleteDeletedDocsElapsed;
        long collectAndDeleteSplitDocsElapsed;
        long deleteSplitDocsElapsed;
        long sortDocIdsElapsed;
        long updateResurrectedDocumentsElapsed;

        public String toString() {
            String timings;
            String fmt = "timeToCollectDeletedDocs=%s, timeToCheckDeletedDocs=%s, timeToSortDocIds=%s, timeTakenToUpdateResurrectedDocs=%s, timeTakenToDeleteDeletedDocs=%s, timeTakenToCollectAndDeleteSplitDocs=%s%s";
            if (this.iterationCount > 0) {
                String timeDeletingSplitDocs = "";
                if (this.deleteSplitDocsElapsed > 0L) {
                    timeDeletingSplitDocs = String.format(" (of which %s deleting)", this.df.format(this.deleteSplitDocsElapsed, TimeUnit.MICROSECONDS));
                }
                timings = String.format(fmt, this.df.format(this.collectDeletedDocsElapsed, TimeUnit.MICROSECONDS), this.df.format(this.checkDeletedDocsElapsed, TimeUnit.MICROSECONDS), this.df.format(this.sortDocIdsElapsed, TimeUnit.MICROSECONDS), this.df.format(this.updateResurrectedDocumentsElapsed, TimeUnit.MICROSECONDS), this.df.format(this.deleteDeletedDocsElapsed, TimeUnit.MICROSECONDS), this.df.format(this.collectAndDeleteSplitDocsElapsed, TimeUnit.MICROSECONDS), timeDeletingSplitDocs);
            } else {
                String timeDeletingSplitDocs = "";
                if (this.deleteSplitDocs.elapsed(TimeUnit.MICROSECONDS) > 0L) {
                    timeDeletingSplitDocs = String.format(" (of which %s deleting)", this.df.format(this.deleteSplitDocs.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS));
                }
                timings = String.format(fmt, this.df.format(this.collectDeletedDocs.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.checkDeletedDocs.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.sortDocIds.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.updateResurrectedDocuments.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.deleteDeletedDocs.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), this.df.format(this.collectAndDeleteSplitDocs.elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS), timeDeletingSplitDocs);
            }
            return "VersionGCStats{ignoredGCDueToCheckPoint=" + this.ignoredGCDueToCheckPoint + ", canceled=" + this.canceled + ", deletedDocGCCount=" + this.deletedDocGCCount + " (of which leaf: " + this.deletedLeafDocGCCount + "), updateResurrectedGCCount=" + this.updateResurrectedGCCount + ", splitDocGCCount=" + this.splitDocGCCount + ", intermediateSplitDocGCCount=" + this.intermediateSplitDocGCCount + ", iterationCount=" + this.iterationCount + ", timeActive=" + this.df.format(this.activeElapsed, TimeUnit.MICROSECONDS) + ", " + timings + "}";
        }

        void addRun(VersionGCStats run) {
            ++this.iterationCount;
            this.ignoredGCDueToCheckPoint = run.ignoredGCDueToCheckPoint;
            this.canceled = run.canceled;
            this.limitExceeded = run.limitExceeded;
            this.needRepeat = run.needRepeat;
            this.deletedDocGCCount += run.deletedDocGCCount;
            this.deletedLeafDocGCCount += run.deletedLeafDocGCCount;
            this.splitDocGCCount += run.splitDocGCCount;
            this.intermediateSplitDocGCCount += run.intermediateSplitDocGCCount;
            this.updateResurrectedGCCount += run.updateResurrectedGCCount;
            if (run.iterationCount > 0) {
                this.activeElapsed += run.activeElapsed;
                this.collectDeletedDocsElapsed += run.collectDeletedDocsElapsed;
                this.checkDeletedDocsElapsed += run.checkDeletedDocsElapsed;
                this.deleteDeletedDocsElapsed += run.deleteDeletedDocsElapsed;
                this.collectAndDeleteSplitDocsElapsed += run.collectAndDeleteSplitDocsElapsed;
                this.deleteSplitDocsElapsed += run.deleteSplitDocsElapsed;
                this.sortDocIdsElapsed += run.sortDocIdsElapsed;
                this.updateResurrectedDocumentsElapsed += run.updateResurrectedDocumentsElapsed;
            } else {
                this.activeElapsed += run.active.elapsed(TimeUnit.MICROSECONDS);
                this.collectDeletedDocsElapsed += run.collectDeletedDocs.elapsed(TimeUnit.MICROSECONDS);
                this.checkDeletedDocsElapsed += run.checkDeletedDocs.elapsed(TimeUnit.MICROSECONDS);
                this.deleteDeletedDocsElapsed += run.deleteDeletedDocs.elapsed(TimeUnit.MICROSECONDS);
                this.collectAndDeleteSplitDocsElapsed += run.collectAndDeleteSplitDocs.elapsed(TimeUnit.MICROSECONDS);
                this.deleteSplitDocsElapsed += run.deleteSplitDocs.elapsed(TimeUnit.MICROSECONDS);
                this.sortDocIdsElapsed += run.sortDocIds.elapsed(TimeUnit.MICROSECONDS);
                this.updateResurrectedDocumentsElapsed += run.updateResurrectedDocuments.elapsed(TimeUnit.MICROSECONDS);
            }
        }
    }

    public static class VersionGCInfo {
        public final long lastSuccess;
        public final long oldestRevisionEstimate;
        public final long revisionsCandidateCount;
        public final long collectLimit;
        public final long recommendedCleanupInterval;
        public final long recommendedCleanupTimestamp;
        public final int estimatedIterations;

        VersionGCInfo(long lastSuccess, long oldestRevisionEstimate, long revisionsCandidateCount, long collectLimit, long recommendedCleanupInterval, long recommendedCleanupTimestamp, int estimatedIterations) {
            this.lastSuccess = lastSuccess;
            this.oldestRevisionEstimate = oldestRevisionEstimate;
            this.revisionsCandidateCount = revisionsCandidateCount;
            this.collectLimit = collectLimit;
            this.recommendedCleanupInterval = recommendedCleanupInterval;
            this.recommendedCleanupTimestamp = recommendedCleanupTimestamp;
            this.estimatedIterations = estimatedIterations;
        }
    }
}

