/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreMBean;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;

final class DocumentNodeStoreMBeanImpl
extends AnnotatedStandardMBean
implements DocumentNodeStoreMBean {
    private static final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS zzz";
    private static final TimeZone TZ_UTC = TimeZone.getTimeZone("UTC");
    private final DocumentNodeStore nodeStore;
    private final RepositoryStatistics repoStats;
    private final Iterable<ClusterNodeInfoDocument> clusterNodes;

    DocumentNodeStoreMBeanImpl(DocumentNodeStore nodeStore, RepositoryStatistics repoStats, Iterable<ClusterNodeInfoDocument> clusterNodes) throws NotCompliantMBeanException {
        super(DocumentNodeStoreMBean.class);
        this.nodeStore = nodeStore;
        this.repoStats = repoStats;
        this.clusterNodes = clusterNodes;
    }

    @Override
    public String getRevisionComparatorState() {
        return "";
    }

    @Override
    public String getHead() {
        return this.nodeStore.getHeadRevision().toString();
    }

    @Override
    public int getClusterId() {
        return this.nodeStore.getClusterId();
    }

    @Override
    public int getUnmergedBranchCount() {
        return this.nodeStore.getBranches().size();
    }

    @Override
    public String[] getInactiveClusterNodes() {
        return (String[])Iterables.toArray((Iterable)Iterables.transform((Iterable)Iterables.filter(this.clusterNodes, (Predicate)new Predicate<ClusterNodeInfoDocument>(){

            public boolean apply(ClusterNodeInfoDocument input) {
                return !input.isActive();
            }
        }), (Function)new Function<ClusterNodeInfoDocument, String>(){

            public String apply(ClusterNodeInfoDocument input) {
                return input.getClusterId() + "=" + input.getCreated();
            }
        }), String.class);
    }

    @Override
    public String[] getActiveClusterNodes() {
        return (String[])Iterables.toArray((Iterable)Iterables.transform((Iterable)Iterables.filter(this.clusterNodes, (Predicate)new Predicate<ClusterNodeInfoDocument>(){

            public boolean apply(ClusterNodeInfoDocument input) {
                return input.isActive();
            }
        }), (Function)new Function<ClusterNodeInfoDocument, String>(){

            public String apply(ClusterNodeInfoDocument input) {
                return input.getClusterId() + "=" + input.getLeaseEndTime();
            }
        }), String.class);
    }

    @Override
    public String[] getLastKnownRevisions() {
        return (String[])Iterables.toArray((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)this.nodeStore.getHeadRevision(), (Predicate)new Predicate<Revision>(){

            public boolean apply(Revision input) {
                return input.getClusterId() != DocumentNodeStoreMBeanImpl.this.getClusterId();
            }
        }), (Function)new Function<Revision, String>(){

            public String apply(Revision input) {
                return input.getClusterId() + "=" + input.toString();
            }
        }), String.class);
    }

    @Override
    public String formatRevision(String rev, boolean utc) {
        Revision r = Revision.fromString(rev);
        SimpleDateFormat sdf = new SimpleDateFormat(ISO_FORMAT);
        if (utc) {
            sdf.setTimeZone(TZ_UTC);
        }
        return sdf.format(r.getTimestamp());
    }

    @Override
    public long determineServerTimeDifferenceMillis() {
        return this.nodeStore.getDocumentStore().determineServerTimeDifferenceMillis();
    }

    @Override
    public CompositeData getMergeSuccessHistory() {
        return this.getTimeSeriesData("DOCUMENT_NS_MERGE_SUCCESS_COUNT", "Merge Success Count");
    }

    @Override
    public CompositeData getMergeFailureHistory() {
        return this.getTimeSeriesData("DOCUMENT_NS_MERGE_FAILED_EXCLUSIVE", "Merge failure count");
    }

    @Override
    public CompositeData getExternalChangeCountHistory() {
        return this.getTimeSeriesData("DOCUMENT_NS_BGR_NUM_CHANGES_RATE", "Count of nodes modified by other cluster nodes since last background read");
    }

    @Override
    public CompositeData getBackgroundUpdateCountHistory() {
        return this.getTimeSeriesData("DOCUMENT_NS_BGW_NUM_WRITE_RATE", "Count of nodes updated as part of background update");
    }

    @Override
    public CompositeData getBranchCommitHistory() {
        return this.getTimeSeriesData("DOCUMENT_NS_BRANCH_COMMIT_COUNT", "Branch commit count");
    }

    @Override
    public CompositeData getMergeBranchCommitHistory() {
        return this.getTimeSeriesData("DOCUMENT_NS_MERGE_BRANCH_COMMIT_COUNT", "Number of merged branch commits");
    }

    private CompositeData getTimeSeriesData(String name, String desc) {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(name), (String)desc);
    }

    private TimeSeries getTimeSeries(String name) {
        return this.repoStats.getTimeSeries(name, true);
    }
}

