/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopStream;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Collision;
import org.apache.jackrabbit.oak.plugins.document.ConflictException;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.JournalEntry;
import org.apache.jackrabbit.oak.plugins.document.LastRevTracker;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commit {
    private static final Logger LOG = LoggerFactory.getLogger(Commit.class);
    protected final DocumentNodeStore nodeStore;
    private final RevisionVector baseRevision;
    private final Revision revision;
    private final HashMap<String, UpdateOp> operations = new LinkedHashMap<String, UpdateOp>();
    private final Set<Revision> collisions = new LinkedHashSet<Revision>();
    private Branch b;
    private boolean rollbackFailed;
    private HashSet<String> modifiedNodes = new HashSet();
    private HashSet<String> addedNodes = new HashSet();
    private HashSet<String> removedNodes = new HashSet();
    private HashSet<String> nodesWithBinaries = Sets.newHashSet();
    private HashMap<String, String> bundledNodes = Maps.newHashMap();
    private static final Function<UpdateOp.Key, String> KEY_TO_NAME = new Function<UpdateOp.Key, String>(){

        public String apply(UpdateOp.Key input) {
            return input.getName();
        }
    };

    Commit(@Nonnull DocumentNodeStore nodeStore, @Nonnull Revision revision, @Nullable RevisionVector baseRevision) {
        this.nodeStore = (DocumentNodeStore)Preconditions.checkNotNull((Object)nodeStore);
        this.revision = (Revision)Preconditions.checkNotNull((Object)revision);
        this.baseRevision = baseRevision;
    }

    UpdateOp getUpdateOperationForNode(String path) {
        UpdateOp op = this.operations.get(path);
        if (op == null) {
            op = Commit.createUpdateOp(path, this.revision, this.getBranch() != null);
            this.operations.put(path, op);
        }
        return op;
    }

    static UpdateOp createUpdateOp(String path, Revision revision, boolean isBranch) {
        String id = Utils.getIdFromPath(path);
        UpdateOp op = new UpdateOp(id, false);
        NodeDocument.setModified(op, revision);
        if (isBranch) {
            NodeDocument.setBranchCommit(op, revision);
        }
        return op;
    }

    @Nonnull
    Revision getRevision() {
        return this.revision;
    }

    @CheckForNull
    RevisionVector getBaseRevision() {
        return this.baseRevision;
    }

    @Nonnull
    Iterable<String> getModifiedPaths() {
        return this.modifiedNodes;
    }

    void updateProperty(String path, String propertyName, String value) {
        UpdateOp op = this.getUpdateOperationForNode(path);
        String key = Utils.escapePropertyName(propertyName);
        op.setMapEntry(key, this.revision, value);
    }

    void addBundledNode(String path, String bundlingRootPath) {
        this.bundledNodes.put(path, bundlingRootPath);
    }

    void markNodeHavingBinary(String path) {
        this.nodesWithBinaries.add(path);
    }

    void addNode(DocumentNodeState n) {
        String path = n.getPath();
        if (this.operations.containsKey(path)) {
            String msg = "Node already added: " + path;
            LOG.error(msg);
            throw new DocumentStoreException(msg);
        }
        UpdateOp op = n.asOperation(this.revision);
        if (this.getBranch() != null) {
            NodeDocument.setBranchCommit(op, this.revision);
        }
        this.operations.put(path, op);
        this.addedNodes.add(path);
    }

    boolean isEmpty() {
        return this.operations.isEmpty();
    }

    boolean rollbackFailed() {
        return this.rollbackFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply() throws ConflictException, DocumentStoreException {
        boolean success = false;
        RevisionVector baseRev = this.getBaseRevision();
        boolean isBranch = baseRev != null && baseRev.isBranch();
        Revision rev = this.getRevision();
        if (isBranch && !this.nodeStore.isDisableBranches()) {
            try {
                this.prepare(baseRev);
                success = true;
            }
            finally {
                Branch branch;
                if (!success && (branch = this.getBranch()) != null) {
                    branch.removeCommit(rev.asBranchRevision());
                    if (!branch.hasCommits()) {
                        this.nodeStore.getBranches().remove(branch);
                    }
                }
            }
        } else {
            this.applyInternal();
        }
    }

    private void applyInternal() {
        if (!this.operations.isEmpty()) {
            this.updateParentChildStatus();
            this.updateBinaryStatus();
            this.applyToDocumentStore();
        }
    }

    private void prepare(RevisionVector baseRevision) {
        if (!this.operations.isEmpty()) {
            this.updateParentChildStatus();
            this.updateBinaryStatus();
            this.applyToDocumentStore(baseRevision);
        }
    }

    private void updateBinaryStatus() {
        DocumentStore store = this.nodeStore.getDocumentStore();
        for (String path : this.nodesWithBinaries) {
            NodeDocument nd = store.getIfCached(Collection.NODES, Utils.getIdFromPath(path));
            if (nd != null && nd.hasBinary()) continue;
            UpdateOp updateParentOp = this.getUpdateOperationForNode(path);
            NodeDocument.setHasBinary(updateParentOp);
        }
    }

    void applyToDocumentStore() {
        this.applyToDocumentStore(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyToDocumentStore(RevisionVector baseBranchRevision) throws DocumentStoreException {
        block22: {
            this.rollbackFailed = true;
            String commitValue = baseBranchRevision != null ? baseBranchRevision.getBranchRevision().toString() : "c";
            DocumentStore store = this.nodeStore.getDocumentStore();
            String commitRootPath = null;
            if (baseBranchRevision != null) {
                commitRootPath = "/";
            }
            ArrayList<UpdateOp> changedNodes = new ArrayList<UpdateOp>();
            ArrayList<UpdateOp> opLog = new ArrayList<UpdateOp>();
            for (String p : this.operations.keySet()) {
                this.markChanged(p);
                if (commitRootPath == null) {
                    commitRootPath = p;
                    continue;
                }
                while (!PathUtils.isAncestor((String)commitRootPath, (String)p) && !PathUtils.denotesRoot((String)(commitRootPath = PathUtils.getParentPath((String)commitRootPath)))) {
                }
            }
            for (String p : this.bundledNodes.keySet()) {
                this.markChanged(p);
            }
            if (baseBranchRevision != null) {
                JournalEntry doc = Collection.JOURNAL.newDocument(store);
                doc.modified(this.modifiedNodes);
                Revision r = this.revision.asBranchRevision();
                store.create(Collection.JOURNAL, Collections.singletonList(doc.asUpdateOp(r)));
            }
            int commitRootDepth = PathUtils.getDepth((String)commitRootPath);
            boolean commitRootHasChanges = this.operations.containsKey(commitRootPath);
            for (UpdateOp op : this.operations.values()) {
                NodeDocument.setCommitRoot(op, this.revision, commitRootDepth);
                changedNodes.add(op);
            }
            UpdateOp commitRoot = this.getUpdateOperationForNode(commitRootPath);
            boolean success = false;
            try {
                opLog.addAll(changedNodes);
                if (this.conditionalCommit(changedNodes, commitValue)) {
                    success = true;
                } else {
                    List<NodeDocument> oldDocs = store.createOrUpdate(Collection.NODES, changedNodes);
                    this.checkConflicts(oldDocs, changedNodes);
                    this.checkSplitCandidate(oldDocs);
                    NodeDocument.setRevision(commitRoot, this.revision, commitValue);
                    if (commitRootHasChanges) {
                        NodeDocument.removeCommitRoot(commitRoot, this.revision);
                    }
                    opLog.add(commitRoot);
                    if (baseBranchRevision == null) {
                        UpdateOp commit = commitRoot.copy();
                        commit.setNew(false);
                        commit.containsMapEntry("_collisions", this.revision, false);
                        NodeDocument before = this.nodeStore.updateCommitRoot(commit, this.revision);
                        if (before == null) {
                            String msg = "Conflicting concurrent change. Update operation failed: " + commitRoot;
                            NodeDocument commitRootDoc = store.find(Collection.NODES, commitRoot.getId());
                            DocumentStoreException dse = commitRootDoc == null ? new DocumentStoreException(msg) : new ConflictException(msg, commitRootDoc.getConflictsFor(Collections.singleton(this.revision)));
                            throw dse;
                        }
                        success = true;
                        this.checkConflicts(commitRoot, before);
                        this.checkSplitCandidate(before);
                    } else {
                        this.createOrUpdateNode(store, commitRoot);
                    }
                }
            }
            catch (Exception e) {
                if (success) {
                    LOG.error("Exception occurred after commit. Rollback will be suppressed.", (Throwable)e);
                    break block22;
                }
                try {
                    this.rollback(opLog, commitRoot);
                    this.rollbackFailed = false;
                }
                catch (Throwable ex) {
                    LOG.warn("Rollback failed", ex);
                }
                throw DocumentStoreException.convert(e);
            }
            finally {
                if (success) {
                    this.rollbackFailed = false;
                }
            }
        }
    }

    private boolean conditionalCommit(List<UpdateOp> changedNodes, String commitValue) throws DocumentStoreException {
        if (!Utils.isCommitted(commitValue) || changedNodes.size() != 1) {
            return false;
        }
        UpdateOp op = changedNodes.get(0);
        DocumentStore store = this.nodeStore.getDocumentStore();
        NodeDocument doc = store.getIfCached(Collection.NODES, op.getId());
        if (doc == null || doc.getModCount() == null) {
            return false;
        }
        try {
            this.checkConflicts(op, doc);
        }
        catch (ConflictException e) {
            this.removeCollisionMarker(op.getId());
            return false;
        }
        UpdateOp commit = op.copy();
        NodeDocument.unsetCommitRoot(commit, this.revision);
        NodeDocument.setRevision(commit, this.revision, commitValue);
        commit.equals("_modCount", doc.getModCount());
        NodeDocument before = this.nodeStore.updateCommitRoot(commit, this.revision);
        if (before != null) {
            this.checkSplitCandidate(before);
        }
        return before != null;
    }

    private void removeCollisionMarker(String id) {
        UpdateOp removeCollision = new UpdateOp(id, false);
        NodeDocument.removeCollision(removeCollision, this.revision);
        this.nodeStore.getDocumentStore().findAndUpdate(Collection.NODES, removeCollision);
    }

    private void updateParentChildStatus() {
        HashSet processedParents = Sets.newHashSet();
        for (String path : this.addedNodes) {
            String parentPath;
            if (PathUtils.denotesRoot((String)path) || processedParents.contains(parentPath = PathUtils.getParentPath((String)path)) || this.isBundled(parentPath)) continue;
            processedParents.add(parentPath);
            UpdateOp op = this.getUpdateOperationForNode(parentPath);
            NodeDocument.setChildrenFlag(op, true);
        }
    }

    private void rollback(List<UpdateOp> changed, UpdateOp commitRoot) {
        DocumentStore store = this.nodeStore.getDocumentStore();
        for (UpdateOp op : changed) {
            UpdateOp reverse = op.getReverseOperation();
            if (op.isNew()) {
                NodeDocument.setDeletedOnce(reverse);
            }
            store.findAndUpdate(Collection.NODES, reverse);
        }
        this.removeCollisionMarker(commitRoot.getId());
    }

    private void createOrUpdateNode(DocumentStore store, UpdateOp op) {
        NodeDocument doc = store.createOrUpdate(Collection.NODES, op);
        this.checkConflicts(op, doc);
        this.checkSplitCandidate(doc);
    }

    private void checkSplitCandidate(Iterable<NodeDocument> docs) {
        for (NodeDocument doc : docs) {
            this.checkSplitCandidate(doc);
        }
    }

    private void checkSplitCandidate(@Nullable NodeDocument doc) {
        if (doc == null) {
            return;
        }
        if (doc.getMemory() > 8192 || doc.hasBinary()) {
            this.nodeStore.addSplitCandidate(doc.getId());
        }
    }

    private void checkConflicts(@Nonnull UpdateOp op, @Nullable NodeDocument before) throws ConflictException {
        DocumentStore store = this.nodeStore.getDocumentStore();
        this.collisions.clear();
        if (this.baseRevision != null) {
            Revision newestRev = null;
            if (before != null) {
                RevisionVector base = this.baseRevision;
                if (this.nodeStore.isDisableBranches()) {
                    base = base.asTrunkRevision();
                }
                newestRev = before.getNewestRevision(this.nodeStore, base, this.revision, this.getBranch(), this.collisions);
            }
            String conflictMessage = null;
            HashSet conflictRevisions = Sets.newHashSet();
            if (newestRev == null) {
                if (!(!op.isDelete() && op.isNew() || this.allowConcurrentAddRemove(before, op))) {
                    conflictMessage = "The node " + op.getId() + " does not exist or is already deleted";
                    if (before != null && !before.getLocalDeleted().isEmpty()) {
                        conflictRevisions.add(before.getLocalDeleted().firstKey());
                    }
                }
            } else {
                conflictRevisions.add(newestRev);
                if (op.isNew() && !this.allowConcurrentAddRemove(before, op)) {
                    conflictMessage = "The node " + op.getId() + " was already added in revision\n" + this.formatConflictRevision(newestRev);
                } else if (this.baseRevision.isRevisionNewer(newestRev) && (op.isDelete() || this.isConflicting(before, op))) {
                    conflictMessage = "The node " + op.getId() + " was changed in revision\n" + this.formatConflictRevision(newestRev) + ", which was applied after the base revision\n" + this.baseRevision;
                }
            }
            if (conflictMessage == null && before != null) {
                boolean allowConflictingDeleteChange = this.allowConcurrentAddRemove(before, op);
                for (Revision r : this.collisions) {
                    Collision c = new Collision(before, r, op, this.revision, this.nodeStore);
                    if (!c.isConflicting() || allowConflictingDeleteChange || !c.mark(store).equals(this.revision) || this.baseRevision.isBranch()) continue;
                    conflictMessage = "The node " + op.getId() + " was changed in revision\n" + this.formatConflictRevision(r) + ", which was applied after the base revision\n" + this.baseRevision;
                    conflictRevisions.add(r);
                }
            }
            if (conflictMessage != null) {
                conflictMessage = conflictMessage + ", before\n" + this.revision;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(conflictMessage + "; document:\n" + (before == null ? "" : before.format()));
                }
                throw new ConflictException(conflictMessage, conflictRevisions);
            }
        }
    }

    private void checkConflicts(List<NodeDocument> oldDocs, List<UpdateOp> updates) {
        int i = 0;
        ArrayList<ConflictException> exceptions = new ArrayList<ConflictException>();
        HashSet<Revision> revisions = new HashSet<Revision>();
        for (NodeDocument doc : oldDocs) {
            UpdateOp op = updates.get(i++);
            try {
                this.checkConflicts(op, doc);
            }
            catch (ConflictException e) {
                exceptions.add(e);
                Iterables.addAll(revisions, e.getConflictRevisions());
            }
        }
        if (!exceptions.isEmpty()) {
            throw new ConflictException("Following exceptions occurred during the bulk update operations: " + exceptions, revisions);
        }
    }

    private String formatConflictRevision(Revision r) {
        if (this.nodeStore.getHeadRevision().isRevisionNewer(r)) {
            return r + " (not yet visible)";
        }
        if (this.baseRevision != null && !this.baseRevision.isRevisionNewer(r) && !Objects.equal((Object)this.baseRevision.getRevision(r.getClusterId()), (Object)r)) {
            return r + " (older than base " + this.baseRevision + ")";
        }
        return r.toString();
    }

    private boolean isConflicting(@Nullable NodeDocument doc, @Nonnull UpdateOp op) {
        if (this.baseRevision == null || doc == null) {
            return false;
        }
        return doc.isConflicting(op, this.baseRevision, this.revision, this.nodeStore.getEnableConcurrentAddRemove());
    }

    private boolean allowConcurrentAddRemove(@Nullable NodeDocument before, @Nonnull UpdateOp op) {
        return this.nodeStore.getEnableConcurrentAddRemove() && !this.isConflicting(before, op);
    }

    @CheckForNull
    private Branch getBranch() {
        if (this.baseRevision == null || !this.baseRevision.isBranch()) {
            return null;
        }
        if (this.b == null) {
            this.b = this.nodeStore.getBranches().getBranch(new RevisionVector(this.revision.asBranchRevision()));
        }
        return this.b;
    }

    public void applyToCache(RevisionVector before, boolean isBranchCommit) {
        HashMap<String, ArrayList<String>> nodesWithChangedChildren = new HashMap<String, ArrayList<String>>();
        for (String p : this.modifiedNodes) {
            if (PathUtils.denotesRoot((String)p)) continue;
            String parent = PathUtils.getParentPath((String)p);
            ArrayList<String> list = (ArrayList<String>)nodesWithChangedChildren.get(parent);
            if (list == null) {
                list = new ArrayList<String>();
                nodesWithChangedChildren.put(parent, list);
            }
            list.add(p);
        }
        Revision rev = isBranchCommit ? this.revision.asBranchRevision() : this.revision;
        RevisionVector after = before.update(rev);
        DiffCache.Entry cacheEntry = this.nodeStore.getDiffCache().newEntry(before, after, true);
        LastRevTracker tracker = this.nodeStore.createTracker(this.revision, isBranchCommit);
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> removed = new ArrayList<String>();
        ArrayList<String> changed = new ArrayList<String>();
        for (String path : this.modifiedNodes) {
            added.clear();
            removed.clear();
            changed.clear();
            ArrayList changes = (ArrayList)nodesWithChangedChildren.get(path);
            if (changes != null) {
                for (String s : changes) {
                    if (this.addedNodes.contains(s)) {
                        added.add(s);
                        continue;
                    }
                    if (this.removedNodes.contains(s)) {
                        removed.add(s);
                        continue;
                    }
                    changed.add(s);
                }
            }
            UpdateOp op = this.operations.get(path);
            if (!this.isBundled(path)) {
                boolean isNew;
                boolean bl = isNew = op != null && op.isNew();
                if (op == null || !Commit.hasContentChanges(op) || PathUtils.denotesRoot((String)path)) {
                    tracker.track(path);
                }
                this.nodeStore.applyChanges(before, after, rev, path, isNew, added, removed, changed);
            }
            this.addChangesToDiffCacheEntry(path, added, removed, changed, cacheEntry);
        }
        cacheEntry.done();
    }

    private void addChangesToDiffCacheEntry(String path, List<String> added, List<String> removed, List<String> changed, DiffCache.Entry cacheEntry) {
        JsopStream w = new JsopStream();
        for (String p : added) {
            w.tag('+').key(PathUtils.getName((String)p)).object().endObject();
        }
        for (String p : removed) {
            w.tag('-').value(PathUtils.getName((String)p));
        }
        for (String p : changed) {
            w.tag('^').key(PathUtils.getName((String)p)).object().endObject();
        }
        cacheEntry.append(path, w.toString());
    }

    private void markChanged(String path) {
        if (!PathUtils.denotesRoot((String)path) && !PathUtils.isAbsolute((String)path)) {
            throw new IllegalArgumentException("path: " + path);
        }
        while (this.modifiedNodes.add(path) && !PathUtils.denotesRoot((String)path)) {
            path = PathUtils.getParentPath((String)path);
        }
    }

    public void removeNode(String path, NodeState state) {
        this.removedNodes.add(path);
        UpdateOp op = this.getUpdateOperationForNode(path);
        op.setDelete(true);
        NodeDocument.setDeleted(op, this.revision, true);
        for (PropertyState p : state.getProperties()) {
            this.updateProperty(path, p.getName(), null);
        }
    }

    private boolean isBundled(String path) {
        return this.bundledNodes.containsKey(path);
    }

    private static boolean hasContentChanges(UpdateOp op) {
        return Iterables.filter((Iterable)Iterables.transform(op.getChanges().keySet(), KEY_TO_NAME), Utils.PROPERTY_OR_DELETED).iterator().hasNext();
    }
}

