/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.mongodb.MongoClientURI;
import java.io.Closeable;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.Predicates;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.io.Closer;
import org.apache.jackrabbit.guava.common.util.concurrent.UncheckedExecutionException;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.api.jmx.PersistentCacheStatsMBean;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.blob.BlobGC;
import org.apache.jackrabbit.oak.plugins.blob.BlobGCMBean;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreStats;
import org.apache.jackrabbit.oak.plugins.blob.BlobTrackingStore;
import org.apache.jackrabbit.oak.plugins.blob.MarkSweepGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobIdTracker;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobTracker;
import org.apache.jackrabbit.oak.plugins.blob.datastore.SharedDataStoreUtils;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.Configuration;
import org.apache.jackrabbit.oak.plugins.document.DocumentCheckpointMBean;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStateCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreMBean;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreServiceConfiguration;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreStatsMBean;
import org.apache.jackrabbit.oak.plugins.document.JournalPropertyHandlerFactory;
import org.apache.jackrabbit.oak.plugins.document.LeaseCheckMode;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.QuietGCMonitor;
import org.apache.jackrabbit.oak.plugins.document.RevisionGCStatsMBean;
import org.apache.jackrabbit.oak.plugins.document.ThrottlingStatsCollectorImpl;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStoreMetrics;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCacheStats;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.spi.lease.LeaseFailureHandler;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStoreWrapper;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.blob.stats.BlobStoreStatsMBean;
import org.apache.jackrabbit.oak.spi.cluster.ClusterRepositoryInfo;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserverMBean;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.ObserverTracker;
import org.apache.jackrabbit.oak.spi.descriptors.GenericDescriptors;
import org.apache.jackrabbit.oak.spi.gc.DelegatingGCMonitor;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.gc.GCMonitorTracker;
import org.apache.jackrabbit.oak.spi.gc.LoggingGCMonitor;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.NodeStoreProvider;
import org.apache.jackrabbit.oak.spi.state.RevisionGC;
import org.apache.jackrabbit.oak.spi.state.RevisionGCMBean;
import org.apache.jackrabbit.oak.spi.toggle.Feature;
import org.apache.jackrabbit.oak.spi.whiteboard.AbstractServiceTracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreService"})
public class DocumentNodeStoreService {
    private static final long MB = 0x100000L;
    static final String DEFAULT_URI = "mongodb://localhost:27017/oak";
    static final int DEFAULT_CACHE = 256;
    static final int DEFAULT_BLOB_CACHE_SIZE = 16;
    static final String DEFAULT_DB = "oak";
    static final boolean DEFAULT_SO_KEEP_ALIVE = true;
    static final boolean DEFAULT_THROTTLING_ENABLED = false;
    static final int DEFAULT_MONGO_LEASE_SO_TIMEOUT_MILLIS = 30000;
    static final String DEFAULT_PERSISTENT_CACHE = "cache";
    static final String DEFAULT_JOURNAL_CACHE = "diff-cache";
    static final boolean DEFAULT_CUSTOM_BLOB_STORE = false;
    public static final String CONTINUOUS_RGC_EXPR = "*/5 * * * * ?";
    public static final String CLASSIC_RGC_EXPR = "0 0 2 * * ?";
    public static final long DEFAULT_RGC_TIME_LIMIT_SECS = 10800L;
    public static final double DEFAULT_RGC_DELAY_FACTOR = 0.0;
    private static final String DESCRIPTION = "oak.nodestore.description";
    static final long DEFAULT_JOURNAL_GC_INTERVAL_MILLIS = 300000L;
    static final long DEFAULT_JOURNAL_GC_MAX_AGE_MILLIS = 86400000L;
    static final boolean DEFAULT_PREFETCH_EXTERNAL_CHANGES = false;
    private static final String DEFAULT_PROP_HOME = "./repository";
    static final long DEFAULT_MAX_REPLICATION_LAG = 21600L;
    static final boolean DEFAULT_BUNDLING_DISABLED = false;
    static final String DEFAULT_VER_GC_EXPRESSION = "";
    static final long DEFAULT_VER_GC_MAX_AGE = 86400L;
    static final long DEFAULT_BLOB_GC_MAX_AGE = 86400L;
    static final long DEFAULT_BLOB_SNAPSHOT_INTERVAL = 43200L;
    private static final String FT_NAME_PREFETCH = "FT_PREFETCH_OAK-9780";
    private static final String FT_NAME_DOC_STORE_THROTTLING = "FT_THROTTLING_OAK-9909";
    public static final String CUSTOM_BLOB_STORE = "customBlobStore";
    public static final String PROP_REV_RECOVERY_INTERVAL = "lastRevRecoveryJobIntervalInSecs";
    public static final String PROP_DS_TYPE = "documentStoreType";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ServiceRegistration nodeStoreReg;
    private Closer closer;
    private WhiteboardExecutor executor;
    private volatile BlobStore blobStore;
    private volatile DataSource dataSource;
    private volatile DataSource blobDataSource;
    private volatile DocumentNodeStateCache nodeStateCache;
    private DocumentNodeStore nodeStore;
    private ObserverTracker observerTracker;
    private JournalPropertyHandlerFactory journalPropertyHandlerFactory = new JournalPropertyHandlerFactory();
    private Feature prefetchFeature;
    private Feature docStoreThrottlingFeature;
    private ComponentContext context;
    private Whiteboard whiteboard;
    private long deactivationTimestamp = 0L;
    @Reference
    private StatisticsProvider statisticsProvider;
    @Reference
    private ConfigurationAdmin configurationAdmin;
    @Reference(service=Preset.class)
    private Preset preset;
    private boolean customBlobStore;
    private ServiceRegistration blobStoreReg;
    private BlobStore defaultBlobStore;
    private Configuration config;
    private DocumentStoreType documentStoreType;

    @Activate
    protected void activate(ComponentContext context, Configuration config) throws Exception {
        this.closer = Closer.create();
        this.config = DocumentNodeStoreServiceConfiguration.create(context, this.configurationAdmin, this.preset.configuration, config);
        this.context = context;
        this.whiteboard = new OsgiWhiteboard(context.getBundleContext());
        this.executor = new WhiteboardExecutor();
        this.executor.start(this.whiteboard);
        this.customBlobStore = this.config.customBlobStore();
        this.documentStoreType = DocumentStoreType.fromString(this.config.documentStoreType());
        this.prefetchFeature = Feature.newFeature((String)FT_NAME_PREFETCH, (Whiteboard)this.whiteboard);
        this.docStoreThrottlingFeature = Feature.newFeature((String)FT_NAME_DOC_STORE_THROTTLING, (Whiteboard)this.whiteboard);
        this.registerNodeStoreIfPossible();
    }

    private void registerNodeStoreIfPossible() throws IOException {
        if (this.deactivationTimestamp != 0L) {
            this.log.info("DocumentNodeStore was already unregistered ({}ms ago)", (Object)(System.currentTimeMillis() - this.deactivationTimestamp));
        } else if (this.context == null) {
            this.log.info("Component still not activated. Ignoring the initialization call");
        } else if (this.customBlobStore && this.blobStore == null) {
            this.log.info("Custom BlobStore use enabled. DocumentNodeStoreService would be initialized when BlobStore would be available");
        } else if (this.documentStoreType == DocumentStoreType.RDB && (this.dataSource == null || this.blobDataSource == null)) {
            this.log.info("DataSource use enabled. DocumentNodeStoreService would be initialized when DataSource would be available (currently available: nodes: {}, blobs: {})", (Object)this.dataSource, (Object)this.blobDataSource);
        } else {
            this.registerNodeStore();
        }
    }

    private void registerNodeStore() throws IOException {
        String[] serviceClasses;
        DocumentNodeStoreBuilder mkBuilder;
        if (this.documentStoreType == DocumentStoreType.RDB) {
            RDBDocumentNodeStoreBuilder builder = RDBDocumentNodeStoreBuilder.newRDBDocumentNodeStoreBuilder();
            this.configureBuilder(builder);
            Preconditions.checkNotNull((Object)this.dataSource, (String)"DataStore type set [%s] but DataSource reference not initialized", (Object)PROP_DS_TYPE);
            if (!this.customBlobStore) {
                Preconditions.checkNotNull((Object)this.blobDataSource, (String)"DataStore type set [%s] but BlobDataSource reference not initialized", (Object)PROP_DS_TYPE);
                builder.setRDBConnection(this.dataSource, this.blobDataSource);
                this.log.info("Connected to datasources {} {}", (Object)this.dataSource, (Object)this.blobDataSource);
            } else {
                if (this.blobDataSource != null && this.blobDataSource != this.dataSource) {
                    this.log.info("Ignoring blobDataSource {} as custom blob store takes precedence.", (Object)this.blobDataSource);
                }
                builder.setRDBConnection(this.dataSource);
                this.log.info("Connected to datasource {}", (Object)this.dataSource);
            }
            mkBuilder = builder;
        } else {
            String uri = this.config.mongouri();
            String db = this.config.db();
            boolean soKeepAlive = this.config.socketKeepAlive();
            MongoClientURI mongoURI = new MongoClientURI(uri);
            String persistentCache = this.resolvePath(this.config.persistentCache(), DEFAULT_PERSISTENT_CACHE);
            String journalCache = this.resolvePath(this.config.journalCache(), DEFAULT_JOURNAL_CACHE);
            if (this.log.isInfoEnabled()) {
                this.log.info("Starting DocumentNodeStore with host={}, db={}, cache size (MB)={}, persistentCache={}, journalCache={}, blobCacheSize (MB)={}, maxReplicationLagInSecs={}", new Object[]{mongoURI.getHosts(), db, this.config.cache(), persistentCache, journalCache, this.config.blobCacheSize(), this.config.maxReplicationLagInSecs()});
                this.log.info("Mongo Connection details {}", (Object)MongoConnection.toString(mongoURI.getOptions()));
            }
            MongoDocumentNodeStoreBuilder builder = MongoDocumentNodeStoreBuilder.newMongoDocumentNodeStoreBuilder();
            this.configureBuilder(builder);
            builder.setMaxReplicationLag(this.config.maxReplicationLagInSecs(), TimeUnit.SECONDS);
            builder.setSocketKeepAlive(soKeepAlive);
            builder.setLeaseSocketTimeout(this.config.mongoLeaseSocketTimeout());
            builder.setMongoDB(uri, db, this.config.blobCacheSize());
            builder.setCollectionCompressionType(this.config.collectionCompressionType());
            mkBuilder = builder;
            this.log.info("Connected to database '{}'", (Object)db);
        }
        if (!this.customBlobStore) {
            this.defaultBlobStore = mkBuilder.getBlobStore();
            this.log.info("Registering the BlobStore with ServiceRegistry");
            this.blobStoreReg = this.context.getBundleContext().registerService(BlobStore.class.getName(), (Object)this.defaultBlobStore, null);
        }
        if (this.isWrappingCustomBlobStore()) {
            ((BlobStoreWrapper)this.blobStore).setBlobStore(mkBuilder.getBlobStore());
            mkBuilder.setBlobStore(this.blobStore);
        }
        GCMonitorTracker gcMonitor = new GCMonitorTracker();
        gcMonitor.start(this.whiteboard);
        this.closer.register(DocumentNodeStoreService.asCloseable((AbstractServiceTracker)gcMonitor));
        Logger vgcLogger = LoggerFactory.getLogger(VersionGarbageCollector.class);
        QuietGCMonitor loggingGCMonitor = this.isContinuousRevisionGC() ? new QuietGCMonitor(vgcLogger) : new LoggingGCMonitor(vgcLogger);
        mkBuilder.setGCMonitor((GCMonitor)new DelegatingGCMonitor((Collection)Lists.newArrayList((Object[])new GCMonitor[]{gcMonitor, loggingGCMonitor})));
        mkBuilder.setRevisionGCMaxAge(TimeUnit.SECONDS.toMillis(this.config.versionGcMaxAgeInSecs()));
        this.nodeStore = mkBuilder.build();
        GenericDescriptors clusterIdDesc = new GenericDescriptors();
        clusterIdDesc.put("oak.clusterid", new SimpleValueFactory().createValue(ClusterRepositoryInfo.getOrCreateId((NodeStore)this.nodeStore)), true, false);
        this.whiteboard.register(Descriptors.class, (Object)clusterIdDesc, Collections.emptyMap());
        if (SharedDataStoreUtils.isShared((BlobStore)this.blobStore)) {
            String repoId = null;
            try {
                repoId = ClusterRepositoryInfo.getOrCreateId((NodeStore)this.nodeStore);
                ((SharedDataStore)this.blobStore).setRepositoryId(repoId);
            }
            catch (Exception e) {
                throw new IOException("Could not register a unique repositoryId", e);
            }
            if (this.blobStore instanceof BlobTrackingStore) {
                BlobTrackingStore trackingStore = (BlobTrackingStore)this.blobStore;
                if (trackingStore.getTracker() != null) {
                    trackingStore.getTracker().close();
                }
                ((BlobTrackingStore)this.blobStore).addTracker((BlobTracker)BlobIdTracker.build((String)this.getRepositoryHome(), (String)repoId, (long)this.config.blobTrackSnapshotIntervalInSecs(), (SharedDataStore)((SharedDataStore)this.blobStore)));
            }
        }
        this.registerJMXBeans(this.nodeStore, mkBuilder);
        this.registerLastRevRecoveryJob(this.nodeStore);
        this.registerJournalGC(this.nodeStore);
        this.registerVersionGCJob(this.nodeStore);
        this.registerDocumentStoreMetrics(mkBuilder.getDocumentStore());
        if (!this.isNodeStoreProvider()) {
            this.observerTracker = new ObserverTracker((Observable)this.nodeStore);
            this.observerTracker.start(this.context.getBundleContext());
        }
        this.journalPropertyHandlerFactory.start(this.whiteboard);
        DocumentStore ds = this.nodeStore.getDocumentStore();
        if (this.isNodeStoreProvider()) {
            this.registerNodeStoreProvider(this.nodeStore);
            serviceClasses = new String[]{DocumentNodeStore.class.getName(), Clusterable.class.getName()};
        } else {
            serviceClasses = new String[]{NodeStore.class.getName(), DocumentNodeStore.class.getName(), Clusterable.class.getName()};
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.pid", DocumentNodeStore.class.getName());
        ((Dictionary)props).put(DESCRIPTION, DocumentNodeStoreService.getMetadata(ds));
        this.nodeStoreReg = this.context.getBundleContext().registerService(serviceClasses, (Object)this.nodeStore, props);
    }

    private LeaseFailureHandler createDefaultLeaseFailureHandler() {
        return new LeaseFailureHandler(){

            @Override
            public void handleLeaseFailure() {
                Bundle bundle = DocumentNodeStoreService.this.context.getBundleContext().getBundle();
                String bundleName = bundle.getSymbolicName();
                try {
                    DocumentNodeStoreService.this.log.error("handleLeaseFailure: stopping {}...", (Object)bundleName);
                    bundle.stop(1);
                    DocumentNodeStoreService.this.log.error("handleLeaseFailure: stopped {}.", (Object)bundleName);
                }
                catch (BundleException e) {
                    DocumentNodeStoreService.this.log.error("handleLeaseFailure: exception while stopping " + bundleName + ": " + e, (Throwable)e);
                    DocumentNodeStoreService.this.log.error("handleLeaseFailure: stopping DocumentNodeStoreService...");
                    DocumentNodeStoreService.this.context.disableComponent(DocumentNodeStoreService.class.getName());
                    DocumentNodeStoreService.this.log.error("handleLeaseFailure: stopped DocumentNodeStoreService");
                }
            }
        };
    }

    private void configureBuilder(DocumentNodeStoreBuilder<?> builder) {
        String persistentCache = this.resolvePath(this.config.persistentCache(), DEFAULT_PERSISTENT_CACHE);
        String journalCache = this.resolvePath(this.config.journalCache(), DEFAULT_JOURNAL_CACHE);
        final Tracker leaseFailureHandlerTracker = this.whiteboard.track(LeaseFailureHandler.class);
        ((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)((DocumentNodeStoreBuilder)builder.setStatisticsProvider(this.statisticsProvider)).setExecutor((Executor)this.executor)).memoryCacheSize((long)this.config.cache() * 0x100000L)).memoryCacheDistribution(this.config.nodeCachePercentage(), this.config.prevDocCachePercentage(), this.config.childrenCachePercentage(), this.config.diffCachePercentage())).setCacheSegmentCount(this.config.cacheSegmentCount())).setCacheStackMoveDistance(this.config.cacheStackMoveDistance())).setBundlingDisabled(this.config.bundlingDisabled())).setJournalPropertyHandlerFactory(this.journalPropertyHandlerFactory)).setLeaseCheckMode(ClusterNodeInfo.DEFAULT_LEASE_CHECK_DISABLED ? LeaseCheckMode.DISABLED : LeaseCheckMode.valueOf(this.config.leaseCheckMode()))).setPrefetchFeature(this.prefetchFeature)).setDocStoreThrottlingFeature(this.docStoreThrottlingFeature)).setThrottlingEnabled(this.config.throttlingEnabled())).setSuspendTimeoutMillis(this.config.suspendTimeoutMillis())).setLeaseFailureHandler(new LeaseFailureHandler(){
            private final LeaseFailureHandler defaultLeaseFailureHandler;
            {
                this.defaultLeaseFailureHandler = DocumentNodeStoreService.this.createDefaultLeaseFailureHandler();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleLeaseFailure() {
                block5: {
                    boolean handled = false;
                    try {
                        List handlers;
                        if (leaseFailureHandlerTracker == null || (handlers = leaseFailureHandlerTracker.getServices()) == null || handlers.size() <= 0) break block5;
                        for (LeaseFailureHandler handler : handlers) {
                            if (handler == null) continue;
                            DocumentNodeStoreService.this.log.info("handleLeaseFailure: invoking handler " + handler);
                            handler.handleLeaseFailure();
                            handled = true;
                            break;
                        }
                    }
                    finally {
                        if (!handled) {
                            DocumentNodeStoreService.this.log.info("handleLeaseFailure: invoking default handler");
                            this.defaultLeaseFailureHandler.handleLeaseFailure();
                        }
                    }
                }
            }
        })).setPrefetchExternalChanges(this.config.prefetchExternalChanges())).setUpdateLimit(this.config.updateLimit())).setJournalGCMaxAge(this.config.journalGCMaxAge())).setNodeCachePathPredicate(this.createCachePredicate());
        if (!Strings.isNullOrEmpty((String)persistentCache)) {
            builder.setPersistentCache(persistentCache);
        }
        if (!Strings.isNullOrEmpty((String)journalCache)) {
            builder.setJournalCache(journalCache);
        }
        if (this.customBlobStore && !this.isWrappingCustomBlobStore()) {
            Preconditions.checkNotNull((Object)this.blobStore, (String)"Use of custom BlobStore enabled via  [%s] but blobStore reference not initialized", (Object)CUSTOM_BLOB_STORE);
            builder.setBlobStore(this.blobStore);
        }
        if (Utils.isThrottlingEnabled(builder)) {
            builder.setThrottlingStatsCollector(new ThrottlingStatsCollectorImpl(this.statisticsProvider));
        }
    }

    private boolean isWrappingCustomBlobStore() {
        return this.customBlobStore && this.blobStore instanceof BlobStoreWrapper;
    }

    private Predicate<Path> createCachePredicate() {
        if (this.config.persistentCacheIncludes().length == 0) {
            return Predicates.alwaysTrue();
        }
        if (Arrays.equals(this.config.persistentCacheIncludes(), new String[]{"/"})) {
            return Predicates.alwaysTrue();
        }
        HashSet<Path> paths = new HashSet<Path>();
        for (String p : this.config.persistentCacheIncludes()) {
            String string = p = p != null ? Strings.emptyToNull((String)p.trim()) : null;
            if (p == null) continue;
            paths.add(Path.fromString(p));
        }
        this.log.info("Configuring persistent cache to only cache nodes under paths {}", paths);
        return input -> {
            if (input != null) {
                for (Path p : paths) {
                    if (!p.isAncestorOf((Path)input)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    private boolean isNodeStoreProvider() {
        return !Strings.isNullOrEmpty((String)this.config.role());
    }

    private boolean isContinuousRevisionGC() {
        String expr = this.getVersionGCExpression();
        String[] elements = expr.split("\\s");
        return elements.length >= 6 && elements[1].equals("*");
    }

    private String getVersionGCExpression() {
        String defaultExpr = CONTINUOUS_RGC_EXPR;
        String expr = this.config.versionGCExpression();
        if (Strings.isNullOrEmpty((String)expr)) {
            expr = defaultExpr;
        }
        try {
            if (!expr.isEmpty()) {
                new CronExpression(expr);
            }
        }
        catch (ParseException e) {
            this.log.warn("Invalid cron expression, falling back to default '" + defaultExpr + "'", (Throwable)e);
            expr = defaultExpr;
        }
        return expr;
    }

    private void registerNodeStoreProvider(NodeStore ns) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("role", this.config.role());
        this.nodeStoreReg = this.context.getBundleContext().registerService(NodeStoreProvider.class.getName(), () -> ns, props);
        this.log.info("Registered NodeStoreProvider backed by DocumentNodeStore");
    }

    @Deactivate
    protected void deactivate() {
        if (this.observerTracker != null) {
            this.observerTracker.stop();
        }
        if (this.journalPropertyHandlerFactory != null) {
            this.journalPropertyHandlerFactory.stop();
        }
        if (this.prefetchFeature != null) {
            this.prefetchFeature.close();
        }
        if (this.docStoreThrottlingFeature != null) {
            this.docStoreThrottlingFeature.close();
        }
        this.unregisterNodeStore();
    }

    @Reference(name="blobStore", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, target="(&(!(split.blobstore=old))(!(split.blobstore=new)))")
    protected void bindBlobStore(BlobStore blobStore) throws IOException {
        if (this.defaultBlobStore == blobStore) {
            return;
        }
        this.log.info("Initializing DocumentNodeStore with BlobStore [{}]", (Object)blobStore);
        this.blobStore = blobStore;
        this.registerNodeStoreIfPossible();
    }

    protected void unbindBlobStore(BlobStore blobStore) {
        if (this.defaultBlobStore == blobStore) {
            return;
        }
        this.blobStore = null;
        this.unregisterNodeStore();
    }

    @Reference(name="dataSource", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, target="(datasource.name=oak)")
    protected void bindDataSource(DataSource dataSource) throws IOException {
        if (this.dataSource != null) {
            this.log.info("Ignoring bindDataSource [{}] because dataSource [{}] is already bound", (Object)dataSource, (Object)this.dataSource);
        } else {
            this.log.info("Initializing DocumentNodeStore with dataSource [{}]", (Object)dataSource);
            this.dataSource = dataSource;
            this.registerNodeStoreIfPossible();
        }
    }

    protected void unbindDataSource(DataSource dataSource) {
        if (this.dataSource != dataSource) {
            this.log.info("Ignoring unbindDataSource [{}] because dataSource is bound to [{}]", (Object)dataSource, (Object)this.dataSource);
        } else {
            this.log.info("Unregistering DocumentNodeStore because dataSource [{}] was unbound", (Object)dataSource);
            this.dataSource = null;
            this.unregisterNodeStore();
        }
    }

    @Reference(name="blobDataSource", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, target="(datasource.name=oak)")
    protected void bindBlobDataSource(DataSource dataSource) throws IOException {
        if (this.blobDataSource != null) {
            this.log.info("Ignoring bindBlobDataSource [{}] because blobDataSource [{}] is already bound", (Object)dataSource, (Object)this.blobDataSource);
        } else {
            this.log.info("Initializing DocumentNodeStore with blobDataSource [{}]", (Object)dataSource);
            this.blobDataSource = dataSource;
            this.registerNodeStoreIfPossible();
        }
    }

    protected void unbindBlobDataSource(DataSource dataSource) {
        if (this.blobDataSource != dataSource) {
            this.log.info("Ignoring unbindBlobDataSource [{}] because dataSource is bound to [{}]", (Object)dataSource, (Object)this.blobDataSource);
        } else {
            this.log.info("Unregistering DocumentNodeStore because blobDataSource [{}] was unbound", (Object)dataSource);
            this.blobDataSource = null;
            this.unregisterNodeStore();
        }
    }

    @Reference(name="nodeStateCache", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void bindNodeStateCache(DocumentNodeStateCache nodeStateCache) throws IOException {
        if (this.nodeStore != null) {
            this.log.info("Registered DocumentNodeStateCache [{}] with DocumentNodeStore", (Object)nodeStateCache);
            this.nodeStore.setNodeStateCache(nodeStateCache);
        }
    }

    protected void unbindNodeStateCache(DocumentNodeStateCache nodeStateCache) {
        if (this.nodeStore != null) {
            this.nodeStore.setNodeStateCache(DocumentNodeStateCache.NOOP);
        }
    }

    private void unregisterNodeStore() {
        this.deactivationTimestamp = System.currentTimeMillis();
        IOUtils.closeQuietly((Closeable)this.closer);
        if (this.nodeStoreReg != null) {
            this.nodeStoreReg.unregister();
            this.nodeStoreReg = null;
        }
        if (this.blobStoreReg != null) {
            this.blobStoreReg.unregister();
            this.blobStoreReg = null;
        }
        if (this.nodeStore != null) {
            this.nodeStore.dispose();
            this.nodeStore = null;
        }
        if (this.executor != null) {
            this.executor.stop();
            this.executor = null;
        }
    }

    private void registerJMXBeans(DocumentNodeStore store, DocumentNodeStoreBuilder<?> mkBuilder) throws IOException {
        this.registerCacheStatsMBean(store.getNodeCacheStats());
        this.registerCacheStatsMBean(store.getNodeChildrenCacheStats());
        for (CacheStats cacheStats : store.getDiffCacheStats()) {
            this.registerCacheStatsMBean(cacheStats);
        }
        DocumentStore ds = store.getDocumentStore();
        if (ds.getCacheStats() != null) {
            for (CacheStats cacheStats : ds.getCacheStats()) {
                this.registerCacheStatsMBean(cacheStats);
            }
        }
        if (!this.isNodeStoreProvider()) {
            this.addRegistration(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, CheckpointMBean.class, (Object)((Object)new DocumentCheckpointMBean(store)), (String)"CheckpointManager", (String)"Document node store checkpoint management"));
        }
        this.addRegistration(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, DocumentNodeStoreMBean.class, (Object)store.getMBean(), (String)"DocumentNodeStore", (String)"Document node store management"));
        if (mkBuilder.getBlobStoreCacheStats() != null) {
            this.registerCacheStatsMBean(mkBuilder.getBlobStoreCacheStats());
        }
        if (mkBuilder.getDocumentStoreStatsCollector() instanceof DocumentStoreStatsMBean) {
            this.addRegistration(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, DocumentStoreStatsMBean.class, (Object)((DocumentStoreStatsMBean)((Object)mkBuilder.getDocumentStoreStatsCollector())), (String)"DocumentStoreStats", (String)"DocumentStore Statistics"));
        }
        Map<String, PersistentCacheStats> map = mkBuilder.getPersistenceCacheStats();
        for (PersistentCacheStats pcs : map.values()) {
            this.addRegistration(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, PersistentCacheStatsMBean.class, (Object)((Object)pcs), (String)"PersistentCacheStats", (String)pcs.getName()));
        }
        long l = this.config.versionGcMaxAgeInSecs();
        long blobGcMaxAgeInSecs = this.config.blobGcMaxAgeInSecs();
        if (store.getBlobStore() instanceof GarbageCollectableBlobStore) {
            MarkSweepGarbageCollector gc = store.createBlobGarbageCollector(blobGcMaxAgeInSecs, ClusterRepositoryInfo.getOrCreateId((NodeStore)this.nodeStore), this.whiteboard, this.statisticsProvider);
            this.addRegistration(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, BlobGCMBean.class, (Object)new BlobGC((BlobGarbageCollector)gc, (Executor)this.executor), (String)"BlobGarbageCollection", (String)"Document node store blob garbage collection"));
        }
        RevisionGCJob startGC = new RevisionGCJob(store, l, 0L, 0.0);
        Runnable cancelGC = () -> store.getVersionGarbageCollector().cancel();
        Supplier<String> status = () -> store.getVersionGarbageCollector().getStatus();
        RevisionGC revisionGC = new RevisionGC((Runnable)startGC, cancelGC, status, (Executor)this.executor);
        this.addRegistration(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, RevisionGCMBean.class, (Object)revisionGC, (String)"RevisionGarbageCollection", (String)"Document node store revision garbage collection"));
        this.addRegistration(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, RevisionGCStatsMBean.class, (Object)store.getVersionGarbageCollector().getRevisionGCStats(), (String)"RevisionGCStats", (String)"Document node store revision garbage collection statistics"));
        BlobStoreStats blobStoreStats = mkBuilder.getBlobStoreStats();
        if (!this.customBlobStore && blobStoreStats != null) {
            this.addRegistration(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, BlobStoreStatsMBean.class, (Object)blobStoreStats, (String)"BlobStoreStats", (String)ds.getClass().getSimpleName()));
        }
        if (!mkBuilder.isBundlingDisabled()) {
            this.addRegistration(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, BackgroundObserverMBean.class, (Object)store.getBundlingConfigHandler().getMBean(), (String)"BackgroundObserverStats", (String)"BundlingConfigObserver"));
        }
    }

    private void registerCacheStatsMBean(CacheStats cacheStats) {
        this.addRegistration(WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, CacheStatsMBean.class, (Object)cacheStats, (String)"CacheStats", (String)cacheStats.getName()));
    }

    private void registerLastRevRecoveryJob(DocumentNodeStore nodeStore) {
        long leaseTime = PropertiesUtil.toLong(this.context.getProperties().get(PROP_REV_RECOVERY_INTERVAL), (long)10000L);
        this.addRegistration(WhiteboardUtils.scheduleWithFixedDelay((Whiteboard)this.whiteboard, (Runnable)new LastRevRecoveryJob(nodeStore), (long)TimeUnit.MILLISECONDS.toSeconds(leaseTime), (boolean)false, (boolean)true));
    }

    private void registerJournalGC(DocumentNodeStore nodeStore) {
        this.addRegistration(WhiteboardUtils.scheduleWithFixedDelay((Whiteboard)this.whiteboard, (Runnable)new JournalGCJob(nodeStore), DocumentNodeStoreService.jobPropertiesFor(JournalGCJob.class), (long)TimeUnit.MILLISECONDS.toSeconds(this.config.journalGCInterval()), (boolean)true, (boolean)true));
    }

    private void registerVersionGCJob(DocumentNodeStore nodeStore) {
        String expr = this.getVersionGCExpression();
        if (expr.isEmpty()) {
            return;
        }
        Map<String, Object> props = DocumentNodeStoreService.jobPropertiesFor(RevisionGCJob.class);
        props.put("scheduler.expression", expr);
        long versionGcMaxAgeInSecs = this.config.versionGcMaxAgeInSecs();
        long versionGCTimeLimitInSecs = this.config.versionGCTimeLimitInSecs();
        double versionGCDelayFactor = this.config.versionGCDelayFactor();
        this.addRegistration(WhiteboardUtils.scheduleWithFixedDelay((Whiteboard)this.whiteboard, (Runnable)new RevisionGCJob(nodeStore, versionGcMaxAgeInSecs, versionGCTimeLimitInSecs, versionGCDelayFactor), props, (long)5L, (boolean)true, (boolean)true));
    }

    private void registerDocumentStoreMetrics(DocumentStore store) {
        if (store instanceof MongoDocumentStore) {
            this.addRegistration(WhiteboardUtils.scheduleWithFixedDelay((Whiteboard)this.whiteboard, (Runnable)new MongoDocumentStoreMetrics((MongoDocumentStore)store, this.statisticsProvider), DocumentNodeStoreService.jobPropertiesFor(MongoDocumentStoreMetrics.class), (long)TimeUnit.MINUTES.toSeconds(1L), (boolean)false, (boolean)true));
        }
    }

    private String resolvePath(String value, String defaultValue) {
        String path = value;
        if (Strings.isNullOrEmpty((String)value)) {
            path = defaultValue;
        }
        if ("-".equals(path)) {
            return DEFAULT_VER_GC_EXPRESSION;
        }
        return FilenameUtils.concat((String)this.getRepositoryHome(), (String)path);
    }

    private String getRepositoryHome() {
        String repoHome = this.config.repository_home();
        if (Strings.isNullOrEmpty((String)repoHome)) {
            repoHome = DEFAULT_PROP_HOME;
        }
        return repoHome;
    }

    private static String[] getMetadata(DocumentStore ds) {
        HashMap<String, String> meta = new HashMap<String, String>(ds.getMetadata());
        meta.put("nodeStoreType", "document");
        String[] result = new String[meta.size()];
        int i = 0;
        for (Map.Entry e : meta.entrySet()) {
            result[i++] = (String)e.getKey() + "=" + (String)e.getValue();
        }
        return result;
    }

    private void addRegistration(@NotNull Registration reg) {
        this.closer.register(DocumentNodeStoreService.asCloseable(reg));
    }

    private static Closeable asCloseable(final @NotNull Registration reg) {
        Preconditions.checkNotNull((Object)reg);
        return new Closeable(){

            @Override
            public void close() throws IOException {
                reg.unregister();
            }
        };
    }

    private static Closeable asCloseable(final @NotNull AbstractServiceTracker t) {
        Preconditions.checkNotNull((Object)t);
        return new Closeable(){

            @Override
            public void close() throws IOException {
                t.stop();
            }
        };
    }

    private static Map<String, Object> jobPropertiesFor(Class clazz) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("scheduler.name", clazz.getName());
        return props;
    }

    @Component(service={Preset.class}, configurationPid={"org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreServicePreset"})
    public static class Preset {
        Configuration configuration;

        @Activate
        void activate(Configuration configuration) {
            this.configuration = configuration;
        }
    }

    private static final class LastRevRecoveryJob
    implements Runnable {
        private final DocumentNodeStore nodeStore;

        LastRevRecoveryJob(DocumentNodeStore ns) {
            this.nodeStore = ns;
        }

        @Override
        public void run() {
            this.nodeStore.getLastRevRecoveryAgent().performRecoveryIfNeeded();
        }
    }

    private static final class JournalGCJob
    implements Runnable {
        private final DocumentNodeStore nodeStore;

        JournalGCJob(DocumentNodeStore ns) {
            this.nodeStore = ns;
        }

        @Override
        public void run() {
            this.nodeStore.getJournalGarbageCollector().gc();
        }
    }

    static final class RevisionGCJob
    implements Runnable,
    Supplier<String> {
        private static final Logger LOGGER = LoggerFactory.getLogger(VersionGarbageCollector.class);
        private static final long LOG_INTERVAL = TimeUnit.HOURS.toMillis(1L);
        private final DocumentNodeStore nodeStore;
        private final long versionGCMaxAgeInSecs;
        private final long versionGCTimeLimitInSecs;
        private final double versionGCDelayFactor;
        private volatile Object lastResult = "";
        private long lastLogTime;
        private VersionGarbageCollector.VersionGCStats stats;

        RevisionGCJob(DocumentNodeStore ns, long versionGcMaxAgeInSecs, long versionGCTimeLimitInSecs, double versionGCDelayFactor) {
            this.nodeStore = ns;
            this.versionGCMaxAgeInSecs = versionGcMaxAgeInSecs;
            this.versionGCTimeLimitInSecs = versionGCTimeLimitInSecs;
            this.versionGCDelayFactor = versionGCDelayFactor;
            this.resetStats();
        }

        @Override
        public void run() {
            VersionGarbageCollector gc = this.nodeStore.getVersionGarbageCollector();
            gc.setOptions(gc.getOptions().withMaxDuration(TimeUnit.SECONDS, this.versionGCTimeLimitInSecs).withDelayFactor(this.versionGCDelayFactor));
            try {
                VersionGarbageCollector.VersionGCStats s = gc.gc(this.versionGCMaxAgeInSecs, TimeUnit.SECONDS);
                this.stats.addRun(s);
                this.lastResult = s.toString();
            }
            catch (Exception e) {
                this.lastResult = e;
                LOGGER.warn("Error occurred while executing the Version Garbage Collector", (Throwable)e);
            }
            finally {
                this.maybeLogStats();
            }
        }

        @Override
        public String get() throws UncheckedExecutionException {
            if (this.lastResult instanceof Exception) {
                throw new UncheckedExecutionException((Throwable)((Exception)this.lastResult));
            }
            return String.valueOf(this.lastResult);
        }

        private void resetStats() {
            this.lastLogTime = this.nodeStore.getClock().getTime();
            this.stats = new VersionGarbageCollector.VersionGCStats();
        }

        private void maybeLogStats() {
            if (this.nodeStore.getClock().getTime() > this.lastLogTime + LOG_INTERVAL) {
                LOGGER.info("Garbage collector stats since {}: {}", (Object)Utils.timestampToString(this.lastLogTime), (Object)this.stats);
                this.resetStats();
            }
        }
    }

    private static enum DocumentStoreType {
        MONGO,
        RDB;


        static DocumentStoreType fromString(String type) {
            if (type == null) {
                return MONGO;
            }
            return DocumentStoreType.valueOf(type.toUpperCase(Locale.ROOT));
        }
    }
}

