/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.bundlor;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.bundlor.Matcher;
import org.apache.jackrabbit.oak.plugins.document.bundlor.PropertyStateWrapper;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public final class BundlorUtils {
    public static final Predicate<PropertyState> NOT_BUNDLOR_PROPS = new Predicate<PropertyState>(){

        public boolean apply(PropertyState input) {
            return !input.getName().startsWith(":doc-");
        }
    };

    public static Map<String, PropertyState> getMatchingProperties(Map<String, PropertyState> props, Matcher matcher) {
        if (!matcher.isMatch()) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, PropertyState> e : props.entrySet()) {
            String propertyPath = e.getKey();
            int depth = PathUtils.getDepth((String)propertyPath) - 1;
            if (!propertyPath.startsWith(matcher.getMatchedPath()) || depth != matcher.depth()) continue;
            final String newKey = PathUtils.getName((String)propertyPath);
            PropertyState value = e.getValue();
            if (depth > 0) {
                value = new PropertyStateWrapper(value){

                    @Override
                    @NotNull
                    public String getName() {
                        return newKey;
                    }
                };
            }
            result.put(newKey, value);
        }
        return result;
    }

    public static Set<String> getChildNodeNames(Collection<String> keys, Matcher matcher) {
        HashSet childNodeNames = Sets.newHashSet();
        int expectedDepth = matcher.depth() + 1;
        for (String key : keys) {
            ImmutableList elements = ImmutableList.copyOf((Iterable)PathUtils.elements((String)key));
            int depth = elements.size() - 1;
            if (depth != expectedDepth || !key.startsWith(matcher.getMatchedPath()) || !((String)elements.get(elements.size() - 1)).equals(":doc-self-path")) continue;
            childNodeNames.add((String)elements.get(elements.size() - 2));
        }
        return childNodeNames;
    }

    static boolean isBundlingRoot(NodeState state) {
        return state.hasProperty(":doc-pattern");
    }

    static boolean isBundledChild(NodeState state) {
        return state.hasProperty(":doc-self-path");
    }

    static boolean isBundledNode(NodeState state) {
        return BundlorUtils.isBundlingRoot(state) || BundlorUtils.isBundledChild(state);
    }
}

