/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.bundlor;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.bundlor.BundlorUtils;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;

public class BundledDocumentDiffer {
    private final DocumentNodeStore nodeStore;

    public BundledDocumentDiffer(DocumentNodeStore nodeStore) {
        this.nodeStore = nodeStore;
    }

    public boolean diff(AbstractDocumentNodeState from, AbstractDocumentNodeState to, JsopWriter w) {
        boolean fromBundled = BundlorUtils.isBundledNode((NodeState)from);
        boolean toBundled = BundlorUtils.isBundledNode((NodeState)to);
        if (!fromBundled && !toBundled) {
            return true;
        }
        DocumentNodeState fromDocState = this.getDocumentNodeState(from);
        DocumentNodeState toDocState = this.getDocumentNodeState(to);
        this.diffChildren(fromDocState.getBundledChildNodeNames(), toDocState.getBundledChildNodeNames(), w);
        return !fromDocState.hasOnlyBundledChildren() || !toDocState.hasOnlyBundledChildren();
    }

    void diffChildren(Collection<String> fromChildren, Collection<String> toChildren, JsopWriter w) {
        for (String n : fromChildren) {
            if (!toChildren.contains(n)) {
                w.tag('-').value(n);
                continue;
            }
            w.tag('^').key(n).object().endObject();
        }
        for (String n : toChildren) {
            if (fromChildren.contains(n)) continue;
            w.tag('+').key(n).object().endObject();
        }
    }

    private DocumentNodeState getDocumentNodeState(AbstractDocumentNodeState state) {
        DocumentNodeState result;
        if (state instanceof DocumentNodeState) {
            result = (DocumentNodeState)state;
        } else if (BundlorUtils.isBundledChild((NodeState)state)) {
            Preconditions.checkState((boolean)BundlorUtils.isBundledChild((NodeState)state));
            String bundlingPath = state.getString(":doc-self-path");
            Path bundlingRootPath = state.getPath().getAncestor(PathUtils.getDepth((String)bundlingPath));
            DocumentNodeState bundlingRoot = this.nodeStore.getNode(bundlingRootPath, state.getLastRevision());
            result = (DocumentNodeState)NodeStateUtils.getNode((NodeState)bundlingRoot, (String)bundlingPath);
        } else {
            result = this.nodeStore.getNode(state.getPath(), state.getLastRevision());
        }
        Preconditions.checkNotNull((Object)((Object)result), (String)"Node at [%s] not found for fromRev [%s]", (Object[])new Object[]{state.getPath(), state.getLastRevision()});
        return result;
    }
}

