/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.jackrabbit.oak.plugins.document.BatchCommitQueue;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BatchCommit {
    private static final Logger LOG = LoggerFactory.getLogger(BatchCommit.class);
    private final CountDownLatch finished = new CountDownLatch(1);
    private final String id;
    private final BatchCommitQueue queue;
    private List<UpdateOp> ops;
    private List<Future<NodeDocument>> results;
    private boolean executing;

    BatchCommit(String id, BatchCommitQueue queue, boolean onHold) {
        this.id = id;
        this.queue = queue;
        if (onHold) {
            this.ops = Lists.newArrayList();
            this.results = Lists.newArrayList();
        }
    }

    String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Callable<NodeDocument> enqueue(final UpdateOp op) {
        Callable<NodeDocument> result;
        Preconditions.checkArgument((boolean)op.getId().equals(this.id), (String)"Cannot add UpdateOp with id %s to BatchCommit with id %s", (Object[])new Object[]{op.getId(), this.id});
        BatchCommit batchCommit = this;
        synchronized (batchCommit) {
            Preconditions.checkState((!this.executing ? 1 : 0) != 0, (Object)"Cannot enqueue when batch is already executing");
            if (this.ops != null) {
                this.ops.add(op);
                result = new Callable<NodeDocument>(){
                    int idx;
                    {
                        this.idx = BatchCommit.this.ops.size() - 1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public NodeDocument call() throws Exception {
                        BatchCommit batchCommit = BatchCommit.this;
                        synchronized (batchCommit) {
                            while (!BatchCommit.this.executing) {
                                LOG.debug("Waiting until BatchCommit is executing. {}", (Object)BatchCommit.this.id);
                                BatchCommit.this.wait();
                            }
                        }
                        try {
                            return BatchCommit.this.execute(this.idx).get();
                        }
                        catch (ExecutionException e) {
                            throw DocumentStoreException.convert(e.getCause());
                        }
                    }
                };
            } else {
                this.executing = true;
                result = new Callable<NodeDocument>(){

                    @Override
                    public NodeDocument call() throws Exception {
                        try {
                            NodeDocument nodeDocument = BatchCommit.this.queue.getStore().findAndUpdate(Collection.NODES, op);
                            return nodeDocument;
                        }
                        finally {
                            BatchCommit.this.queue.finished(BatchCommit.this);
                        }
                    }
                };
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        BatchCommit batchCommit = this;
        synchronized (batchCommit) {
            this.executing = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<NodeDocument> execute(int idx) {
        if (idx == 0) {
            NodeDocument before = null;
            try {
                UpdateOp combined = UpdateOp.combine(this.id, this.ops);
                LOG.debug("Batch committing {} updates", (Object)this.ops.size());
                before = this.queue.getStore().findAndUpdate(Collection.NODES, combined);
            }
            catch (Throwable t) {
                LOG.warn("BatchCommit failed, will retry individually. " + t.getMessage());
            }
            finally {
                this.queue.finished(this);
            }
            try {
                if (before == null) {
                    this.executeIndividually();
                }
                this.populateResults(before);
            }
            finally {
                this.finished.countDown();
            }
        } else {
            try {
                this.finished.await();
            }
            catch (InterruptedException e) {
                String msg = "Interrupted while waiting for batch commit to finish";
                return Futures.immediateFailedFuture((Throwable)new DocumentStoreException(msg));
            }
        }
        return this.results.get(idx);
    }

    void executeIndividually() {
        DocumentStore store = this.queue.getStore();
        for (UpdateOp op : this.ops) {
            SettableFuture result = SettableFuture.create();
            try {
                result.set((Object)store.findAndUpdate(Collection.NODES, op));
            }
            catch (Throwable t) {
                result.setException(t);
            }
            this.results.add((Future<NodeDocument>)result);
        }
    }

    void populateResults(NodeDocument before) {
        DocumentStore store = this.queue.getStore();
        for (UpdateOp op : this.ops) {
            this.results.add((Future<NodeDocument>)Futures.immediateFuture((Object)before));
            NodeDocument after = new NodeDocument(store);
            before.deepCopy(after);
            UpdateUtils.applyChanges(after, op);
            before = after;
        }
    }
}

