/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

public class TimeInterval {
    public final long fromMs;
    public final long toMs;

    public TimeInterval(long fromMs, long toMs) {
        Preconditions.checkArgument((fromMs <= toMs ? 1 : 0) != 0, (Object)"start must be <= end");
        this.fromMs = fromMs;
        this.toMs = toMs;
    }

    public TimeInterval notLaterThan(long timestampMs) {
        if (timestampMs < this.toMs) {
            return new TimeInterval(timestampMs < this.fromMs ? timestampMs : this.fromMs, timestampMs);
        }
        return this;
    }

    public TimeInterval notEarlierThan(long timestampMs) {
        if (this.fromMs < timestampMs) {
            return new TimeInterval(timestampMs, timestampMs > this.toMs ? timestampMs : this.toMs);
        }
        return this;
    }

    public TimeInterval startAndDuration(long durationMs) {
        return new TimeInterval(this.fromMs, this.fromMs + durationMs);
    }

    public long getDurationMs() {
        return this.toMs - this.fromMs;
    }

    public boolean contains(long timestampMs) {
        return this.fromMs <= timestampMs && timestampMs <= this.toMs;
    }

    public boolean endsAfter(long timestampMs) {
        return this.toMs > timestampMs;
    }

    public boolean equals(Object o) {
        if (o instanceof TimeInterval && o != null) {
            return this.fromMs == ((TimeInterval)o).fromMs && this.toMs == ((TimeInterval)o).toMs;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.fromMs ^ this.fromMs >>> 32 ^ this.toMs ^ this.toMs >>> 32);
    }

    public String toString() {
        return "[" + Utils.timestampToString(this.fromMs) + ", " + Utils.timestampToString(this.toMs) + "]";
    }
}

