/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.bundlor;

import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.bundlor.Include;
import org.apache.jackrabbit.oak.plugins.document.bundlor.IncludeAllMatcher;
import org.apache.jackrabbit.oak.plugins.document.bundlor.Matcher;

class IncludeMatcher
implements Matcher {
    private final Include include;
    private final int depth;
    private final String matchedPath;

    public IncludeMatcher(Include include) {
        this(include, 0, "");
    }

    private IncludeMatcher(Include include, int depth, String matchedPath) {
        this.include = include;
        this.depth = depth;
        this.matchedPath = matchedPath;
    }

    @Override
    public Matcher next(String name) {
        if (this.hasMore()) {
            if (this.include.match(name, this.nextElementIndex())) {
                String nextPath = PathUtils.concat((String)this.matchedPath, (String)name);
                if (this.lastEntry() && this.include.getDirective() == Include.Directive.ALL) {
                    return new IncludeAllMatcher(nextPath, this.nextElementIndex());
                }
                return new IncludeMatcher(this.include, this.nextElementIndex(), nextPath);
            }
            return Matcher.NON_MATCHING;
        }
        return Matcher.NON_MATCHING;
    }

    @Override
    public boolean isMatch() {
        return true;
    }

    @Override
    public String getMatchedPath() {
        return this.matchedPath;
    }

    @Override
    public int depth() {
        return this.depth;
    }

    @Override
    public boolean matchesAllChildren() {
        if (this.hasMore()) {
            return this.include.matchAny(this.nextElementIndex());
        }
        return false;
    }

    public String toString() {
        return "IncludeMatcher{include=" + this.include + ", depth=" + this.depth + ", matchedPath='" + this.matchedPath + '\'' + '}';
    }

    private int nextElementIndex() {
        return this.depth + 1;
    }

    private boolean hasMore() {
        return this.depth < this.include.size();
    }

    private boolean lastEntry() {
        return this.depth == this.include.size() - 1;
    }
}

