/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache;

public class PersistentCachePreloadingConfiguration {
    private final int concurrency;
    private int maxPreloadDepth;

    private PersistentCachePreloadingConfiguration(int concurrency, int preloadDepth) {
        this.concurrency = concurrency;
        this.maxPreloadDepth = preloadDepth;
    }

    public static PersistentCachePreloadingConfiguration withConcurrency(int concurrency) {
        return new PersistentCachePreloadingConfiguration(concurrency, 1);
    }

    public PersistentCachePreloadingConfiguration withMaxPreloadDepth(int maxPreloadDepth) {
        this.maxPreloadDepth = maxPreloadDepth;
        return this;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public int getMaxPreloadDepth() {
        return this.maxPreloadDepth;
    }

    public String toString() {
        return "PersistentCachePreloadingConfiguration{concurrency=" + this.concurrency + ", maxPreloadDepth=" + this.maxPreloadDepth + "}";
    }
}

