/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.segment.ClassicCompactor;
import org.apache.jackrabbit.oak.segment.Compactor;
import org.apache.jackrabbit.oak.segment.CompactorUtils;
import org.apache.jackrabbit.oak.segment.file.CompactedNodeState;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckpointCompactor
extends Compactor {
    @NotNull
    protected final GCMonitor gcListener;
    @NotNull
    private final Map<NodeState, CompactedNodeState> cpCache = new HashMap<NodeState, CompactedNodeState>();
    @NotNull
    protected final ClassicCompactor compactor;

    public CheckpointCompactor(@NotNull GCMonitor gcListener, @NotNull ClassicCompactor compactor) {
        this.gcListener = gcListener;
        this.compactor = compactor;
    }

    @Override
    @Nullable
    public CompactedNodeState compactDown(@NotNull NodeState before, @NotNull NodeState after, @NotNull Canceller hardCanceller, @NotNull Canceller softCanceller) throws IOException {
        return this.doCompact(before, after, after, hardCanceller, softCanceller);
    }

    @Override
    @Nullable
    public CompactedNodeState compact(@NotNull NodeState before, @NotNull NodeState after, @NotNull NodeState onto, @NotNull Canceller canceller) throws IOException {
        return this.doCompact(before, after, onto, canceller, null);
    }

    @Nullable
    private CompactedNodeState doCompact(@NotNull NodeState before, @NotNull NodeState after, @NotNull NodeState onto, @NotNull Canceller hardCanceller, @Nullable Canceller softCanceller) throws IOException {
        Validate.checkArgument((softCanceller == null || Objects.equals(after, onto) ? 1 : 0) != 0, (String)"softCanceller is only supported for compactDown, i.e. when Objects.equals(after, onto)");
        LinkedHashSet<String> superRoots = this.collectSuperRootPaths(before, after);
        Buffer stableIdBytes = Objects.requireNonNull(CompactorUtils.getStableIdBytes(after));
        NodeBuilder rootBuilder = onto.builder();
        CompactedNodeState compacted = null;
        for (String path : superRoots) {
            NodeBuilder builder = CheckpointCompactor.getDescendant(rootBuilder, path, NodeBuilder::child);
            NodeState afterSuperRoot = CheckpointCompactor.getDescendant(after, path, NodeState::getChildNode);
            NodeState baseRoot = Objects.requireNonNullElseGet(compacted, () -> CheckpointCompactor.getRoot(CheckpointCompactor.getDescendant(before, path, NodeState::getChildNode)));
            NodeState ontoRoot = Objects.requireNonNullElseGet(compacted, () -> CheckpointCompactor.getRoot(CheckpointCompactor.getDescendant(onto, path, NodeState::getChildNode)));
            compacted = this.compactRootState(baseRoot, CheckpointCompactor.getRoot(afterSuperRoot), ontoRoot, hardCanceller, softCanceller);
            if (compacted == null) {
                return null;
            }
            Validate.checkState((compacted.isComplete() || CheckpointCompactor.isCancelled(softCanceller) ? 1 : 0) != 0, (Object)"compaction must be complete unless cancelled");
            builder.setChildNode("root", (NodeState)compacted);
            if (path.startsWith("checkpoints/")) {
                this.compactCheckpointMetadata(builder, afterSuperRoot);
            }
            if (!CheckpointCompactor.isCancelled(softCanceller)) continue;
            break;
        }
        return this.compactor.writeNodeState(rootBuilder.getNodeState(), stableIdBytes, !CheckpointCompactor.isCancelled(softCanceller));
    }

    @Nullable
    private CompactedNodeState compactRootState(@NotNull NodeState baseRoot, @NotNull NodeState afterRoot, @NotNull NodeState ontoRoot, @NotNull Canceller hardCanceller, @Nullable Canceller softCanceller) throws IOException {
        if (Objects.equals(ontoRoot, afterRoot)) {
            return this.compactWithCache(baseRoot, afterRoot, ontoRoot, hardCanceller, softCanceller);
        }
        return this.compactWithCache(baseRoot, afterRoot, ontoRoot, hardCanceller, null);
    }

    private void compactCheckpointMetadata(NodeBuilder builder, NodeState afterSuperRoot) {
        NodeBuilder props = builder.setChildNode("properties");
        for (PropertyState properties : afterSuperRoot.getChildNode("properties").getProperties()) {
            props.setProperty(this.compactor.compact(properties));
        }
        for (PropertyState property : afterSuperRoot.getProperties()) {
            builder.setProperty(this.compactor.compact(property));
        }
    }

    private static boolean isCancelled(@Nullable Canceller softCanceller) {
        return softCanceller != null && softCanceller.check().isCancelled();
    }

    @Nullable
    private CompactedNodeState compactWithCache(@NotNull NodeState before, @NotNull NodeState after, @NotNull NodeState onto, @NotNull Canceller hardCanceller, @Nullable Canceller softCanceller) throws IOException {
        CompactedNodeState compacted = this.cpCache.get(after);
        if (compacted == null) {
            compacted = this.compactor.compact(before, after, onto, hardCanceller, softCanceller);
            if (compacted != null && compacted.isComplete()) {
                this.cpCache.put(after, compacted);
            }
        } else {
            this.gcListener.info("found checkpoint in cache.", new Object[0]);
        }
        return compacted;
    }

    @NotNull
    private LinkedHashSet<String> collectSuperRootPaths(@NotNull NodeState superRootBefore, @NotNull NodeState superRootAfter) {
        final ArrayList checkpoints = new ArrayList();
        superRootAfter.getChildNode("checkpoints").compareAgainstBaseState(superRootBefore.getChildNode("checkpoints"), (NodeStateDiff)new DefaultNodeStateDiff(){

            public boolean childNodeAdded(String name, NodeState after) {
                checkpoints.add(new MemoryChildNodeEntry(name, after));
                return true;
            }
        });
        checkpoints.sort((cne1, cne2) -> {
            long c1 = cne1.getNodeState().getLong("created");
            long c2 = cne2.getNodeState().getLong("created");
            return Long.compare(c1, c2);
        });
        LinkedHashSet<String> roots = new LinkedHashSet<String>();
        for (ChildNodeEntry checkpoint : checkpoints) {
            String name = checkpoint.getName();
            NodeState node = checkpoint.getNodeState();
            this.gcListener.info("found checkpoint {} created on {}.", new Object[]{name, new Date(node.getLong("created"))});
            roots.add("checkpoints/" + name);
        }
        roots.add("");
        return roots;
    }

    @NotNull
    private static NodeState getRoot(@NotNull NodeState node) {
        return node.hasChildNode("root") ? node.getChildNode("root") : EmptyNodeState.EMPTY_NODE;
    }

    private static <T> T getDescendant(T t, String path, BiFunction<T, String, T> getChild) {
        for (String name : PathUtils.elements((String)path)) {
            t = getChild.apply(t, name);
        }
        return t;
    }
}

