/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBLockClientOptions;
import com.amazonaws.services.dynamodbv2.document.BatchWriteItemOutcome;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.QueryOutcome;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.TableWriteItems;
import com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import com.amazonaws.services.dynamodbv2.document.utils.ValueMap;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.BillingMode;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.services.dynamodbv2.util.TableUtils;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.oak.segment.aws.DynamoDBProvisioningData;

public final class DynamoDBClient {
    private static final String TABLE_ATTR_TIMESTAMP = "timestamp";
    private static final String TABLE_ATTR_FILENAME = "filename";
    public static final String TABLE_ATTR_CONTENT = "content";
    private static final int TABLE_MAX_BATCH_WRITE_SIZE = 25;
    private static final String LOCKTABLE_KEY = "key";
    private final AmazonDynamoDB ddb;
    private final String journalTableName;
    private final Table journalTable;
    private final String lockTableName;
    private DynamoDBProvisioningData provisioningData;

    public DynamoDBClient(AmazonDynamoDB ddb, String journalTableName, String lockTableName) {
        this(ddb, journalTableName, lockTableName, DynamoDBProvisioningData.DEFAULT);
    }

    public DynamoDBClient(AmazonDynamoDB ddb, String journalTableName, String lockTableName, DynamoDBProvisioningData provisioningData) {
        this.ddb = ddb;
        this.journalTableName = journalTableName;
        this.journalTable = new DynamoDB(ddb).getTable(journalTableName);
        this.lockTableName = lockTableName;
        this.provisioningData = provisioningData == null ? DynamoDBProvisioningData.DEFAULT : provisioningData;
    }

    public void ensureTables() throws IOException {
        try {
            CreateTableRequest createJournalTableRequest = new CreateTableRequest().withTableName(this.journalTableName).withKeySchema(new KeySchemaElement(TABLE_ATTR_FILENAME, KeyType.HASH), new KeySchemaElement(TABLE_ATTR_TIMESTAMP, KeyType.RANGE)).withAttributeDefinitions(new AttributeDefinition(TABLE_ATTR_FILENAME, ScalarAttributeType.S), new AttributeDefinition(TABLE_ATTR_TIMESTAMP, ScalarAttributeType.N)).withBillingMode(this.provisioningData.getBillingMode());
            this.ensureTable(createJournalTableRequest, this.provisioningData.getJournalTableProvisionedRcu(), this.provisioningData.getJournalTableProvisionedWcu());
            CreateTableRequest createLockTableRequest = new CreateTableRequest().withTableName(this.lockTableName).withKeySchema(new KeySchemaElement(LOCKTABLE_KEY, KeyType.HASH)).withAttributeDefinitions(new AttributeDefinition(LOCKTABLE_KEY, ScalarAttributeType.S)).withBillingMode(this.provisioningData.getBillingMode());
            this.ensureTable(createLockTableRequest, this.provisioningData.getLockTableProvisionedRcu(), this.provisioningData.getLockTableProvisionedWcu());
        }
        catch (SdkClientException | InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void ensureTable(CreateTableRequest createTableRequest, Long tableRcu, Long tableWcu) throws InterruptedException {
        if (this.provisioningData.getBillingMode().equals((Object)BillingMode.PROVISIONED)) {
            createTableRequest.withProvisionedThroughput(new ProvisionedThroughput(tableRcu, tableWcu));
        }
        TableUtils.createTableIfNotExists(this.ddb, createTableRequest);
        TableUtils.waitUntilActive(this.ddb, createTableRequest.getTableName());
    }

    private boolean updateBillingMode(Table table, Long tableRcu, Long tableWcu) {
        BillingMode currentBillingMode = BillingMode.valueOf(table.describe().getBillingModeSummary().getBillingMode());
        ProvisionedThroughputDescription throughputDescription = table.getDescription().getProvisionedThroughput();
        if (currentBillingMode != this.provisioningData.getBillingMode() || this.provisioningData.getBillingMode() == BillingMode.PROVISIONED && (!throughputDescription.getReadCapacityUnits().equals(tableRcu) || !throughputDescription.getReadCapacityUnits().equals(tableWcu))) {
            UpdateTableRequest tableUpdateRequest = new UpdateTableRequest().withTableName(table.getTableName()).withBillingMode(this.provisioningData.getBillingMode());
            if (this.provisioningData.getBillingMode().equals((Object)BillingMode.PROVISIONED)) {
                tableUpdateRequest.withProvisionedThroughput(new ProvisionedThroughput(tableRcu, tableWcu));
            }
            this.ddb.updateTable(tableUpdateRequest);
            return true;
        }
        return false;
    }

    public String getConfig() {
        return this.journalTableName + ";" + this.lockTableName;
    }

    public AmazonDynamoDBLockClientOptions.AmazonDynamoDBLockClientOptionsBuilder getLockClientOptionsBuilder() {
        return AmazonDynamoDBLockClientOptions.builder(this.ddb, this.lockTableName).withPartitionKeyName(LOCKTABLE_KEY);
    }

    public void deleteAllDocuments(String fileName) throws IOException {
        List primaryKeys = this.getDocumentsStream(fileName).map(item -> new PrimaryKey(TABLE_ATTR_FILENAME, item.getString(TABLE_ATTR_FILENAME), TABLE_ATTR_TIMESTAMP, item.getNumber(TABLE_ATTR_TIMESTAMP))).collect(Collectors.toList());
        for (int i = 0; i < primaryKeys.size(); i += 25) {
            PrimaryKey[] currentKeys = new PrimaryKey[Math.min(25, primaryKeys.size() - i)];
            for (int j = 0; j < currentKeys.length; ++j) {
                currentKeys[j] = (PrimaryKey)primaryKeys.get(i + j);
            }
            new DynamoDB(this.ddb).batchWriteItem(new TableWriteItems(this.journalTableName).withPrimaryKeysToDelete(currentKeys));
        }
    }

    public List<String> getDocumentContents(String fileName) throws IOException {
        return this.getDocumentsStream(fileName).map(item -> item.getString(TABLE_ATTR_CONTENT)).collect(Collectors.toList());
    }

    public Stream<Item> getDocumentsStream(String fileName) throws IOException {
        String FILENAME_KEY = ":v_filename";
        QuerySpec spec = new QuerySpec().withScanIndexForward(false).withKeyConditionExpression("filename = " + FILENAME_KEY).withValueMap(new ValueMap().withString(FILENAME_KEY, fileName));
        try {
            ItemCollection<QueryOutcome> outcome = this.journalTable.query(spec);
            return StreamSupport.stream(outcome.spliterator(), false);
        }
        catch (AmazonServiceException e) {
            throw new IOException(e);
        }
    }

    public void batchPutDocument(String fileName, List<String> lines) {
        List<Item> items = lines.stream().map(content -> this.toItem(fileName, (String)content)).collect(Collectors.toList());
        this.batchPutDocumentItems(fileName, items);
    }

    public void batchPutDocumentItems(String fileName, List<Item> items) {
        items.forEach(item -> item.withString(TABLE_ATTR_FILENAME, fileName));
        AtomicInteger counter = new AtomicInteger();
        items.stream().collect(Collectors.groupingBy(x -> counter.getAndIncrement() / 25)).values().forEach(chunk -> this.putDocumentsChunked((List<Item>)chunk));
    }

    private void putDocumentsChunked(List<Item> items) {
        DynamoDB dynamoDB = new DynamoDB(this.ddb);
        TableWriteItems table = new TableWriteItems(this.journalTableName);
        BatchWriteItemOutcome outcome = dynamoDB.batchWriteItem(table.withItemsToPut(items));
        do {
            Map<String, List<WriteRequest>> unprocessedItems = outcome.getUnprocessedItems();
            if (outcome.getUnprocessedItems().size() <= 0) continue;
            outcome = dynamoDB.batchWriteItemUnprocessed(unprocessedItems);
        } while (outcome.getUnprocessedItems().size() > 0);
    }

    public void putDocument(String fileName, String line) throws IOException {
        Item item = this.toItem(fileName, line);
        try {
            this.journalTable.putItem(item);
        }
        catch (AmazonServiceException e) {
            throw new IOException(e);
        }
    }

    public Item toItem(String fileName, String line) {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new Item().with(TABLE_ATTR_TIMESTAMP, new Date().getTime()).with(TABLE_ATTR_FILENAME, fileName).with(TABLE_ATTR_CONTENT, line);
    }
}

